/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.xpath.XPath;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.xml.Extractor;
import org.openconcerto.xml.JDOMUtils;

public class ElementOrganizer<T> {
    private final List<Extractor<T>> propExtractors;
    private final Comparator<T> propComp;

    public ElementOrganizer(List<Extractor<T>> extractors, Comparator<T> propComp) {
        this.propExtractors = extractors;
        if (this.propExtractors.size() == 0) {
            throw new IllegalArgumentException("Empty property extractors");
        }
        this.propComp = propComp;
    }

    public ElementOrganizer(List<Extractor<T>> extractors, List<Comparator<T>> propComp) {
        this(extractors, propComp == null ? null : CompareUtils.createComparator(propComp));
    }

    public final Element organize(Collection<? extends T> col) {
        ArrayList<T> l = new ArrayList<T>(col);
        if (this.propComp != null) {
            Collections.sort(l, this.propComp);
        }
        Element res = new Element("root");
        for (Object item : l) {
            Element elem = res;
            int i = 0;
            while (i < this.propExtractors.size()) {
                Extractor extractor = this.propExtractors.get(i);
                try {
                    XPath xpath = extractor.getXPath(item);
                    Element itemElem = (Element)xpath.selectSingleNode(elem);
                    if (itemElem == null) {
                        Element newElement = extractor.createElement(item);
                        elem.addContent(newElement);
                        elem = newElement;
                    } else {
                        Parent parent = itemElem.getParent();
                        if (parent.indexOf(itemElem) != parent.getContentSize() - 1) {
                            throw new IllegalStateException("noncoherent sort: " + item + " would have been added in " + JDOMUtils.output(itemElem) + "\nof\n" + JDOMUtils.output(res));
                        }
                        elem = itemElem;
                    }
                }
                catch (JDOMException e) {
                    throw ExceptionUtils.createExn(IllegalStateException.class, "xpath pb", e);
                }
                ++i;
            }
        }
        return res;
    }
}

