/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.html;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.utils.html.HTMLContent;
import org.openconcerto.utils.html.HTMLDiv;
import org.openconcerto.utils.html.HTMLElement;
import org.openconcerto.utils.html.HTMLTitle;

public class HTMLFile {
    private String content = "";
    private String root;
    private String path;

    public HTMLFile(String f) {
        this(new File(f));
    }

    public HTMLFile(File f) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                this.content = String.valueOf(this.content) + line;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized HTMLDiv getDivClass(String divName) {
        return this.getDiv(divName, "class");
    }

    public synchronized HTMLDiv getDivId(String divName) {
        return this.getDiv(divName, "id");
    }

    public synchronized HTMLDiv getDiv(String divName, String ref) {
        String string = "<div.+" + ref + "=\\\"" + divName + "\\\".*?>";
        Pattern p = Pattern.compile(string);
        Matcher m = p.matcher(this.content);
        if (!m.find()) {
            System.err.println("Unable to find:" + string);
            System.err.println("Unable to find in:" + this.content);
            return null;
        }
        String divContent = this.content.substring(m.end());
        int stop = this.getEnd(divContent, "div");
        HTMLDiv div = new HTMLDiv(divName, divContent.substring(0, stop), ref);
        return div;
    }

    private int getEnd(String divContent, String tagName) {
        int level = 0;
        int stop = 0;
        if (tagName.length() > 5) {
            throw new IllegalArgumentException(String.valueOf(tagName) + "too long");
        }
        int length = divContent.length();
        int i = 0;
        while (i < length - 6) {
            char c1 = divContent.charAt(i);
            char c2 = divContent.charAt(i + 1);
            char c3 = divContent.charAt(i + 2);
            char c4 = divContent.charAt(i + 3);
            char c5 = divContent.charAt(i + 4);
            char c6 = divContent.charAt(i + 5);
            char c7 = divContent.charAt(i + 6);
            char c8 = divContent.charAt(i + 7);
            String word = "" + c1 + c2 + c3 + c4 + c5 + c6 + c7 + c8;
            if ((word = word.toLowerCase()).startsWith("</" + tagName + ">")) {
                --level;
            } else if (word.startsWith("<" + tagName)) {
                ++level;
            }
            stop = i++;
            if (level < 0) break;
        }
        return stop;
    }

    public synchronized void saveAs(File file) {
        String currentContent = this.content;
        try {
            BufferedWriter fR = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            fR.append(currentContent);
            fR.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void saveAs(String s) {
        File file = new File(s);
        this.saveAs(file);
        this.path = s;
    }

    public void saveAs(String root, String s) {
        this.saveAs(String.valueOf(root) + "/" + s);
        this.root = root;
        this.path = s;
    }

    public void setTitle(String s) {
        this.replaceContent((HTMLElement)new HTMLTitle("", ""), s);
    }

    public static void main(String[] args) {
        HTMLFile f = new HTMLFile("c:\\index.html");
        f.setTitle("New feature of Framework Utils:");
        HTMLDiv d = f.getDivClass("story");
        f.replaceContent((HTMLElement)d, "<p>HTML manipulation! oh oui</p>");
        f.saveAs("c:\\features.html");
    }

    public synchronized void replaceContent(HTMLElement element, String tagcontent) {
        String string = element.getName().length() > 0 ? "<" + element.getTagName() + ".+" + element.getRef() + "=\\\"" + element.getName() + "\\\".*?>" : "<" + element.getTagName() + ".*?>";
        Pattern p = Pattern.compile(string);
        Matcher m = p.matcher(this.content);
        if (!m.find()) {
            throw new IllegalStateException("Unable to find:" + string);
        }
        int end2 = m.end();
        String newContent = this.content.substring(0, end2);
        String t = this.content.substring(end2);
        int endDiv = this.getEnd(t, element.getTagName());
        newContent = newContent.concat(tagcontent);
        this.content = newContent = newContent.concat(t.substring(endDiv));
    }

    public String getContent() {
        return this.content;
    }

    public void writeTo(OutputStream outputStream) {
        String currentContent = this.content;
        try {
            BufferedWriter fR = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF8"));
            fR.append(currentContent);
            fR.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setBodyId(String id) {
        String string = "<body.*?>";
        this.content = this.content.replaceFirst(string, "<body id=\"" + id + "\">");
    }

    public void replaceContent(HTMLElement element, HTMLContent content2) {
        this.replaceContent(element, content2.getHTMLCode());
    }

    public String getRoot() {
        return this.root;
    }

    public String getPath() {
        return this.path;
    }

    public void setDescription(String description) {
    }
}

