/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class TimeUtils {
    private static DatatypeFactory typeFactory = null;

    public static final DatatypeFactory getTypeFactory() {
        if (typeFactory == null) {
            try {
                typeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }
        return typeFactory;
    }

    public static final Duration timePartToDuration(Calendar cal) {
        BigDecimal seconds = BigDecimal.valueOf(cal.get(13)).add(BigDecimal.valueOf(cal.get(14)).movePointLeft(3));
        return TimeUtils.getTypeFactory().newDuration(true, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.valueOf(cal.get(11)), BigInteger.valueOf(cal.get(12)), seconds);
    }

    public static final long normalizeLocalTime(Calendar cal) {
        return cal.getTimeInMillis() + (long)cal.getTimeZone().getOffset(cal.getTimeInMillis());
    }

    public static final Calendar copyLocalTime(Calendar from, Calendar to) {
        to.clear();
        int[] nArray = new int[]{1, 6, 11, 12, 13, 14};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int field = nArray[n2];
            to.set(field, from.get(field));
            ++n2;
        }
        return to;
    }
}

