/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.utils.MessageDigestUtils;

public class StringUtils {
    public static final Charset UTF8 = Charset.forName("UTF8");
    public static final Charset UTF16 = Charset.forName("UTF-16");
    public static final Charset ASCII = Charset.forName("ASCII");
    public static final Charset ISO8859_1 = Charset.forName("ISO8859_1");
    public static final Charset Cp1252 = Charset.forName("Cp1252");
    public static final Charset Cp850 = Charset.forName("Cp850");
    private static final Pattern quotePatrn = Pattern.compile("([\\\\]*)\"");
    private static final Pattern endSlashPatrn = Pattern.compile("([\\\\]*)\\z");

    public static String firstUpThenLow(String s) {
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1).toLowerCase();
    }

    public static String firstUp(String s) {
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static final int getLeastMaximum() {
        return Shortener.ORDERED[Shortener.ORDERED.length - 1].getMinStringLength();
    }

    private static final Shortener getShortener(int l) {
        Shortener[] shortenerArray = Shortener.ORDERED;
        int n = Shortener.ORDERED.length;
        int n2 = 0;
        while (n2 < n) {
            Shortener sh = shortenerArray[n2];
            if (l >= sh.getMinStringLength()) {
                return sh;
            }
            ++n2;
        }
        return null;
    }

    public static final String getBoundedLengthString(String s, int maxLength) throws IllegalArgumentException {
        if (maxLength < StringUtils.getLeastMaximum()) {
            throw new IllegalArgumentException("Maximum too low : " + maxLength + "<" + StringUtils.getLeastMaximum());
        }
        String res = s.length() <= maxLength ? s : StringUtils.getShortener(maxLength).shorten(s, maxLength);
        return res;
    }

    public static final List<String> fastSplit(String string, char sep) {
        ArrayList<String> l = new ArrayList<String>();
        int length = string.length();
        char[] cars = string.toCharArray();
        int rfirst = 0;
        int i = 0;
        while (i < length) {
            if (cars[i] == sep) {
                l.add(new String(cars, rfirst, i - rfirst));
                rfirst = i + 1;
            }
            ++i;
        }
        if (rfirst < length) {
            l.add(new String(cars, rfirst, length - rfirst));
        }
        return l;
    }

    public static String splitString(String s, int nbCharMaxLine) {
        if (s == null) {
            return s;
        }
        if (s.trim().length() < nbCharMaxLine) {
            return s;
        }
        StringBuffer lastString = new StringBuffer();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char charAt;
            if (lastString.length() == nbCharMaxLine) {
                int esp = lastString.lastIndexOf(" ");
                if (result.length() > 0 && result.charAt(result.length() - 1) != '\n') {
                    result.append("\n");
                }
                if (esp > 0) {
                    result.append(lastString.substring(0, esp).toString().trim());
                    lastString = new StringBuffer(lastString.substring(esp, lastString.length()));
                } else {
                    result.append(lastString.toString().trim());
                    lastString = new StringBuffer();
                }
                result.append("\n");
            }
            if ((charAt = s.charAt(i)) == '\n') {
                lastString.append(charAt);
                result.append(lastString);
                lastString = new StringBuffer();
            } else {
                lastString.append(charAt);
            }
            ++i;
        }
        if (result.length() > 0 && result.charAt(result.length() - 1) != '\n') {
            result.append("\n");
        }
        result.append(lastString.toString().trim());
        return result.toString();
    }

    public static String doubleQuote(String s) {
        if (s.length() > 0) {
            s = quotePatrn.matcher(s).replaceAll("$1$1\\\\\"");
            s = endSlashPatrn.matcher(s).replaceAll("$1$1");
        }
        return String.valueOf('\"') + s + '\"';
    }

    public static String rightAlign(String s, int width) {
        String r = s;
        int n = width - s.length();
        int i = 0;
        while (i < n) {
            r = String.valueOf(' ') + r;
            ++i;
        }
        return r;
    }

    public static String leftAlign(String s, int width) {
        String r = s;
        int n = width - s.length();
        int i = 0;
        while (i < n) {
            r = String.valueOf(r) + ' ';
            ++i;
        }
        return r;
    }

    public static final class Escaper {
        private final char esc;
        private final Map<Character, Character> substitution;
        private final Map<Character, Character> inv;

        public Escaper(char esc, char name) {
            this.esc = esc;
            this.substitution = new LinkedHashMap<Character, Character>();
            this.inv = new HashMap<Character, Character>();
            this.add(esc, name);
        }

        public Escaper add(char toRemove, char escapedName) {
            if (this.inv.containsKey(Character.valueOf(escapedName))) {
                throw new IllegalArgumentException(String.valueOf(escapedName) + " already replaces " + this.inv.get(Character.valueOf(escapedName)));
            }
            this.substitution.put(Character.valueOf(toRemove), Character.valueOf(escapedName));
            this.inv.put(Character.valueOf(escapedName), Character.valueOf(toRemove));
            return this;
        }

        public final Set<Character> getEscapedChars() {
            HashSet<Character> res = new HashSet<Character>(this.substitution.keySet());
            res.remove(Character.valueOf(this.esc));
            return res;
        }

        public final String escape(String s) {
            String res = s;
            for (Character toEsc : this.substitution.keySet()) {
                res = res.replace("" + toEsc, this.getEscaped(toEsc));
            }
            return res;
        }

        private String getEscaped(Character toEsc) {
            return String.valueOf(this.esc) + this.substitution.get(toEsc);
        }

        public final String unescape(String escaped) {
            String res = escaped;
            ArrayList<Character> toEscs = new ArrayList<Character>(this.substitution.keySet());
            Collections.reverse(toEscs);
            for (Character toEsc : toEscs) {
                res = res.replaceAll(this.getEscaped(toEsc), "" + toEsc);
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Escaper) {
                Escaper o = (Escaper)obj;
                return this.esc == o.esc && this.substitution.equals(o.substitution);
            }
            return false;
        }

        public int hashCode() {
            return this.esc + this.substitution.hashCode();
        }
    }

    public static abstract class Shortener {
        private final int hashSize;
        private final int hashPartSize;
        private final String prefix;
        private final String suffix;
        private final int minStringLength;
        public static final Shortener Ellipsis = new Shortener(1, "", "", 1){

            @Override
            protected String shorten(String s) {
                return "\u2026";
            }
        };
        public static final Shortener JavaHashCode = new Shortener(8, "#", "#", 3){

            @Override
            protected String shorten(String s) {
                return MessageDigestUtils.asHex(MessageDigestUtils.int2bytes(s.hashCode()));
            }
        };
        public static final Shortener MD5 = new Shortener(32, "#", "#", 11){

            @Override
            protected String shorten(String s) {
                return MessageDigestUtils.getHashString(MessageDigestUtils.getMD5(), s.getBytes(UTF8));
            }
        };
        static final Shortener[] ORDERED = new Shortener[]{MD5, JavaHashCode, Ellipsis};

        protected Shortener(int hashSize, String prefix, String suffix, int minCharsBeforeAndAfter) {
            this.hashSize = hashSize;
            this.prefix = prefix;
            this.suffix = suffix;
            this.hashPartSize = this.hashSize + this.prefix.length() + this.suffix.length();
            if (minCharsBeforeAndAfter < 1) {
                throw new IllegalArgumentException("minCharsBeforeAndAfter must be at least 1: " + minCharsBeforeAndAfter);
            }
            this.minStringLength = this.hashPartSize + minCharsBeforeAndAfter * 2;
        }

        public final int getMinStringLength() {
            return this.minStringLength;
        }

        public final String getBoundedLengthString(String s, int maxLength) {
            if (maxLength < this.getMinStringLength()) {
                throw new IllegalArgumentException("Maximum too low : " + maxLength + "<" + this.getMinStringLength());
            }
            if (s.length() <= maxLength) {
                return s;
            }
            return this.shorten(s, maxLength);
        }

        final String shorten(String s, int maxLength) {
            assert (s.length() >= this.getMinStringLength());
            int toRemoveLength = s.length() - maxLength + this.hashPartSize;
            int toRemoveStartIndex = s.length() / 2 - toRemoveLength / 2;
            String toHash = s.substring(toRemoveStartIndex, toRemoveStartIndex + toRemoveLength);
            String hash = this.shorten(toHash);
            assert (this.hashSize == hash.length());
            String res = String.valueOf(s.substring(0, toRemoveStartIndex)) + this.prefix + hash + this.suffix + s.substring(toRemoveStartIndex + toRemoveLength);
            assert (res.length() == maxLength);
            return res;
        }

        protected abstract String shorten(String var1);
    }
}

