/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class StreamUtils {
    public static final OutputStream NULL_OS = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
        }
    };
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static void copy(InputStream in, OutputStream out) throws IOException {
        StreamUtils.copy(in, out, 524288);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int count;
        byte[] buffer = new byte[bufferSize];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
    }

    public static void copy(InputStream ins, File out) throws IOException {
        BufferedOutputStream ous = new BufferedOutputStream(new FileOutputStream(out));
        try {
            StreamUtils.copy(ins, ous);
        }
        finally {
            ((OutputStream)ous).close();
        }
    }

    public static void writeln(String s, OutputStream out) throws IOException {
        StreamUtils.write(String.valueOf(s) + "\n", out);
    }

    public static void write(String s, OutputStream out) throws IOException {
        StreamUtils.write(s, out, UTF8);
    }

    public static void write(String s, OutputStream out, Charset charset) throws IOException {
        out.write(s.getBytes(charset));
    }
}

