/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.ui.table.IconCellRenderer;
import org.openconcerto.utils.JImage;

public class IconTableCellRenderer
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer,
ItemListener {
    private int va;
    private final List<JImage> images = new Vector<JImage>();
    IconCellRenderer renderer;

    public IconTableCellRenderer(List<URL> icons) {
        int i = 0;
        while (i < icons.size()) {
            URL filenameUrl = icons.get(i);
            JImage img = new JImage(filenameUrl);
            img.setCenterImage(true);
            img.check();
            img.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    System.out.println(e);
                    IconTableCellRenderer iconTableCellRenderer = IconTableCellRenderer.this;
                    iconTableCellRenderer.va = iconTableCellRenderer.va + 1;
                    if (IconTableCellRenderer.this.va >= IconTableCellRenderer.this.images.size()) {
                        IconTableCellRenderer.this.va = 0;
                    }
                    IconTableCellRenderer.this.stopCellEditing();
                }
            });
            this.images.add(img);
            ++i;
        }
        this.renderer = new IconCellRenderer(this.images);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.va = (Integer)value;
        JImage image = this.images.get(this.va);
        return image;
    }

    @Override
    public Object getCellEditorValue() {
        return new Integer(this.va);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        System.out.println("IconTableCellRenderer.itemStateChanged()");
    }
}

