/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.group;

public class LayoutHints {
    private boolean maximizeWidth;
    private boolean maximizeHeight;
    private boolean showLabel;
    private boolean separated;
    private boolean fill;
    public static final LayoutHints DEFAULT_FIELD_HINTS = new LayoutHints(false, false, true, false);
    public static final LayoutHints DEFAULT_LARGE_FIELD_HINTS = new LayoutHints(true, false, true, false);
    public static final LayoutHints DEFAULT_LIST_HINTS = new LayoutHints(true, true, false, false, true);
    public static final LayoutHints DEFAULT_GROUP_HINTS = new LayoutHints(false, false, false, false);
    public static final LayoutHints DEFAULT_LARGE_GROUP_HINTS = new LayoutHints(true, false, false, false);
    public static final LayoutHints DEFAULT_SEPARATED_GROUP_HINTS = new LayoutHints(true, false, false, true);

    public LayoutHints(boolean maximizeWidth, boolean maximizeHeight, boolean showLabel, boolean separated) {
        this.maximizeWidth = maximizeWidth;
        this.maximizeHeight = maximizeHeight;
        this.showLabel = showLabel;
        this.separated = separated;
        this.fill = false;
    }

    public LayoutHints(boolean maximizeWidth, boolean maximizeHeight, boolean showLabel, boolean separated, boolean fill) {
        this.maximizeWidth = maximizeWidth;
        this.maximizeHeight = maximizeHeight;
        this.showLabel = showLabel;
        this.separated = separated;
        this.fill = fill;
    }

    public boolean maximizeWidth() {
        return this.maximizeWidth;
    }

    public boolean maximizeHeight() {
        return this.maximizeHeight;
    }

    public boolean showLabel() {
        return this.showLabel;
    }

    public boolean isSeparated() {
        return this.separated;
    }

    public boolean fill() {
        return this.fill;
    }

    public String toString() {
        String r = "";
        if (this.maximizeHeight && this.maximizeWidth) {
            r = String.valueOf(r) + "MaxW&H";
        } else {
            if (this.maximizeHeight) {
                r = String.valueOf(r) + "MaxH";
            }
            if (this.maximizeWidth) {
                r = String.valueOf(r) + "MaxW";
            }
        }
        r = this.showLabel && this.separated ? String.valueOf(r) + " SeparatedLabel" : (this.showLabel ? String.valueOf(r) + " StdLabel" : String.valueOf(r) + " NoLabel");
        if (this.fill) {
            r = String.valueOf(r) + " Fill";
        }
        return r;
    }
}

