/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.openconcerto.ui.group.LayoutHints;
import org.openconcerto.utils.Tuple3;

public class Group {
    private final String id;
    private int order = 0;
    private List<Tuple3<Group, LayoutHints, Integer>> list = new ArrayList<Tuple3<Group, LayoutHints, Integer>>();
    private Group parent;

    public Group(String id) {
        this.id = id.trim();
    }

    public String getId() {
        return this.id;
    }

    public Group getParent() {
        return this.parent;
    }

    public Group getRoot() {
        HashSet<String> roots = new HashSet<String>();
        Group root = this.parent;
        while (root != null) {
            if (roots.contains(root)) {
                throw new IllegalStateException("Loop detected in group hierarchy at " + root.getId() + " for " + roots);
            }
            roots.add(root.getId());
            root = root.getParent();
        }
        return root;
    }

    public void add(Group group) {
        this.add(group, LayoutHints.DEFAULT_GROUP_HINTS);
    }

    public void add(Group group, LayoutHints hints) {
        group.parent = this;
        this.order += 100;
        this.list.add(new Tuple3<Group, LayoutHints, Integer>(group, hints, this.order));
    }

    public void insert(Group group, LayoutHints hints, int order) {
        group.parent = this;
        this.list.add(new Tuple3<Group, LayoutHints, Integer>(group, hints, order));
    }

    public void add(String string) {
        this.add(new Group(string), LayoutHints.DEFAULT_FIELD_HINTS);
    }

    public void add(String string, LayoutHints hints) {
        this.add(new Group(string), hints);
    }

    public void dumpOneColumn() {
        StringBuilder b = new StringBuilder();
        this.dumpOneColumn(b, LayoutHints.DEFAULT_GROUP_HINTS, 0, 1);
        System.out.println(b.toString());
    }

    public void dumpOneColumn(StringBuilder builder, LayoutHints localHint, int localOrder, int level) {
        int i = 0;
        while (i < level - 1) {
            builder.append("  ");
            ++i;
        }
        if (this.list.size() == 0) {
            builder.append("+-- ");
        } else {
            builder.append("+-+ ");
        }
        builder.append(String.valueOf(localOrder) + " " + this.id + " [" + localHint + "]\n");
        this.sortSubGroup();
        for (Tuple3<Group, LayoutHints, Integer> tuple : this.list) {
            ((Group)tuple.get0()).dumpOneColumn(builder, (LayoutHints)tuple.get1(), tuple.get2(), level + 1);
        }
    }

    private void sortSubGroup() {
        if (this.list.size() > 1) {
            Collections.sort(this.list, new Comparator<Tuple3<Group, LayoutHints, Integer>>(){

                @Override
                public int compare(Tuple3<Group, LayoutHints, Integer> o1, Tuple3<Group, LayoutHints, Integer> o2) {
                    int c = o1.get2().compareTo(o2.get2());
                    if (c == 0) {
                        c = ((Group)o1.get0()).getId().compareTo(((Group)o2.get0()).getId());
                    }
                    return c;
                }
            });
        }
    }

    public void dumpTwoColumn() {
        StringBuilder b = new StringBuilder();
        this.dumpTwoColumn(b, 0, LayoutHints.DEFAULT_GROUP_HINTS, 0, 1);
        System.out.println(b.toString());
    }

    public int dumpTwoColumn(StringBuilder builder, int x, LayoutHints localHint, int localOrder, int level) {
        if (localHint.isSeparated()) {
            x = 0;
            builder.append("\n");
        }
        if (this.isEmpty()) {
            builder.append(" (" + x + ")");
            builder.append(String.valueOf(localOrder) + " " + this.id + "[" + localHint + "]");
            if (x % 2 == 1) {
                builder.append("\n");
            }
        }
        this.sortSubGroup();
        for (Tuple3<Group, LayoutHints, Integer> tuple : this.list) {
            Group subGroup = (Group)tuple.get0();
            Integer subGroupOrder = tuple.get2();
            x = subGroup.dumpTwoColumn(builder, x, (LayoutHints)tuple.get1(), subGroupOrder, level + 1);
        }
        if (this.isEmpty()) {
            ++x;
        }
        if (!localHint.isSeparated() && this.list.size() != 0 && localHint.maximizeWidth()) {
            x = 0;
            builder.append("\n");
        }
        return x;
    }

    public int getSize() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void sort() {
        this.sortSubGroup();
        for (Tuple3<Group, LayoutHints, Integer> tuple : this.list) {
            Group subGroup = (Group)tuple.get0();
            subGroup.sort();
        }
    }

    public Group getGroup(int i) {
        return (Group)this.list.get(i).get0();
    }

    public LayoutHints getLayoutHints(int i) {
        return (LayoutHints)this.list.get(i).get1();
    }

    public Integer getOrder(int i) {
        return this.list.get(i).get2();
    }
}

