/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.coreanimation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.openconcerto.ui.coreanimation.Pulse;

public class BasicTextAnimatorUI
extends BasicTextUI
implements Pulse {
    private BasicTextUI originalUi;
    private boolean isAnimating = false;
    int x = 0;
    int sens = 1;
    private JTextField f;
    protected Thread thread;
    int[] a;

    public void stopAnimation() {
        this.setAnimating(false);
    }

    public void startAnimation() {
        this.setAnimating(true);
    }

    @Override
    public void pulse() {
        if (this.sens > 0) {
            this.x += 2;
            if (this.x > this.f.getWidth()) {
                this.x = this.f.getWidth() - 5;
                this.sens = -1;
            }
        } else {
            this.x -= 2;
            if (this.x < -300) {
                this.x = 0;
                this.sens = 1;
            }
        }
        if (this.x >= 0) {
            this.f.repaint();
        }
    }

    synchronized void setAnimating(boolean isAnimating) {
        this.isAnimating = isAnimating;
    }

    synchronized boolean isAnimating() {
        return this.isAnimating;
    }

    public BasicTextAnimatorUI(BasicTextUI ui, JTextField f) {
        int[] nArray = new int[12];
        nArray[0] = 252;
        nArray[1] = 250;
        nArray[2] = 245;
        nArray[3] = 240;
        nArray[4] = 235;
        nArray[5] = 230;
        nArray[6] = 220;
        nArray[7] = 210;
        nArray[8] = 170;
        nArray[9] = 150;
        nArray[10] = 50;
        this.a = nArray;
        this.originalUi = ui;
        this.f = f;
        this.startAnimation();
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    @Override
    public void damageRange(JTextComponent t, int p0, int p1) {
        this.originalUi.damageRange(t, p0, p1);
    }

    @Override
    public void damageRange(JTextComponent t, int p0, int p1, Position.Bias firstBias, Position.Bias secondBias) {
        this.originalUi.damageRange(t, p0, p1, firstBias, secondBias);
    }

    @Override
    public EditorKit getEditorKit(JTextComponent t) {
        return this.originalUi.getEditorKit(t);
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return this.originalUi.getNextVisualPositionFrom(t, pos, b, direction, biasRet);
    }

    @Override
    public View getRootView(JTextComponent t) {
        return this.originalUi.getRootView(t);
    }

    @Override
    public Rectangle modelToView(JTextComponent t, int pos) throws BadLocationException {
        return this.originalUi.modelToView(t, pos);
    }

    @Override
    public Rectangle modelToView(JTextComponent t, int pos, Position.Bias bias) throws BadLocationException {
        return this.originalUi.modelToView(t, pos, bias);
    }

    @Override
    public int viewToModel(JTextComponent t, Point pt) {
        return this.originalUi.viewToModel(t, pt);
    }

    @Override
    public int viewToModel(JTextComponent t, Point pt, Position.Bias[] biasReturn) {
        return this.originalUi.viewToModel(t, pt, biasReturn);
    }

    @Override
    protected String getPropertyPrefix() {
        return "TextField";
    }

    @Override
    public void installUI(JComponent c) {
        this.originalUi.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.originalUi.uninstallUI(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        g.setColor(this.f.getBackground());
        g.fillRect(0, 0, this.f.getWidth(), this.f.getHeight());
        int height = c.getHeight();
        int i = 0;
        while (i < 12) {
            g.setColor(new Color(255, this.a[i], this.a[i]));
            g.drawLine(this.x + i * this.sens, 0, this.x + i * this.sens, height);
            ++i;
        }
        this.f.setOpaque(false);
        this.originalUi.update(g, c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.originalUi.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.originalUi.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.originalUi.getMaximumSize(c);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return this.originalUi.contains(c, x, y);
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        return this.originalUi.getBaseline(c, width, height);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        return this.originalUi.getBaselineResizeBehavior(c);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return this.originalUi.getAccessibleChildrenCount(c);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return this.originalUi.getAccessibleChild(c, i);
    }

    @Override
    public void resetState() {
    }
}

