/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.view.search.ColumnSearchSpec;
import org.openconcerto.sql.view.search.EmptySearchSpec;
import org.openconcerto.sql.view.search.SearchListComponent;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.sql.view.search.TextSearchSpec;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.model.ListComboBoxModel;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class SearchItemComponent
extends JPanel {
    private static final String TOUT = "Tout";
    private static final TextSearchSpec.Mode[] MODES = new TextSearchSpec.Mode[]{TextSearchSpec.Mode.CONTAINS, TextSearchSpec.Mode.CONTAINS_STRICT, TextSearchSpec.Mode.LESS_THAN, TextSearchSpec.Mode.EQUALS, TextSearchSpec.Mode.EQUALS_STRICT, TextSearchSpec.Mode.GREATER_THAN};
    private JTextField textFieldRecherche = new JTextField(10);
    private final JComboBox comboColonnePourRecherche = new JComboBox(new ListComboBoxModel());
    private final JComboBox searchMode;
    private JCheckBox invertSearch = new JCheckBox("inverser");
    private JButton buttonAdd = new JButton("+");
    private JButton buttonRemove = new JButton();
    final SearchListComponent list;
    private String text = "";

    public SearchItemComponent(SearchListComponent list) {
        this.list = list;
        this.setOpaque(false);
        this.searchMode = new JComboBox<String>(new String[]{"Contient", "Contient exactement", "Est inf\u00e9rieur \u00e0", "Est \u00e9gal \u00e0", "Est exactement \u00e9gal \u00e0", "Est sup\u00e9rieur \u00e0", "Est vide"});
        this.uiInit();
    }

    private void uiInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 2, 0, 2);
        c.fill = 2;
        final ListCellRenderer old = this.comboColonnePourRecherche.getRenderer();
        this.comboColonnePourRecherche.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return old.getListCellRendererComponent(list, ((Tuple2)value).get0(), index, isSelected, cellHasFocus);
            }
        });
        this.comboColonnePourRecherche.setMinimumSize(new Dimension(150, 20));
        this.comboColonnePourRecherche.setOpaque(false);
        this.add((Component)this.comboColonnePourRecherche, c);
        ++c.gridx;
        this.searchMode.setMinimumSize(new Dimension(40, 20));
        this.searchMode.setOpaque(false);
        this.add((Component)this.searchMode, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.textFieldRecherche.setMinimumSize(new Dimension(50, 20));
        this.add((Component)this.textFieldRecherche, c);
        c.weightx = 0.0;
        ++c.gridx;
        this.invertSearch.setOpaque(false);
        if (!Boolean.getBoolean("org.openconcerto.ui.removeSwapSearchCheckBox")) {
            this.add((Component)this.invertSearch, c);
        }
        ++c.gridx;
        this.buttonAdd.setOpaque(false);
        this.add((Component)this.buttonAdd, c);
        ++c.gridx;
        this.buttonRemove.setIcon(new ImageIcon(BaseSQLComponent.class.getResource("delete.png")));
        this.buttonRemove.setBorder(null);
        this.buttonRemove.setOpaque(false);
        this.buttonRemove.setBorderPainted(false);
        this.buttonRemove.setFocusPainted(false);
        this.buttonRemove.setContentAreaFilled(false);
        this.add((Component)this.buttonRemove, c);
        this.initCombo();
        this.initSearchText();
        this.initInvertSearch();
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchItemComponent.this.list.addNewSearchItem();
            }
        });
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchItemComponent.this.list.removeSearchItem(SearchItemComponent.this);
            }
        });
    }

    private void initInvertSearch() {
        this.invertSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchItemComponent.this.updateSearchList();
            }
        });
    }

    private void initSearchText() {
        this.textFieldRecherche.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                try {
                    SearchItemComponent.this.text = e.getDocument().getText(0, e.getDocument().getLength()).trim();
                    SearchItemComponent.this.updateSearchList();
                }
                catch (BadLocationException exn) {
                    exn.printStackTrace();
                }
            }
        });
    }

    private void initCombo() {
        int columnCount = this.list.getTableModel().getColumnCount();
        String[][] names = new String[columnCount][];
        int[] indexes = new int[columnCount];
        int i = 0;
        while (i < columnCount) {
            names[i] = this.list.getColumnNames(i);
            indexes[i] = 0;
            ++i;
        }
        SortedMap<String, Integer> map = this.solve(names, indexes);
        ArrayList<Tuple2<String, Integer>> cols = new ArrayList<Tuple2<String, Integer>>(columnCount);
        cols.add(Tuple2.create(TOUT, -1));
        for (Map.Entry<String, Integer> e : map.entrySet()) {
            cols.add(Tuple2.create(e.getKey(), e.getValue()));
        }
        ((ListComboBoxModel)this.comboColonnePourRecherche.getModel()).addAll(cols);
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SearchItemComponent.this.updateSearchList();
            }
        };
        this.comboColonnePourRecherche.addItemListener(listener);
        this.searchMode.addItemListener(listener);
    }

    private SortedMap<String, Integer> solve(String[][] names, int[] indexes) {
        int columnCount = names.length;
        CollectionMap collisions = new CollectionMap(columnCount);
        int i = 0;
        while (i < columnCount) {
            int index = indexes[i];
            if (index >= names[i].length) {
                throw new IllegalStateException("Ran out of names for " + i + " : " + Arrays.asList(names[i]));
            }
            String columnName = names[i][index];
            collisions.put(columnName, (Object)i);
            ++i;
        }
        TreeMap<String, Integer> res = new TreeMap<String, Integer>();
        for (Map.Entry e : collisions.entrySet()) {
            Collection indexesWithCollision = e.getValue();
            if (indexesWithCollision.size() > 1) {
                int minIndex = Integer.MAX_VALUE;
                for (Integer i2 : indexesWithCollision) {
                    if (indexes[i2] >= minIndex) continue;
                    minIndex = indexes[i2];
                }
                for (Integer i2 : indexesWithCollision) {
                    if (indexes[i2] != minIndex) continue;
                    int n = i2;
                    indexes[n] = indexes[n] + 1;
                }
                continue;
            }
            res.put((String)e.getKey(), (Integer)indexesWithCollision.iterator().next());
        }
        if (res.size() == columnCount) {
            return res;
        }
        return this.solve(names, indexes);
    }

    void updateSearchList() {
        this.list.updateSearch();
    }

    public SearchSpec getSearchItem() {
        SearchSpec res;
        if (this.searchMode.getSelectedIndex() < MODES.length) {
            TextSearchSpec textSpec = new TextSearchSpec(this.getText(), MODES[this.searchMode.getSelectedIndex()]);
            textSpec.setFormats(this.list.getFormats());
            res = textSpec;
        } else {
            res = new EmptySearchSpec();
        }
        return new ColumnSearchSpec(this.isExcluded(), res, this.getColIndex());
    }

    private final boolean isExcluded() {
        return this.invertSearch.isSelected();
    }

    private final int getColIndex() {
        return (Integer)((Tuple2)this.comboColonnePourRecherche.getSelectedItem()).get1();
    }

    private final String getText() {
        return this.text;
    }

    public final void setText(String s) {
        this.textFieldRecherche.setText(s);
    }

    public void resetState() {
        this.setText("");
        this.comboColonnePourRecherche.setSelectedIndex(0);
        this.searchMode.setSelectedIndex(0);
        this.invertSearch.setSelected(false);
    }

    public void setSearchFullMode(boolean b) {
        this.invertSearch.setVisible(b);
        this.buttonAdd.setVisible(b);
        this.buttonRemove.setVisible(b);
        this.comboColonnePourRecherche.setVisible(b);
        this.searchMode.setVisible(b);
    }
}

