/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.listview;

import java.util.Collections;
import org.apache.commons.collections.Closure;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.itemview.SimpleRowItemView;
import org.openconcerto.sql.view.listview.FFItemPool;
import org.openconcerto.sql.view.listview.ItemPool;
import org.openconcerto.sql.view.listview.ItemPoolFactory;
import org.openconcerto.sql.view.listview.ListSQLView;

public final class SharedFFItemPool
extends FFItemPool {
    public SharedFFItemPool(ItemPoolFactory parent, ListSQLView panel) {
        super(parent, panel);
    }

    @Override
    public SQLRowItemView getNewItem() throws IllegalStateException {
        if (!this.availableItem()) {
            throw new IllegalStateException("no more can be added");
        }
        SimpleRowItemView<Integer> newItem = new SimpleRowItemView<Integer>(new ElementComboBox());
        SQLField f = (SQLField)this.availables.remove(0);
        this.added.add(newItem);
        newItem.init(f.getName(), Collections.singleton(f));
        newItem.setDescription(this.getLabel(f));
        return newItem;
    }

    @Override
    public void update(final SQLRowValues vals) {
        ItemPool.Cl updateClosure = new ItemPool.Cl(){

            @Override
            public void execute(SQLRowItemView input) {
                input.update(vals);
            }
        };
        this.forAllDo(this.stills, updateClosure);
        this.forAllDo(this.added, updateClosure);
        ItemPool.Cl deleteClosure = new ItemPool.Cl(){

            @Override
            public void execute(SQLRowItemView input) {
                vals.putEmptyLink(input.getField().getName());
            }
        };
        this.forAllDo(this.removed, deleteClosure);
        this.forAllDo(this.availables, new Closure(){

            @Override
            public void execute(Object input) {
                vals.putEmptyLink(((SQLField)input).getName());
            }
        });
    }

    @Override
    public void insert(SQLRowValues vals) {
        this.update(vals);
    }
}

