/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.listview;

import java.util.Collections;
import org.apache.commons.collections.Closure;
import org.openconcerto.sql.element.DefaultElementSQLObject;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.view.listview.FFItemPool;
import org.openconcerto.sql.view.listview.ItemPool;
import org.openconcerto.sql.view.listview.ItemPoolFactory;
import org.openconcerto.sql.view.listview.ListSQLView;

public final class PrivateFFItemPool
extends FFItemPool {
    public PrivateFFItemPool(ItemPoolFactory parent, ListSQLView panel) {
        super(parent, panel);
    }

    @Override
    public SQLRowItemView getNewItem() throws IllegalStateException {
        if (!this.availableItem()) {
            throw new IllegalStateException("no more can be added");
        }
        SQLField f = (SQLField)this.availables.remove(0);
        SQLComponent parent = this.getPanel().getSQLParent();
        DefaultElementSQLObject newItem = new DefaultElementSQLObject(parent, parent.getElement().getPrivateElement(f.getName()).createDefaultComponent());
        newItem.setCreated(true);
        newItem.showSeparator(false);
        newItem.setDecorated(false);
        this.added.add(newItem);
        newItem.init(f.getName(), Collections.singleton(f));
        newItem.setDescription(this.getLabel(f));
        return newItem;
    }

    @Override
    protected void itemRemoved(SQLRowItemView v) {
        ((ElementSQLObject)v).setCreated(false);
    }

    @Override
    public void update(final SQLRowValues vals) {
        ItemPool.Cl updateClosure = new ItemPool.Cl(){

            @Override
            public void execute(SQLRowItemView input) {
                input.update(vals);
            }
        };
        this.forAllDo(this.stills, updateClosure);
        this.forAllDo(this.added, updateClosure);
        this.forAllDo(this.removed, updateClosure);
        this.forAllDo(this.availables, new Closure(){

            @Override
            public void execute(Object input) {
                vals.putEmptyLink(((SQLField)input).getName());
            }
        });
    }

    @Override
    public void insert(final SQLRowValues vals) {
        ItemPool.Cl insertClosure = new ItemPool.Cl(){

            @Override
            public void execute(SQLRowItemView input) {
                input.insert(vals);
            }
        };
        this.forAllDo(this.stills, insertClosure);
        this.forAllDo(this.added, insertClosure);
        this.forAllDo(this.removed, insertClosure);
    }
}

