/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;

public abstract class RowAction
implements IListeAction {
    private final Action action;
    private final boolean header;
    private final boolean popupMenu;
    private List<String> path;

    public static Action createAction(String name, Icon icon, final IClosure<List<SQLRowAccessor>> action) {
        return new AbstractAction(name, icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.executeChecked(IListe.get(e).getSelectedRows());
            }
        };
    }

    public RowAction(Action action, boolean header) {
        this(action, header, true);
    }

    public RowAction(Action action, boolean header, boolean popupMenu) {
        this.action = action;
        this.header = header;
        this.popupMenu = popupMenu;
        this.setGroup(null);
    }

    public final Action getAction() {
        return this.action;
    }

    public final boolean inHeader() {
        return this.header;
    }

    public final boolean inPopupMenu() {
        return this.popupMenu;
    }

    public final RowAction setGroup(String groupName) {
        this.path = Arrays.asList(groupName);
        return this;
    }

    public final RowAction setPath(List<String> path) {
        this.path = Collections.unmodifiableList(new ArrayList<String>(path));
        return this;
    }

    public final List<String> getPath() {
        return this.path;
    }

    public boolean enabledFor(List<SQLRowAccessor> selection) {
        throw new UnsupportedOperationException("Should overload this method or enabledFor(IListeEvent)");
    }

    public boolean enabledFor(IListeAction.IListeEvent evt) {
        return this.enabledFor(evt.getSelectedRows());
    }

    @Override
    public IListeAction.ButtonsBuilder getHeaderButtons() {
        return !this.inHeader() ? IListeAction.ButtonsBuilder.emptyInstance() : new IListeAction.ButtonsBuilder().add(new JButton(this.getAction()), new IPredicate<IListeAction.IListeEvent>(){

            @Override
            public boolean evaluateChecked(IListeAction.IListeEvent evt) {
                return RowAction.this.enabledFor(evt);
            }
        });
    }

    @Override
    public Action getDefaultAction(IListeAction.IListeEvent evt) {
        return null;
    }

    @Override
    public IListeAction.PopupBuilder getPopupContent(IListeAction.PopupEvent evt) {
        if (this.inPopupMenu() && evt.isClickOnRows()) {
            JMenuItem mi = new JMenuItem(this.getAction());
            mi.setEnabled(this.enabledFor(evt));
            IListeAction.PopupBuilder res = new IListeAction.PopupBuilder();
            res.getMenu().addItem(mi, this.getPath());
            return res;
        }
        return IListeAction.PopupBuilder.emptyInstance();
    }

    public static class PredicateRowAction
    extends RowAction {
        private IPredicate<? super IListeAction.IListeEvent> pred = null;

        public PredicateRowAction(Action action, boolean header) {
            super(action, header);
        }

        public PredicateRowAction(Action action, boolean header, boolean popupMenu) {
            super(action, header, popupMenu);
        }

        public final PredicateRowAction setPredicate(IPredicate<? super IListeAction.IListeEvent> pred) {
            if (pred == null) {
                throw new IllegalArgumentException("null predicate");
            }
            this.pred = pred;
            return this;
        }

        public final IPredicate<? super IListeAction.IListeEvent> getPredicate() {
            return this.pred;
        }

        @Override
        public boolean enabledFor(IListeAction.IListeEvent evt) {
            if (this.pred == null) {
                throw new IllegalStateException("No predicate for action:" + this.getAction() + ":" + this.getAction().getValue("Name"));
            }
            return this.pred.evaluateChecked(evt);
        }
    }
}

