/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.State;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.utils.FileUtils;

public class IListFrame
extends JFrame {
    private final IListPanel panel;
    private String title;

    public static final File getConfigFile(SQLElement elem, Class<? extends JFrame> c) {
        return IListFrame.getConfigFile(elem, null, c);
    }

    public static final File getConfigFile(SQLComponent comp, Class<? extends JFrame> c) {
        return IListFrame.getConfigFile(comp.getElement(), comp, c);
    }

    private static final File getConfigFile(SQLElement elem, SQLComponent comp, Class<? extends JFrame> c) {
        String compName = comp == null ? "" : "-" + comp.getClass().getName();
        String filename = String.valueOf(FileUtils.FILENAME_ESCAPER.escape(String.valueOf(elem.getPluralName()) + compName)) + "-window.xml";
        return new File(Configuration.getInstance().getConfDir(), "state-" + c.getSimpleName() + File.separator + filename);
    }

    public IListFrame(IListPanel panel) {
        this.panel = panel;
        this.title = null;
        this.panel.getListe().addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                IListFrame.this.setTitle();
            }
        });
        this.getPanel().getListe().addListenerOnModel(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || evt.getPropertyName().equals("loading") || evt.getPropertyName().equals("searching")) {
                    IListFrame.this.setTitle();
                }
            }
        });
        this.uiInit();
        State.INSTANCE.frameCreated();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                State.INSTANCE.frameHidden();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                State.INSTANCE.frameShown();
            }
        });
    }

    protected String getPlural(String s, int nb) {
        return String.valueOf(nb) + " " + s + (nb > 1 ? "s" : "");
    }

    protected void setTitle(boolean displayRowCount, boolean displayItemCount) {
        String title;
        if (this.title == null) {
            String prefix = Boolean.getBoolean("org.openconcerto.listframe.shortTitle") ? "" : "Liste des ";
            title = String.valueOf(prefix) + this.panel.getElement().getPluralName();
        } else {
            title = this.title;
        }
        if (this.panel.getListe().isDead()) {
            title = String.valueOf(title) + ", d\u00e9truite";
        } else {
            ITableModel model;
            int count;
            if (displayRowCount) {
                int rowCount = this.panel.getListe().getRowCount();
                title = String.valueOf(title) + ", " + this.getPlural("ligne", rowCount);
                int total = this.panel.getListe().getTotalRowCount();
                if (total != rowCount) {
                    title = String.valueOf(title) + " / " + total;
                }
            }
            if (displayItemCount && (count = this.panel.getListe().getItemCount()) >= 0) {
                title = String.valueOf(title) + ", " + this.getPlural("\u00e9l\u00e9ment", count);
            }
            if ((model = this.getPanel().getListe().getModel()).isLoading()) {
                title = String.valueOf(title) + ", chargement en cours";
            }
            if (model.isSearching()) {
                title = String.valueOf(title) + ", recherche en cours";
            }
        }
        this.setTitle(title);
    }

    public void setTextTitle(String s) {
        this.title = s;
    }

    public void setTitle() {
        this.setTitle(true, true);
    }

    private final void uiInit() {
        this.setTitle();
        this.getContentPane().setLayout(new GridLayout());
        this.getContentPane().add(this.panel);
        this.setBounds();
        File file = this.getPanel().getSQLComponent() != null ? IListFrame.getConfigFile(this.getPanel().getSQLComponent(), this.getClass()) : IListFrame.getConfigFile(this.getPanel().getElement(), this.getClass());
        new WindowStateManager(this, file).loadState();
    }

    protected final void setBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode dm = ge.getDefaultScreenDevice().getDisplayMode();
        int topOffset = 50;
        if (dm == null) {
            this.setLocation(0, 0);
            this.setSize(640, 480);
        } else if (dm.getWidth() <= 800 || dm.getHeight() <= 600) {
            this.setLocation(0, 50);
            this.setSize(dm.getWidth(), dm.getHeight() - 50);
        } else {
            this.setLocation(10, 50);
            this.setSize(dm.getWidth() - 50, dm.getHeight() - 20 - 50);
        }
    }

    public final IListPanel getPanel() {
        return this.panel;
    }
}

