/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.Constraint;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFieldsSet;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.DropTable;
import org.openconcerto.sql.utils.SQL_URL;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.cc.IClosure;

public class Diff {
    public static final String SIMPLE_SEQ = "org.openconcerto.sql.Diff.simpleSeq";
    private static final String ROOTS_TO_MAP = "rootsToMap";
    private final DBRoot a;
    private final DBRoot b;

    private static void usage() {
        System.out.println("Usage: " + Diff.class.getName() + " url1 url2 [tableName]...");
        System.out.println("Outputs SQL statements to patch url1. That is if you execute the statements on url1 it will become url2.");
        System.out.println("System properties: rootsToMap=list of roots to map");
    }

    public static void main(String[] args) throws URISyntaxException {
        if (args.length < 2) {
            Diff.usage();
            System.exit(1);
        }
        System.setProperty("org.openconcerto.sql.noautoCreateMetadata", "true");
        ProductInfo.setInstance(new ProductInfo(Diff.class.getName()));
        SQL_URL url1 = SQL_URL.create(args[0]);
        SQL_URL url2 = SQL_URL.create(args[1]);
        List<String> tables = args.length < 3 ? null : Arrays.asList(args).subList(2, args.length);
        DBRoot root1 = Diff.getRoot(url1);
        DBRoot root2 = Diff.getRoot(url2);
        Diff diff = new Diff(root1, root2);
        if (tables == null) {
            System.out.println(diff.compute());
        } else {
            System.out.println(diff.compute(tables));
        }
        root1.getServer().destroy();
        root2.getServer().destroy();
    }

    private static DBRoot getRoot(SQL_URL url1) {
        DBSystemRoot sysRoot = SQLServer.create(url1, SQLRow.toList(System.getProperty(ROOTS_TO_MAP, "")), new IClosure<SQLDataSource>(){

            @Override
            public void executeChecked(SQLDataSource input) {
                input.addConnectionProperty("allowMultiQueries", "true");
            }
        });
        return sysRoot.getRoot(url1.getRootName());
    }

    private static String getDesc(DBRoot root) {
        SQL_URL url = root.getURL();
        if (url != null) {
            return url.asString();
        }
        return "root " + SQLBase.quoteIdentifier(root.getName()) + " of " + root.getDBSystemRoot().getDataSource().getUrl();
    }

    public Diff(DBRoot a, DBRoot b) {
        this.a = a;
        this.b = b;
    }

    private final String getHeader(Collection<String> tableName) {
        String t = tableName == null ? "" : "/" + tableName;
        return "-- To change " + Diff.getDesc(this.a) + t + "\n-- into " + Diff.getDesc(this.b) + t + "\n-- \n";
    }

    private Set<String> getTablesUnion() {
        return CollectionUtils.union(this.a.getChildrenNames(), this.b.getChildrenNames());
    }

    public final String compute() {
        return String.valueOf(this.getHeader(null)) + this.computeBody(this.getTablesUnion());
    }

    public final List<ChangeTable<?>> getChangeTables() {
        return this.getChangeTables(this.getTablesUnion());
    }

    public final List<ChangeTable<?>> getChangeTables(Collection<String> tables) {
        ArrayList l = new ArrayList();
        for (String table : tables) {
            ChangeTable<?> compute = this.computeP(table);
            if (compute == null) continue;
            l.add(compute);
        }
        return l;
    }

    private final String computeBody(Collection<String> tables) {
        List<ChangeTable<?>> l = this.getChangeTables(tables);
        if (Boolean.getBoolean(SIMPLE_SEQ)) {
            StringBuilder sb = new StringBuilder();
            for (ChangeTable<?> compute : l) {
                sb.append("\n-- " + compute.getName() + "\n");
                sb.append(compute.asString(this.a.getName()));
                sb.append("\n");
            }
            return sb.toString();
        }
        return ChangeTable.catToString(l, this.a.getName());
    }

    public final String compute(Collection<String> tableName) {
        return String.valueOf(this.getHeader(tableName)) + this.computeBody(tableName);
    }

    private final ChangeTable<?> computeP(String tableName) {
        List<String> bPKNames;
        SQLTable bT;
        boolean inA = this.a.contains(tableName);
        boolean inB = this.b.contains(tableName);
        if (!inA && !inB) {
            return null;
        }
        if (inA && !inB) {
            return new DropTable(this.a.getTable(tableName));
        }
        if (!inA && inB) {
            SQLTable bT2 = this.b.getTable(tableName);
            return bT2.getCreateTable(this.a.getServer().getSQLSystem());
        }
        SQLTable aT = this.a.getTable(tableName);
        if (aT.equalsDesc(bT = this.b.getTable(tableName))) {
            return null;
        }
        AlterTable alterTable = new AlterTable(aT);
        Set<String> aFields = aT.getFieldsName();
        Set<String> bFields = bT.getFieldsName();
        for (String rm : CollectionUtils.substract(aFields, bFields)) {
            alterTable.dropColumn(rm);
        }
        for (String added : CollectionUtils.substract(bFields, aFields)) {
            alterTable.addColumn(bT.getField(added));
        }
        for (String common : CollectionUtils.inter(aFields, bFields)) {
            SQLField sQLField = aT.getField(common);
            SQLField bF = bT.getField(common);
            Map<SQLField.Properties, String> diff = sQLField.getDiffMap(bF, bT.getServer().getSQLSystem(), true);
            alterTable.alterColumn(common, bF, diff.keySet());
        }
        List<String> aPKNames = aT.getPKsNames();
        if (!aPKNames.equals(bPKNames = bT.getPKsNames())) {
            if (aPKNames.size() > 0) {
                alterTable.dropPrimaryKey();
            }
            if (bPKNames.size() > 0) {
                alterTable.addPrimaryKey(bPKNames);
            }
        }
        DatabaseGraph graph = this.a.getDBSystemRoot().getGraph();
        DatabaseGraph bGraph = this.b.getDBSystemRoot().getGraph();
        Set<String> set = new SQLFieldsSet(aT.getForeignKeys()).getFieldsNames(aT);
        Set<String> bFKs = new SQLFieldsSet(bT.getForeignKeys()).getFieldsNames(bT);
        for (String rm : CollectionUtils.substract(set, bFKs)) {
            Link foreignLink = graph.getForeignLink(aT.getField(rm));
            if (foreignLink.getName() == null) {
                throw new IllegalStateException(foreignLink + " is not a real constraint, use AddFK");
            }
            alterTable.dropForeignConstraint(foreignLink.getName());
        }
        for (String added : CollectionUtils.substract(bFKs, set)) {
            Link link = bGraph.getForeignLink(bT.getField(added));
            alterTable.addForeignConstraint(link, false);
        }
        for (String common : CollectionUtils.inter(set, bFKs)) {
            SQLName bPath;
            Link aLink = graph.getForeignLink(aT.getField(common));
            Link bLink = bGraph.getForeignLink(bT.getField(common));
            SQLName aPath = aLink.getContextualName();
            if (!aPath.equals(bPath = bLink.getContextualName())) {
                throw new UnsupportedOperationException(String.valueOf(common) + " is different: " + aPath + " != " + bPath);
            }
            if (aLink.getUpdateRule() == bLink.getUpdateRule() && aLink.getDeleteRule() == bLink.getDeleteRule()) continue;
            alterTable.dropForeignConstraint(aLink.getName());
            alterTable.addForeignConstraint(bLink, false);
        }
        try {
            HashSet<SQLTable.Index> aIndexes = new HashSet<SQLTable.Index>(aT.getIndexes());
            HashSet<SQLTable.Index> bIndexes = new HashSet<SQLTable.Index>(bT.getIndexes());
            for (SQLTable.Index index : CollectionUtils.substract(aIndexes, bIndexes)) {
                alterTable.dropIndex(index.getName());
            }
            for (SQLTable.Index index : CollectionUtils.substract(bIndexes, aIndexes)) {
                alterTable.addIndex(index);
            }
        }
        catch (SQLException e) {
            throw new UnsupportedOperationException("couldn't get indexes", e);
        }
        Set<Constraint> aConstr = aT.getConstraints();
        Set<Constraint> bConstr = bT.getConstraints();
        for (Constraint constraint : CollectionUtils.substract(aConstr, bConstr)) {
            alterTable.dropConstraint(constraint.getName());
        }
        for (Constraint constraint : CollectionUtils.substract(bConstr, aConstr)) {
            if (constraint.getType() == SQLSyntax.ConstraintType.UNIQUE) {
                alterTable.addUniqueConstraint(constraint.getName(), constraint.getCols());
                continue;
            }
            throw new UnsupportedOperationException("unsupported constraint: " + constraint);
        }
        return alterTable;
    }
}

