/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ReflectUtils;
import org.openconcerto.utils.cc.ITransformer;

public abstract class ChangeTable<T extends ChangeTable<T>> {
    public static final Set<ClauseType> ORDERED_TYPES;
    private String name;
    private final SQLSyntax syntax;
    private final List<FCSpec> fks;
    private final CollectionMap<ClauseType, String> clauses;
    private final CollectionMap<ClauseType, DeferredClause> inClauses;
    private final CollectionMap<ClauseType, DeferredClause> outClauses;

    static {
        LinkedHashSet<ClauseType> tmp = new LinkedHashSet<ClauseType>(ClauseType.values().length);
        ConcatStep[] concatStepArray = ConcatStep.values();
        int n = concatStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConcatStep step = concatStepArray[n2];
            tmp.addAll(step.getTypes());
            ++n2;
        }
        assert (tmp.equals(EnumSet.allOf(ClauseType.class))) : "ConcatStep is missing some types : " + tmp;
        ORDERED_TYPES = Collections.unmodifiableSet(tmp);
    }

    public static List<String> cat(List<? extends ChangeTable<?>> cts, String r) {
        return ChangeTable.cat(cts, r, false);
    }

    public static List<List<String>> cat(Collection<? extends ChangeTable<?>> cts, String r, EnumSet<ConcatStep> boundaries) {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        ArrayList<String> current = null;
        ConcatStep[] concatStepArray = ConcatStep.values();
        int n = concatStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConcatStep step = concatStepArray[n2];
            if (current == null || boundaries.contains((Object)step)) {
                current = new ArrayList<String>();
                res.add(current);
            }
            for (ChangeTable<?> ct : cts) {
                String asString = ct.asString(r, step);
                if (asString == null || asString.length() <= 0) continue;
                current.add(asString);
            }
            ++n2;
        }
        assert (res.size() == boundaries.size() + 1);
        return res;
    }

    private static List<String> cat(List<? extends ChangeTable<?>> cts, String r, boolean forceCat) {
        List<String> res = ChangeTable.cat(cts, r, EnumSet.noneOf(ConcatStep.class)).get(0);
        if (!(forceCat || cts.size() != 0 && cts.get(0).getSyntax().getSystem() != SQLSystem.MYSQL)) {
            return res;
        }
        return Collections.singletonList(CollectionUtils.join(res, "\n"));
    }

    public static String catToString(List<? extends ChangeTable<?>> cts, String r) {
        return ChangeTable.cat(cts, r, true).get(0);
    }

    public ChangeTable(SQLSyntax syntax, String name) {
        this.syntax = syntax;
        this.name = name;
        this.fks = new ArrayList<FCSpec>();
        this.clauses = new CollectionMap();
        this.inClauses = new CollectionMap();
        this.outClauses = new CollectionMap();
        if (this.getClass() != ReflectUtils.getTypeArguments(this, ChangeTable.class).get(0)) {
            throw new IllegalStateException("illegal subclass: " + this.getClass());
        }
    }

    protected final T thisAsT() {
        return (T)this;
    }

    public final SQLSyntax getSyntax() {
        return this.syntax;
    }

    public void reset() {
        this.fks.clear();
        this.clauses.clear();
        this.inClauses.clear();
        this.outClauses.clear();
    }

    public boolean isEmpty() {
        return this.fks.isEmpty() && this.clauses.isEmpty() && this.inClauses.isEmpty() && this.outClauses.isEmpty();
    }

    protected T mutateTo(ChangeTable<?> ct) {
        if (this.getSyntax() != ct.getSyntax()) {
            throw new IllegalArgumentException("not same syntax: " + this.getSyntax() + " != " + ct.getSyntax());
        }
        this.setName(ct.getName());
        for (Map.Entry<ClauseType, Collection<String>> e : ct.clauses.entrySet()) {
            for (String s : e.getValue()) {
                this.addClause(s, e.getKey());
            }
        }
        for (DeferredClause c : ct.inClauses.values()) {
            this.addClause(c);
        }
        for (DeferredClause c : ct.outClauses.values()) {
            this.addOutsideClause(c);
        }
        for (FCSpec fk : ct.fks) {
            this.addForeignConstraint(fk, false);
        }
        return this.thisAsT();
    }

    public final T addVarCharColumn(String name, int count) {
        return this.addColumn(name, "varchar(" + count + ") default '' NOT NULL");
    }

    public final T addDateAndTimeColumn(String name) {
        return this.addColumn(name, this.getSyntax().getDateAndTimeType());
    }

    public final T addIntegerColumn(String name, int defaultVal) {
        return this.addIntegerColumn(name, defaultVal, false);
    }

    public final T addIntegerColumn(String name, Integer defaultVal, boolean nullable) {
        return this.addNumberColumn(name, "integer", defaultVal, nullable);
    }

    public final T addLongColumn(String name, Long defaultVal, boolean nullable) {
        return this.addNumberColumn(name, "bigint", defaultVal, nullable);
    }

    public final T addShortColumn(String name, Short defaultVal, boolean nullable) {
        return this.addNumberColumn(name, "smallint", defaultVal, nullable);
    }

    private final T addNumberColumn(String name, String sqlType, Number defaultVal, boolean nullable) {
        return this.addColumn(name, String.valueOf(sqlType) + " " + this.getSyntax().getDefaultClause(defaultVal == null ? null : defaultVal.toString()) + " " + this.getSyntax().getNullableClause(nullable));
    }

    public abstract T addColumn(String var1, String var2);

    public final T addColumn(SQLField f) {
        return this.addColumn(f.getName(), f);
    }

    public final T addColumn(String name, SQLField f) {
        return this.addColumn(name, this.getSyntax().getFieldDecl(f));
    }

    public final T addIndex(SQLTable.Index index) {
        return this.addOutsideClause(this.getSyntax().getCreateIndex(index));
    }

    public final T addForeignConstraint(Link l, boolean createIndex) {
        return this.addForeignConstraint(new FCSpec(l.getCols(), l.getContextualName(), l.getRefCols(), l.getUpdateRule(), l.getDeleteRule()), createIndex);
    }

    public final T addForeignConstraint(String fieldName, SQLName refTable, String refCols) {
        return this.addForeignConstraint(Collections.singletonList(fieldName), refTable, true, Collections.singletonList(refCols));
    }

    public final T addForeignConstraint(List<String> fieldName, SQLName refTable, boolean createIndex, List<String> refCols) {
        return this.addForeignConstraint(new FCSpec(fieldName, refTable, refCols, null, null), createIndex);
    }

    public final T addForeignConstraint(final FCSpec fkSpec, boolean createIndex) {
        this.fks.add(fkSpec);
        if (createIndex) {
            this.addOutsideClause(new OutsideClause(){

                @Override
                public ClauseType getType() {
                    return ClauseType.ADD_INDEX;
                }

                @Override
                public String asString(SQLName tableName) {
                    return ChangeTable.this.getSyntax().getCreateIndex("_fki", tableName, fkSpec.getCols());
                }
            });
        }
        return this.thisAsT();
    }

    public final List<FCSpec> getForeignConstraints() {
        return Collections.unmodifiableList(this.fks);
    }

    public T addForeignColumn(SQLCreateTableBase<?> createTable) {
        return this.addForeignColumnWithSuffix("", createTable);
    }

    public T addForeignColumnWithSuffix(String suffix, SQLCreateTableBase<?> createTable) {
        String fk = "ID_" + createTable.getName() + (suffix.length() == 0 ? "" : "_" + suffix);
        return this.addForeignColumn(fk, createTable);
    }

    public T addForeignColumn(String fk, SQLCreateTableBase<?> createTable) {
        List<String> primaryKey = createTable.getPrimaryKey();
        if (primaryKey.size() != 1) {
            throw new IllegalArgumentException("Not exactly one field in the foreign primary key : " + primaryKey);
        }
        return this.addForeignColumn(fk, new SQLName(createTable.getName()), primaryKey.get(0), null);
    }

    public T addForeignColumn(String fk, SQLName table, String pk, String defaultVal) {
        this.addColumn(fk, String.valueOf(this.getSyntax().getIDType()) + " DEFAULT " + defaultVal);
        return this.addForeignConstraint(fk, table, pk);
    }

    public T addForeignColumn(String fk, SQLTable foreignTable) {
        return this.addForeignColumn(fk, foreignTable, true);
    }

    public T addForeignColumn(String fk, SQLTable foreignTable, boolean absolute) {
        String defaultVal = foreignTable.getKey().getType().toString(foreignTable.getUndefinedIDNumber());
        SQLName n = absolute ? foreignTable.getSQLName() : new SQLName(foreignTable.getName());
        return this.addForeignColumn(fk, n, foreignTable.getKey().getName(), defaultVal);
    }

    public T addUniqueConstraint(final String name, final List<String> cols) {
        return this.addClause(new DeferredClause(){

            @Override
            public String asString(ChangeTable<?> ct, SQLName tableName) {
                String constrName = SQLSyntax.getSchemaUniqueName(tableName.getName(), name);
                return String.valueOf(ct.getConstraintPrefix()) + "CONSTRAINT " + SQLBase.quoteIdentifier(constrName) + " UNIQUE (" + SQLSyntax.quoteIdentifiers(cols) + ")";
            }

            @Override
            public ClauseType getType() {
                return ClauseType.ADD_CONSTRAINT;
            }
        });
    }

    protected abstract String getConstraintPrefix();

    public final T addClause(String s, ClauseType type) {
        this.clauses.put((Object)type, (Object)s);
        return this.thisAsT();
    }

    protected final List<String> getClauses(SQLName tableName, ClauseType type) {
        if (this.inClauses.size() == 0) {
            return (List)this.clauses.getNonNull(type);
        }
        ArrayList<String> res = new ArrayList<String>(this.clauses.getNonNull(type));
        for (DeferredClause c : this.inClauses.getNonNull(type)) {
            res.add(c.asString(this, tableName));
        }
        return res;
    }

    protected final List<String> getClauses(SQLName tableName, Collection<ClauseType> types) {
        ArrayList<String> res = new ArrayList<String>();
        for (ClauseType type : types) {
            res.addAll(this.getClauses(tableName, type));
        }
        return res;
    }

    public final T addClause(DeferredClause s) {
        this.inClauses.put((Object)s.getType(), (Object)s);
        return this.thisAsT();
    }

    public final T addOutsideClause(DeferredClause s) {
        if (s != null) {
            this.outClauses.put((Object)s.getType(), (Object)s);
        }
        return this.thisAsT();
    }

    protected final void outClausesAsString(StringBuffer res, final SQLName tableName, Set<ClauseType> types) {
        ArrayList<DeferredClause> clauses = new ArrayList<DeferredClause>();
        for (ClauseType type : types) {
            clauses.addAll(this.outClauses.getNonNull(type));
        }
        this.modifyOutClauses(clauses);
        if (clauses.size() > 0) {
            res.append("\n\n");
            res.append(CollectionUtils.join(clauses, "\n", new ITransformer<DeferredClause, String>(){

                @Override
                public String transformChecked(DeferredClause input) {
                    return input.asString(ChangeTable.this, tableName);
                }
            }));
        }
    }

    protected void modifyOutClauses(List<DeferredClause> clauses) {
    }

    public abstract String asString(String var1);

    protected abstract String asString(String var1, ConcatStep var2);

    protected final List<String> getForeignConstraints(String rootName) {
        ArrayList<String> res = new ArrayList<String>(this.fks.size());
        for (FCSpec fk : this.fks) {
            SQLName relRefTable = fk.getRefTable();
            SQLName refTable = relRefTable.getItemCount() == 1 ? new SQLName(rootName, relRefTable.getName()) : relRefTable;
            res.add(String.valueOf(this.getConstraintPrefix()) + this.getSyntax().getFK(String.valueOf(this.name) + "_", fk.getCols(), refTable, fk.getRefCols(), fk.getUpdateRule(), fk.getDeleteRule()));
        }
        return res;
    }

    public String toString() {
        return this.asString(null);
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public static enum ClauseType {
        ADD_COL,
        ADD_CONSTRAINT,
        ADD_INDEX,
        DROP_COL,
        DROP_CONSTRAINT,
        DROP_INDEX,
        ALTER_COL,
        OTHER;

    }

    public static enum ConcatStep {
        DROP_FOREIGN(ClauseType.DROP_CONSTRAINT),
        DROP_INDEX(ClauseType.DROP_INDEX),
        ALTER_TABLE(ClauseType.ADD_COL, ClauseType.DROP_COL, ClauseType.ALTER_COL, ClauseType.OTHER),
        ADD_INDEX(ClauseType.ADD_INDEX),
        ADD_FOREIGN(ClauseType.ADD_CONSTRAINT);

        private final Set<ClauseType> types = new HashSet<ClauseType>();

        private ConcatStep(ClauseType ... types) {
            ClauseType[] clauseTypeArray = types;
            int n2 = types.length;
            int n3 = 0;
            while (n3 < n2) {
                ClauseType t = clauseTypeArray[n3];
                this.types.add(t);
                ++n3;
            }
        }

        public final Set<ClauseType> getTypes() {
            return this.types;
        }
    }

    public static interface DeferredClause {
        public String asString(ChangeTable<?> var1, SQLName var2);

        public ClauseType getType();
    }

    public static final class FCSpec {
        private final List<String> cols;
        private final SQLName refTable;
        private final List<String> refCols;
        private final Link.Rule updateRule;
        private final Link.Rule deleteRule;

        public FCSpec(List<String> cols, SQLName refTable, List<String> refCols, Link.Rule updateRule, Link.Rule deleteRule) {
            if (refTable.getItemCount() == 0) {
                throw new IllegalArgumentException(refTable + " is empty.");
            }
            this.cols = Collections.unmodifiableList(new ArrayList<String>(cols));
            this.refTable = refTable;
            this.refCols = Collections.unmodifiableList(new ArrayList<String>(refCols));
            this.updateRule = updateRule;
            this.deleteRule = deleteRule;
        }

        public final List<String> getCols() {
            return this.cols;
        }

        public final SQLName getRefTable() {
            return this.refTable;
        }

        public final List<String> getRefCols() {
            return this.refCols;
        }

        public final Link.Rule getUpdateRule() {
            return this.updateRule;
        }

        public final Link.Rule getDeleteRule() {
            return this.deleteRule;
        }
    }

    public static abstract class OutsideClause
    implements DeferredClause {
        public abstract String asString(SQLName var1);

        @Override
        public String asString(ChangeTable<?> ct, SQLName tableName) {
            return this.asString(tableName);
        }
    }
}

