/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.users.rights.JListSQLTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class JListSQLTablePanel
extends JPanel {
    private JListSQLTableModel listModel;
    private JList list;
    private SQLTable table;
    private final ListDataListener dataListener = new ListDataListener(){

        @Override
        public void intervalRemoved(ListDataEvent arg0) {
        }

        @Override
        public void intervalAdded(ListDataEvent arg0) {
        }

        @Override
        public void contentsChanged(ListDataEvent arg0) {
            if (JListSQLTablePanel.this.idToSelect > 0) {
                int id = JListSQLTablePanel.this.idToSelect;
                JListSQLTablePanel.this.idToSelect = -1;
                JListSQLTablePanel.this.selectID(id);
            }
        }
    };
    int idToSelect = -1;

    public JListSQLTablePanel(final SQLTable table, List<String> listField, final String undefined) {
        super(new GridBagLayout());
        this.table = table;
        this.listModel = new JListSQLTableModel(this.table, listField, undefined);
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        if (undefined != null) {
            final ListCellRenderer orig = this.list.getCellRenderer();
            this.list.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    IComboSelectionItem item = (IComboSelectionItem)value;
                    boolean isUndef = item.getId() == table.getUndefinedID();
                    String val = isUndef ? undefined : item.getLabel();
                    Component res = orig.getListCellRendererComponent(list, val, index, isSelected, cellHasFocus);
                    if (isUndef) {
                        res.setFont(res.getFont().deriveFont(2));
                    }
                    if (item.getFlag() == 3) {
                        res.setFont(res.getFont().deriveFont(1));
                    }
                    return res;
                }
            });
        }
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        this.add((Component)new JScrollPane(this.list), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        ++c.gridy;
        c.fill = 2;
        this.add((Component)new JLabel("Rechercher"), c);
        ++c.gridx;
        c.weightx = 1.0;
        final JTextField filter = new JTextField(20);
        this.add((Component)filter, c);
        SimpleDocumentListener listener = new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                JListSQLTablePanel.this.list.clearSelection();
                if (filter.getText().length() > 0) {
                    JListSQLTablePanel.this.listModel.fillTree(filter.getText());
                } else {
                    JListSQLTablePanel.this.listModel.fillTree();
                }
            }
        };
        filter.getDocument().addDocumentListener(listener);
        this.listModel.addListDataListener(this.dataListener);
    }

    public void removeAllTableListener() {
        this.listModel.removeListDataListener(this.dataListener);
        this.listModel.removeTableModifiedListener();
    }

    public JListSQLTableModel getModel() {
        return this.listModel;
    }

    public JList getJList() {
        return this.list;
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.list.setSelectedIndex(index);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.list.addListSelectionListener(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.list.removeListSelectionListener(l);
    }

    public void selectID(final int id) {
        if (this.getModel().isUpdating()) {
            this.idToSelect = id;
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int index = JListSQLTablePanel.this.getModel().getIndexForId(id);
                    if (index >= 0) {
                        JListSQLTablePanel.this.getJList().setSelectedIndex(index);
                        JListSQLTablePanel.this.getJList().ensureIndexIsVisible(index);
                    }
                }
            });
        }
    }
}

