/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultListModel;
import javax.swing.SwingWorker;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

public class JListSQLTableModel
extends DefaultListModel {
    private final List<IComboSelectionItem> list;
    private final SQLTable table;
    private final Comparator<IComboSelectionItem> comp;
    private final ComboSQLRequest request;
    String undefined;
    protected SwingWorker<?, ?> updating = null;
    private int idToSelect = -1;
    final SQLTableModifiedListener tableModifiedListener = new SQLTableModifiedListener(){

        private void rowModified(SQLTableEvent evt) {
            int index = JListSQLTableModel.this.getIndexForId(evt.getId());
            IComboSelectionItem newItem = JListSQLTableModel.this.request.getComboItem(evt.getId());
            if (newItem != null) {
                if (index >= 0) {
                    JListSQLTableModel.this.list.remove(index);
                }
                this.addNewItem(newItem);
            } else if (index >= 0) {
                JListSQLTableModel.this.list.remove(index);
                JListSQLTableModel.this.fireIntervalRemoved(JListSQLTableModel.this, index, index);
            }
        }

        private void addNewItem(IComboSelectionItem newItem) {
            if (newItem != null) {
                JListSQLTableModel.this.list.add(newItem);
                Collections.sort(JListSQLTableModel.this.list, JListSQLTableModel.this.comp);
                JListSQLTableModel.this.fireContentsChanged(JListSQLTableModel.this, 0, JListSQLTableModel.this.getSize());
            }
        }

        @Override
        public void tableModified(SQLTableEvent evt) {
            if (evt.getId() < 0) {
                JListSQLTableModel.this.fillTree();
            } else if (evt.getMode() == SQLTableEvent.Mode.ROW_ADDED) {
                this.addNewItem(JListSQLTableModel.this.request.getComboItem(evt.getId()));
            } else {
                this.rowModified(evt);
            }
        }
    };

    public JListSQLTableModel(final SQLTable table, List<String> listField, String undefined) {
        this.table = table;
        this.undefined = undefined;
        this.list = new ArrayList<IComboSelectionItem>();
        this.request = new ComboSQLRequest(table, listField);
        this.request.setFieldSeparator(" ");
        if (undefined != null) {
            this.request.setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    input.setExcludeUndefined(false, table);
                    return input;
                }
            });
        }
        this.comp = new Comparator<IComboSelectionItem>(){

            @Override
            public int compare(IComboSelectionItem row1, IComboSelectionItem row2) {
                if (this.isFirst(row1.getId())) {
                    return -1;
                }
                if (this.isFirst(row2.getId())) {
                    return 1;
                }
                return row1.getLabel().compareToIgnoreCase(row2.getLabel());
            }

            private final boolean isFirst(int id) {
                return id < 0 || id == JListSQLTableModel.this.getTable().getUndefinedID();
            }
        };
        this.fillTree();
        table.addTableModifiedListener(this.tableModifiedListener);
    }

    public void removeTableModifiedListener() {
        this.table.removeTableModifiedListener(this.tableModifiedListener);
    }

    @Override
    public int getSize() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.list.get(index);
    }

    public void fillTree() {
        this.fillTree(null);
    }

    private static final List<String> cut(String value) {
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(value);
        while (tokenizer.hasMoreElements()) {
            String element = (String)tokenizer.nextElement();
            v.add(element);
        }
        return v;
    }

    public synchronized void fillTree(final String match) {
        if (this.isUpdating()) {
            this.updating.cancel(true);
        }
        SwingWorker<List<IComboSelectionItem>, Object> worker = new SwingWorker<List<IComboSelectionItem>, Object>(){

            @Override
            protected List<IComboSelectionItem> doInBackground() throws Exception {
                List<IComboSelectionItem> res;
                List<IComboSelectionItem> comboItems = JListSQLTableModel.this.request.getComboItems();
                if (match == null) {
                    res = comboItems;
                } else {
                    res = new ArrayList<IComboSelectionItem>(comboItems.size() + 1);
                    List matchValues = JListSQLTableModel.cut(match.toLowerCase());
                    for (IComboSelectionItem comboItem : comboItems) {
                        boolean test = true;
                        String s = comboItem.getLabel().toLowerCase();
                        for (String string : matchValues) {
                            if (s.contains(string)) continue;
                            test = false;
                            break;
                        }
                        if (!test) continue;
                        res.add(comboItem);
                    }
                }
                Collections.sort(res, JListSQLTableModel.this.comp);
                return res;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                block8: {
                    try {
                        JListSQLTableModel jListSQLTableModel = JListSQLTableModel.this;
                        synchronized (jListSQLTableModel) {
                            if (this.isCancelled() || JListSQLTableModel.this.updating != this) {
                                return;
                            }
                            List items = (List)this.get();
                            JListSQLTableModel.this.list.clear();
                            JListSQLTableModel.this.list.addAll(items);
                            JListSQLTableModel.this.setUpdating(null);
                            JListSQLTableModel.this.fireContentsChanged(JListSQLTableModel.this, 0, JListSQLTableModel.this.list.size());
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (CancellationException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof RTInterruptedException) break block8;
                        e.printStackTrace();
                    }
                }
            }
        };
        this.setUpdating(worker);
        worker.execute();
    }

    public boolean isUpdating() {
        return this.updating != null;
    }

    private synchronized void setUpdating(SwingWorker<?, ?> w) {
        this.updating = w;
    }

    public int getIndexForId(int id) {
        if (this.isUpdating()) {
            try {
                this.updating.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        int i = 0;
        while (i < this.getSize()) {
            SQLRowAccessor rowAt = this.getRowAt(i);
            if (rowAt != null && id == rowAt.getID()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public SQLRowAccessor getRowAt(int index) {
        return index < 0 || index >= this.getSize() ? null : this.table.getRow(this.list.get(index).getId());
    }

    public final String getPrimaryKey() {
        return this.table.getKey().getName();
    }

    public final SQLTable getTable() {
        return this.table;
    }

    public final void setWhere(Where w) {
        this.request.setWhere(w);
        this.fillTree();
    }

    public final void setItemCustomizer(IClosure<IComboSelectionItem> c) {
        this.request.setItemCustomizer(c);
        this.fillTree();
    }
}

