/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui;

import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.SystemInfoPanel;
import org.openconcerto.ui.component.HTMLTextField;
import org.openconcerto.utils.ProductInfo;

public class SoftwareInfoPanel
extends JPanel {
    public SoftwareInfoPanel() {
        String version;
        String name;
        ProductInfo productInfo;
        PropsConfiguration propsConf;
        Configuration conf = Configuration.getInstance();
        if (conf instanceof PropsConfiguration) {
            propsConf = (PropsConfiguration)conf;
            productInfo = propsConf.getProductInfo();
        } else {
            propsConf = null;
            productInfo = ProductInfo.getInstance();
        }
        FormLayouter l = new FormLayouter(this, 1);
        if (productInfo == null) {
            name = "inconnu";
            version = "inconnue";
        } else {
            name = productInfo.getName();
            version = productInfo.getProperty("VERSION", "inconnue");
        }
        l.add("Nom de l'application", new JLabel(name));
        l.add("Version de l'application", new JLabel(version));
        if (propsConf != null && propsConf.isUsingSSH()) {
            l.add("Liaison s\u00e9curis\u00e9e", new JLabel(propsConf.getWanHostAndPort()));
        }
        l.add("URL de base de donn\u00e9es", new JLabel(conf.getSystemRoot().getDataSource().getUrl()));
        String logs = propsConf == null ? "" : " ; " + SystemInfoPanel.getLink("Journaux", propsConf.getLogDir().toURI());
        l.add("Dossiers", new HTMLTextField(String.valueOf(SystemInfoPanel.getLink("Documents", conf.getWD().toURI())) + logs));
    }
}

