/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;

public class SQLFieldTranslator {
    private static final RowItemDesc NULL_DESC = new RowItemDesc(null, null);
    private static final String METADATA_TABLENAME = "FWK_RIV_METADATA";
    private static final String ELEM_FIELDNAME = "ELEMENT_CODE";
    private static final String COMP_FIELDNAME = "COMPONENT_CODE";
    private static final String ITEM_FIELDNAME = "ITEM";
    private static final String DOC_FIELDNAME = "DOCUMENTATION";
    private static final String COL_TITLE_FIELDNAME = "COLUMN_TITLE";
    private static final String LABEL_FIELDNAME = "LABEL";
    private static final String CORE_VARIANT = "CORE";
    private static final String DB_VARIANT = "DB";
    private final Map<SQLTable, Map<List<String>, RowItemDesc>> translation = new HashMap<SQLTable, Map<List<String>, RowItemDesc>>();
    private final SQLTable table;
    private final SQLElementDirectory dir;
    private final Set<String> unknownCodes = new HashSet<String>();

    public static SQLTable getMetaTable(DBRoot root) throws SQLException {
        if (!root.contains(METADATA_TABLENAME)) {
            SQLCreateTable createValueT = new SQLCreateTable(root, METADATA_TABLENAME);
            createValueT.setPlain(true);
            createValueT.addColumn("ID", createValueT.getSyntax().getPrimaryIDDefinition());
            String nullableVarChar = "varchar(80)";
            createValueT.addColumn(ELEM_FIELDNAME, "varchar(80)");
            createValueT.addColumn(COMP_FIELDNAME, "varchar(80)");
            createValueT.addColumn(ITEM_FIELDNAME, "varchar(80) NOT NULL");
            createValueT.addUniqueConstraint("uniq", Arrays.asList(ELEM_FIELDNAME, COMP_FIELDNAME, ITEM_FIELDNAME));
            createValueT.addVarCharColumn(LABEL_FIELDNAME, 256);
            createValueT.addVarCharColumn(COL_TITLE_FIELDNAME, 256);
            createValueT.addVarCharColumn(DOC_FIELDNAME, Math.min(8192, 8192));
            root.createTable(createValueT);
        }
        return root.getTable(METADATA_TABLENAME);
    }

    public SQLFieldTranslator(DBRoot base) {
        this(base, null);
    }

    public SQLFieldTranslator(DBRoot base, InputStream inputStream) {
        this(base, inputStream, null);
    }

    public SQLFieldTranslator(DBRoot root, InputStream inputStream, SQLElementDirectory dir) {
        try {
            this.table = SQLFieldTranslator.getMetaTable(root);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Couldn't get the meta table", e);
        }
        this.dir = dir;
        this.dir.addListener(new SQLElementDirectory.DirectoryListener(){

            @Override
            public void elementRemoved(SQLElement elem) {
            }

            @Override
            public void elementAdded(SQLElement elem) {
                if (SQLFieldTranslator.this.unknownCodes.remove(elem.getCode())) {
                    SQLFieldTranslator.this.fetch(Collections.singleton(elem.getCode()));
                }
            }
        });
        if (inputStream != null) {
            this.load(root, inputStream);
        }
        this.fetchAndPut(this.table, null);
    }

    public void putAll(SQLFieldTranslator o) {
        CollectionUtils.addIfNotPresent(this.translation, o.translation);
    }

    public void load(DBRoot b, File file) {
        try {
            this.load(b, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static List<Element> getChildren(Element elem) {
        return elem.getChildren();
    }

    public void load(DBRoot b, InputStream inputStream) {
        this.load(b, CORE_VARIANT, inputStream);
    }

    public Set<SQLTable> load(DBRoot b, String variant, InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null");
        }
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        try {
            Document doc = new SAXBuilder().build(inputStream);
            for (Element elem : SQLFieldTranslator.getChildren(doc.getRootElement())) {
                String elemName = elem.getName().toLowerCase();
                if (elemName.equals("table")) {
                    res.add(this.load(b, variant, elem));
                    continue;
                }
                if (!elemName.equals("root")) continue;
                DBRoot root = b.getDBSystemRoot().getRoot(elem.getAttributeValue("name"));
                for (Element tableElem : SQLFieldTranslator.getChildren(elem)) {
                    res.add(this.load(root, variant, tableElem));
                }
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private SQLTable load(DBRoot b, String variant, Element tableElem) {
        String tableName = tableElem.getAttributeValue("name");
        SQLTable table = b.getTable(tableName);
        if (table == null && this.dir != null && this.dir.getElement(tableName) != null) {
            table = this.dir.getElement(tableName).getTable();
        }
        if (table == null) {
            Log.get().info("unknown table " + tableName);
        } else {
            for (Element elem : SQLFieldTranslator.getChildren(tableElem)) {
                String elemName = elem.getName().toLowerCase();
                if (elemName.equals("field")) {
                    this.load(table, "default component code", variant, elem);
                    continue;
                }
                if (!elemName.equals("component")) continue;
                String compCode = elem.getAttributeValue("code");
                for (Element fieldElem : SQLFieldTranslator.getChildren(elem)) {
                    this.load(table, compCode, variant, fieldElem);
                }
            }
        }
        return table;
    }

    private void load(SQLTable table, String compCode, String variant, Element fieldElem) {
        String name = fieldElem.getAttributeValue("name");
        String label = fieldElem.getAttributeValue("label");
        String title = fieldElem.getAttributeValue("titlelabel", label);
        String documentation = fieldElem.getText();
        this.setDescFor(table, compCode, variant, name, new RowItemDesc(label, title, documentation));
    }

    public final void fetch(Set<String> codes) {
        this.fetchAndPut(this.table, codes);
    }

    private List<SQLRow> fetchOnly(SQLTable table, Where w) {
        return SQLRowListRSH.execute(new SQLSelect(table.getBase()).addSelectStar(table).setWhere(w));
    }

    private void fetchAndPut(SQLTable table, Set<String> codes) {
        Where w;
        if (codes == null) {
            w = null;
            this.removeTranslation((SQLTable)null, (String)null, DB_VARIANT, (String)null);
        } else {
            w = new Where(table.getField(ELEM_FIELDNAME), codes);
            for (String elementCode : codes) {
                this.removeTranslation(this.dir.getElementForCode(elementCode).getTable(), null, DB_VARIANT, null);
            }
        }
        for (SQLRow r : this.fetchOnly(table, w)) {
            String elementCode = r.getString(ELEM_FIELDNAME);
            if (this.unknownCodes.contains(elementCode)) continue;
            SQLElement elem = this.dir.getElementForCode(elementCode);
            if (elem != null) {
                String componentCode = r.getString(COMP_FIELDNAME);
                String item = r.getString(ITEM_FIELDNAME);
                RowItemDesc desc = new RowItemDesc(r.getString(LABEL_FIELDNAME), r.getString(COL_TITLE_FIELDNAME), r.getString(DOC_FIELDNAME));
                this.putTranslation(elem.getTable(), componentCode, DB_VARIANT, item, desc);
                continue;
            }
            this.unknownCodes.add(elementCode);
        }
    }

    private final Map<List<String>, RowItemDesc> getMap(SQLTable t) {
        Map<List<String>, RowItemDesc> elemMap = this.translation.get(t);
        if (elemMap == null) {
            elemMap = new HashMap<List<String>, RowItemDesc>();
            this.translation.put(t, elemMap);
        }
        return elemMap;
    }

    private final void putTranslation(SQLTable t, String compCode, String variant, String item, RowItemDesc desc) {
        if (t == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        if (compCode == null || variant == null || item == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        this.getMap(t).put(Arrays.asList(compCode, variant, item), desc);
    }

    private final void removeTranslation(SQLTable t, String compCode, String variant, String name) {
        if (t == null) {
            for (Map<List<String>, RowItemDesc> m : this.translation.values()) {
                this.removeTranslation(m, compCode, variant, name);
            }
        } else {
            this.removeTranslation(this.translation.get(t), compCode, variant, name);
        }
    }

    private void removeTranslation(Map<List<String>, RowItemDesc> m, String compCode, String variant, String name) {
        if (m == null) {
            return;
        }
        if (compCode == null && variant == null && name == null) {
            m.clear();
        } else if (compCode != null && variant != null && name != null) {
            m.remove(Arrays.asList(compCode, variant, name));
        } else {
            Iterator<List<String>> iter = m.keySet().iterator();
            while (iter.hasNext()) {
                List<String> l = iter.next();
                if (compCode != null && !compCode.equals(l.get(0)) || variant != null && !variant.equals(l.get(1)) || name != null && !name.equals(l.get(2))) continue;
                iter.remove();
            }
        }
    }

    private final RowItemDesc getTranslation(SQLTable t, String compCode, String variant, String item) {
        return this.getMap(t).get(Arrays.asList(compCode, variant, item));
    }

    private final RowItemDesc getTranslation(SQLTable t, String compCodeArg, List<String> variants, String name) {
        LinkedList<String> ll = new LinkedList<String>(variants);
        ll.addFirst(DB_VARIANT);
        ll.addLast(CORE_VARIANT);
        String[] compCodes = compCodeArg == "default component code" ? new String[]{"default component code"} : new String[]{compCodeArg, "default component code"};
        String[] stringArray = compCodes;
        int n = compCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String compCode = stringArray[n2];
            for (String variant : ll) {
                RowItemDesc labeledField = this.getTranslation(t, compCode, variant, name);
                if (labeledField == null) continue;
                return labeledField;
            }
            ++n2;
        }
        return null;
    }

    public RowItemDesc getDescFor(SQLTable t, String name) {
        return this.getDescFor(t, "default component code", name);
    }

    public RowItemDesc getDescFor(SQLTable t, String compCode, String name) {
        return this.getDescFor(t, compCode, Collections.<String>emptyList(), name);
    }

    public RowItemDesc getDescFor(String elementCode, String compCode, String name) {
        return this.getDescFor(elementCode, compCode, Collections.<String>emptyList(), name);
    }

    public RowItemDesc getDescFor(String elementCode, String compCode, List<String> variants, String name) {
        return this.getDescFor(this.dir.getElementForCode(elementCode).getTable(), compCode, variants, name);
    }

    public RowItemDesc getDescFor(SQLTable t, String compCodeArg, List<String> variants, String name) {
        RowItemDesc labeledField = this.getTranslation(t, compCodeArg, variants, name);
        if (labeledField == null) {
            this.fetchAndPut(this.table, Collections.singleton(this.dir.getElement(t).getCode()));
            labeledField = this.getTranslation(t, compCodeArg, variants, name);
        }
        if (labeledField == null) {
            Log.get().info("unknown item " + name + " in " + t);
            return NULL_DESC;
        }
        return labeledField;
    }

    private RowItemDesc getDescFor(SQLField f) {
        return this.getDescFor(f.getTable(), "default component code", this.dir.getElement(f.getTable()).getMDPath(), f.getName());
    }

    public String getLabelFor(SQLField f) {
        return this.getDescFor(f).getLabel();
    }

    public String getTitleFor(SQLField f) {
        return this.getDescFor(f).getTitleLabel();
    }

    public final void setDescFor(SQLTable table, String componentCode, String variant, String name, RowItemDesc desc) {
        if (DB_VARIANT.equals(variant)) {
            throw new IllegalArgumentException("Use storeDescFor()");
        }
        this.putTranslation(table, componentCode, variant, name, desc);
    }

    public final void removeDescFor(SQLTable t, String compCode, String variant, String name) {
        if (DB_VARIANT.equals(variant)) {
            throw new IllegalArgumentException("Cannot remove DB values, use deleteDescFor()");
        }
        this.removeTranslation(t, compCode, variant, name);
    }

    public final void storeDescFor(String elementCode, String componentCode, String name, RowItemDesc desc) throws SQLException {
        this.storeDescFor(this.dir.getElementForCode(elementCode).getTable(), componentCode, name, desc);
    }

    public final void storeDescFor(final SQLTable table, final String componentCode, final String name, final RowItemDesc desc) throws SQLException {
        String elementCode = this.dir.getElement(table).getCode();
        final HashMap<String, String> m = new HashMap<String, String>();
        m.put(ELEM_FIELDNAME, elementCode);
        m.put(COMP_FIELDNAME, componentCode);
        m.put(ITEM_FIELDNAME, name);
        final SQLTable mdT = this.table;
        SQLUtils.executeAtomic(this.table.getDBSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                List existing = SQLFieldTranslator.this.fetchOnly(mdT, Where.and(mdT, m));
                if (!$assertionsDisabled && existing.size() > 1) {
                    throw new AssertionError((Object)("Unique constraint failed for " + m));
                }
                SQLRowValues vals = existing.size() == 0 ? new SQLRowValues(mdT, m) : ((SQLRow)existing.get(0)).asRowValues();
                vals.put(SQLFieldTranslator.LABEL_FIELDNAME, desc.getLabel());
                vals.put(SQLFieldTranslator.COL_TITLE_FIELDNAME, desc.getTitleLabel());
                vals.put(SQLFieldTranslator.DOC_FIELDNAME, desc.getDocumentation());
                vals.commit();
                SQLFieldTranslator.this.putTranslation(table, componentCode, SQLFieldTranslator.DB_VARIANT, name, desc);
                return null;
            }
        });
    }

    public final void deleteDescFor(SQLTable elemTable, String componentCode, String name) throws SQLException {
        Where w = null;
        if (elemTable != null) {
            w = new Where((FieldRef)this.table.getField(ELEM_FIELDNAME), "=", (Object)this.dir.getElement(elemTable).getCode()).and(w);
        }
        if (componentCode != null) {
            w = new Where((FieldRef)this.table.getField(COMP_FIELDNAME), "=", (Object)componentCode).and(w);
        }
        if (name != null) {
            w = new Where((FieldRef)this.table.getField(ITEM_FIELDNAME), "=", (Object)name).and(w);
        }
        String whereString = w == null ? "" : " where " + w.getClause();
        try {
            this.table.getDBSystemRoot().getDataSource().execute("DELETE FROM " + this.table.getSQLName().quote() + whereString);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        this.removeTranslation(elemTable, componentCode, DB_VARIANT, name);
    }
}

