/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.CollectionUtils;

public class Step {
    private final SQLTable from;
    private final SQLTable to;
    private final Map<SQLField, Boolean> fields;
    private final SQLField singleField;

    public static final Step create(SQLTable start, SQLField fField, Boolean direction) throws IllegalArgumentException {
        Boolean nonNullDir;
        Link l = fField.getDBSystemRoot().getGraph().getForeignLink(fField);
        if (l == null) {
            throw new IllegalArgumentException(fField + " is not a foreign field.");
        }
        SQLTable end2 = l.oppositeVertex(start);
        SQLTable fieldStart = fField.getTable();
        Boolean computedDirection = start == end2 ? null : Boolean.valueOf(fieldStart == start);
        if (computedDirection == null && direction == null) {
            throw new IllegalArgumentException("the field references its table: " + fField + ", you must specify the direction");
        }
        if (direction != null && computedDirection != null && direction != computedDirection) {
            throw new IllegalArgumentException("wrong direction: " + direction + ", real is : " + computedDirection);
        }
        Boolean bl = nonNullDir = direction == null ? computedDirection : direction;
        assert (nonNullDir != null);
        return new Step(start, fField, nonNullDir, end2);
    }

    public static final Step create(SQLTable start, SQLTable end2) {
        Set<SQLField> set = start.getDBSystemRoot().getGraph().getFields(start, end2);
        if (set.isEmpty()) {
            throw new IllegalArgumentException("path is broken between " + start + " and " + end2);
        }
        return Step.create(start, set, end2);
    }

    private static final Step create(SQLTable start, Set<SQLField> jFields, SQLTable end2) {
        if (start == end2) {
            throw new IllegalArgumentException("start and end are the same: " + start + " the direction can't be inferred");
        }
        HashMap<SQLField, Boolean> fields = new HashMap<SQLField, Boolean>(jFields.size());
        for (SQLField f : jFields) {
            fields.put(f, start == f.getTable());
        }
        return new Step(start, fields, (SQLField)CollectionUtils.getSole(fields.keySet()), end2);
    }

    public static final Step create(SQLTable start, Collection<Link> links) {
        if (links.size() == 0) {
            throw new IllegalArgumentException("empty fields");
        }
        SQLTable end2 = links.iterator().next().oppositeVertex(start);
        HashSet<SQLField> set = new HashSet<SQLField>();
        for (Link l : links) {
            if (end2 != l.oppositeVertex(start)) {
                throw new IllegalArgumentException("fields do not point to the same table: " + links);
            }
            set.add(l.getLabel());
        }
        return Step.create(start, set, end2);
    }

    private Step(SQLTable start, Map<SQLField, Boolean> fields, SQLField singleField, SQLTable end2) {
        assert (start != null && end2 != null);
        assert (fields.size() > 0);
        assert (CollectionUtils.getSole(fields.keySet()) == singleField);
        assert (!new HashSet<Boolean>(fields.values()).contains(null)) : "some directions are unknown : " + fields;
        this.from = start;
        this.to = end2;
        this.fields = Collections.unmodifiableMap(fields);
        this.singleField = singleField;
    }

    private Step(SQLTable start, Map<SQLField, Boolean> fields, SQLTable end2) {
        this(start, new HashMap<SQLField, Boolean>(fields), CollectionUtils.getSole(fields.keySet()), end2);
    }

    private Step(SQLTable start, SQLField field, boolean foreign, SQLTable end2) {
        this(start, Collections.singletonMap(field, foreign), field, end2);
    }

    public Step(Step p) {
        this(p.from, p.fields, p.to);
    }

    public final Step reverse() {
        HashMap<SQLField, Boolean> reverseFields = new HashMap<SQLField, Boolean>(this.fields.size());
        for (Map.Entry<SQLField, Boolean> e : this.fields.entrySet()) {
            reverseFields.put(e.getKey(), e.getValue() == false);
        }
        return new Step(this.to, reverseFields, this.from);
    }

    public final SQLTable getFrom() {
        return this.from;
    }

    public final SQLTable getTo() {
        return this.to;
    }

    public final Set<SQLField> getFields() {
        return this.fields.keySet();
    }

    public final SQLField getSingleField() {
        return this.singleField;
    }

    public final boolean isForeign(SQLField f) {
        return this.fields.get(f);
    }

    public final Boolean isForeign() {
        return CollectionUtils.getSole(new HashSet<Boolean>(this.fields.values()));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " from: " + this.getFrom() + " to: " + this.getTo() + "\n" + this.fields;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Step) {
            Step o = (Step)obj;
            return this.from.equals(o.from) && this.fields.equals(o.fields);
        }
        return false;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }
}

