/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.CollectionUtils;

public class Path {
    private final DBRoot base;
    private final List<SQLTable> tables;
    private final List<Step> fields;
    private final List<SQLField> singleFields;

    public static Path create(DBRoot base, List<String> path) {
        if (path.size() == 0) {
            throw new IllegalArgumentException("path is empty");
        }
        SQLTable first = base.getTable(path.get(0));
        if (first == null) {
            throw new IllegalArgumentException("first item must be a table");
        }
        Path res = new Path(first);
        int i = 1;
        while (i < path.size()) {
            res.add(path.get(i));
            ++i;
        }
        return res;
    }

    public static Path create(SQLTable first, List<Link> links) {
        if (links == null) {
            return null;
        }
        Path res = new Path(first);
        for (Link link : links) {
            res.add(link);
        }
        return res;
    }

    public Path(SQLTable start) {
        this.tables = new ArrayList<SQLTable>();
        this.fields = new ArrayList<Step>();
        this.singleFields = new ArrayList<SQLField>();
        this.base = start.getDBRoot();
        this.tables.add(start);
    }

    public Path(Path p) {
        this.tables = new ArrayList<SQLTable>(p.tables);
        this.fields = new ArrayList<Step>(p.fields);
        this.singleFields = new ArrayList<SQLField>(p.singleFields);
        this.base = p.base;
    }

    public final Path reverse() {
        Path res = new Path(this.getLast());
        int i = this.fields.size() - 1;
        while (i >= 0) {
            res.add(this.fields.get(i).reverse());
            --i;
        }
        return res;
    }

    public int length() {
        return this.fields.size();
    }

    public SQLTable getFirst() {
        return this.getTable(0);
    }

    public SQLTable getLast() {
        return this.getTable(this.tables.size() - 1);
    }

    public SQLTable getTable(int i) {
        return this.tables.get(i);
    }

    public Path minusFirst() {
        return this.subPath(1, this.length());
    }

    public Path minusLast() {
        return this.subPath(0, this.length() - 1);
    }

    public Path subPath(int fromIndex) {
        return this.subPath(fromIndex, this.length());
    }

    public Path subPath(int fromIndex, int toIndex) {
        fromIndex = CollectionUtils.getValidIndex(this.fields, fromIndex);
        toIndex = CollectionUtils.getValidIndex(this.fields, toIndex);
        Path p = new Path(this.getTable(fromIndex));
        p.tables.addAll(this.tables.subList(fromIndex + 1, toIndex + 1));
        p.fields.addAll(this.fields.subList(fromIndex, toIndex));
        p.singleFields.addAll(this.singleFields.subList(fromIndex, toIndex));
        return p;
    }

    public Path justFirst() {
        Path p = new Path(this.getFirst());
        p.add(this.fields.get(0));
        return p;
    }

    public List<SQLTable> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public final void append(Path p) {
        if (this.getLast() != p.getFirst()) {
            throw new IllegalArgumentException("this ends at " + this.getLast() + " while the other begins at " + p.getFirst());
        }
        this.fields.addAll(p.fields);
        this.singleFields.addAll(p.singleFields);
        this.tables.addAll(p.tables.subList(1, p.tables.size()));
    }

    private void add(Step step) {
        assert (step.getFrom() == this.getLast()) : "broken path";
        this.fields.add(step);
        this.singleFields.add(step.getSingleField());
        this.tables.add(step.getTo());
    }

    public void add(String item) {
        int dot = item.indexOf(46);
        if (dot < 0) {
            this.add(this.base.getTable(item));
        } else {
            this.add(this.base.getDesc(item, SQLField.class));
        }
    }

    public final void add(SQLTable destTable) {
        this.add(Step.create(this.getLast(), destTable));
    }

    public final void add(SQLField fField) {
        this.add(fField, null);
    }

    public final void add(SQLField fField, Boolean direction) {
        this.add(Step.create(this.getLast(), fField, direction));
    }

    public final void addFields(Collection<SQLField> fields) {
        HashSet<Link> links = new HashSet<Link>(fields.size());
        DatabaseGraph graph = this.getFirst().getDBSystemRoot().getGraph();
        for (SQLField f : fields) {
            links.add(graph.getForeignLink(f));
        }
        this.add(links);
    }

    public final void add(Collection<Link> links) {
        this.add(Step.create(this.getLast(), links));
    }

    public void add(Link item) {
        this.add(item.getLabel());
    }

    public final Step getStep(int i) {
        return this.fields.get(i);
    }

    public final Set<SQLField> getStepFields(int i) {
        return this.fields.get(i).getFields();
    }

    public SQLField getSingleStep(int i) {
        return this.singleFields.get(i);
    }

    public final List<SQLField> getSingleSteps() {
        return Collections.unmodifiableList(this.singleFields);
    }

    public boolean isSingleLink() {
        for (SQLField step : this.singleFields) {
            if (step != null) continue;
            return false;
        }
        return true;
    }

    public final Boolean isBackwards(int i) {
        Boolean foreign = this.fields.get(i).isForeign();
        return foreign == null ? null : Boolean.valueOf(foreign == false);
    }

    public final Boolean isSingleDirection() {
        return this.isSingleDirection(null);
    }

    public final Boolean isSingleDirection(boolean foreign) {
        return this.isSingleDirection((Boolean)foreign);
    }

    private final Boolean isSingleDirection(Boolean foreign) {
        Boolean dir = foreign;
        for (Step s : this.fields) {
            Boolean stepIsForeign = s.isForeign();
            if (stepIsForeign == null) {
                return null;
            }
            if (dir == null) {
                dir = stepIsForeign;
                continue;
            }
            if (dir.equals(stepIsForeign)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Path\n\tTables: " + this.tables + "\n\tLinks:" + this.fields;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Path) {
            Path o = (Path)obj;
            return this.base.equals(o.base) && this.getFirst().equals(o.getFirst()) && this.fields.equals(o.fields);
        }
        return false;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public boolean startsWith(Path other) {
        return this.length() >= other.length() && this.subPath(0, other.length()).equals(other);
    }
}

