/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DirectedMultigraph;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.BaseGraph;
import org.openconcerto.sql.model.graph.DirectedEdge;
import org.openconcerto.sql.model.graph.GraFFF;
import org.openconcerto.sql.model.graph.LabelPredicate;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.SQLKey;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.xml.JDOMUtils;

public class DatabaseGraph
extends BaseGraph {
    public static final String INFER_FK = "org.openconcerto.sql.graph.inferFK";
    private static final String XML_VERSION = "20120228-1810";
    private static final String FILENAME = "graph.xml";
    private final DBSystemRoot base;
    private DBRoot context;
    private final List<String> mappedFromFile;
    private final Map<SQLTable, Set<Link>> foreignLinks = new HashMap<SQLTable, Set<Link>>();
    private final Map<List<SQLField>, Link> foreignLink = new HashMap<List<SQLField>, Link>();

    public DatabaseGraph(DBSystemRoot root) throws SQLException {
        super(new DirectedMultigraph<SQLTable, Link>(Link.class));
        this.base = root;
        this.context = null;
        this.mappedFromFile = this.mapTables();
    }

    public DatabaseGraph(DatabaseGraph g, DBRoot root) {
        super(g.getGraphP());
        this.base = root.getDBSystemRoot();
        this.context = root;
        this.mappedFromFile = g.mappedFromFile;
    }

    final List<String> getMappedFromFile() {
        return this.mappedFromFile;
    }

    private final SQLServer getServer() {
        return this.base.getAnc(SQLServer.class);
    }

    public void setContext(DBRoot root) {
        this.context = root;
    }

    private DBRoot getContext() {
        return this.context;
    }

    private List<String> mapTables() throws SQLException {
        long t2;
        long t1;
        List<String> res = Collections.emptyList();
        Set<SQLTable> tables = this.base.getDescs(SQLTable.class);
        Graphs.addAllVertices(this.getGraphP(), tables);
        DBItemFileCache dir = this.getFileCache();
        ArrayList<String> childrenToFetch = new ArrayList<String>(this.base.getChildrenNames());
        try {
            if (dir != null) {
                Log.get().config("for mapping " + this + " trying xmls in " + dir);
                t1 = System.currentTimeMillis();
                res = this.mapFromXML();
                childrenToFetch.removeAll(res);
                t2 = System.currentTimeMillis();
                Log.get().config("XML took " + (t2 - t1) + "ms for mapping the graph of " + this.base.getName() + "." + res);
            }
        }
        catch (Exception e) {
            SQLBase.logCacheError(dir, e);
            this.deleteGraphFiles();
        }
        if (!childrenToFetch.isEmpty()) {
            t1 = System.currentTimeMillis();
            for (String rootName : childrenToFetch) {
                DBRoot r = this.base.getRoot(rootName);
                for (SQLTable table : r.getDescs(SQLTable.class)) {
                    this.map(table);
                }
                this.save(r);
            }
            t2 = System.currentTimeMillis();
            Log.get().config("JDBC took " + (t2 - t1) + "ms for mapping the graph of " + this.base + "." + childrenToFetch);
        }
        return res;
    }

    private final void addLink(List<SQLField> from, List<SQLField> to, String foreignKeyName, Link.Rule updateRule, Link.Rule deleteRule) {
        this.addLink(new Link(from, to, foreignKeyName, updateRule, deleteRule));
    }

    private final void addLink(Link l) {
        DirectedEdge.addEdge(this.getGraphP(), l);
    }

    private void map(final SQLTable table) throws SQLException {
        HashSet<String> metadataFKs = new HashSet<String>();
        List importedKeys = this.base.getDataSource().useConnection(new ConnectionHandlerNoSetup<List, SQLException>(){

            @Override
            public List handle(SQLDataSource ds) throws SQLException {
                DatabaseMetaData metaData = ds.getConnection().getMetaData();
                return (List)SQLDataSource.ARRAY_LIST_HANDLER.handle(metaData.getImportedKeys(table.getBase().getMDName(), table.getSchema().getName(), table.getName()));
            }
        });
        ArrayList<SQLField> from = new ArrayList<SQLField>();
        ArrayList<SQLField> to = new ArrayList<SQLField>();
        Link.Rule updateRule = null;
        Link.Rule deleteRule = null;
        String name = null;
        for (Object[] m : importedKeys) {
            String keyName = (String)m[7];
            short seq = ((Number)m[8]).shortValue();
            String foreignCat = this.base.getServer().getSQLSystem().isInterBaseSupported() && m[0] != null ? (String)m[0] : table.getBase().getName();
            String foreignSchema = (String)m[1];
            String foreignTableName = (String)m[2];
            String foreignTableColName = (String)m[3];
            String foreignKeyName = (String)m[11];
            SQLField key = table.getField(keyName);
            SQLSchema schema = table.getBase().getServer().getBase(foreignCat).getSchema(foreignSchema);
            if (schema == null) {
                throw new IllegalStateException(key.getSQLName() + " references " + foreignCat + "." + foreignSchema + " which does not exist (probably filtered by DBSystemRoot.getRootsToMap())");
            }
            SQLTable foreignTable = this.base.getServer().getSQLSystem() == SQLSystem.MYSQL ? this.getTableIgnoringCase(schema, foreignTableName) : (SQLTable)schema.getCheckedChild(foreignTableName);
            metadataFKs.add(keyName);
            if (seq == 1) {
                if (from.size() > 0) {
                    this.addLink(from, to, name, updateRule, deleteRule);
                }
                from.clear();
                to.clear();
            }
            from.add(key);
            to.add(foreignTable.getField(foreignTableColName));
            updateRule = Link.Rule.fromShort(((Number)m[9]).shortValue());
            deleteRule = Link.Rule.fromShort(((Number)m[10]).shortValue());
            name = foreignKeyName;
        }
        if (from.size() > 0) {
            this.addLink(from, to, name, updateRule, deleteRule);
        }
        if (Boolean.getBoolean(INFER_FK)) {
            Set<String> lexicalFKs = SQLKey.foreignKeys(table);
            lexicalFKs.removeAll(metadataFKs);
            for (String keyName : lexicalFKs) {
                SQLField key = table.getField(keyName);
                this.addLink(Collections.singletonList(key), Collections.singletonList(SQLKey.keyToTable(key).getKey()), null, null, null);
            }
        }
    }

    private final SQLTable getTableIgnoringCase(SQLSchema s, String tablename) {
        for (String tname : s.getTableNames()) {
            if (!tname.equalsIgnoreCase(tablename)) continue;
            return s.getTable(tname);
        }
        return null;
    }

    private DBItemFileCache getFileCache() {
        boolean useXML = Boolean.getBoolean("org.openconcerto.sql.structure.useXML");
        DBFileCache d = this.getServer().getFileCache();
        if (!useXML || d == null) {
            return null;
        }
        return d.getChild(this.base);
    }

    private final File getRootFile(String root) {
        DBItemFileCache saveDir = this.getFileCache();
        if (saveDir == null) {
            return null;
        }
        return this.getGraphFile(saveDir.getChild(root));
    }

    private final List<DBItemFileCache> getSavedCaches(boolean withFile) {
        DBItemFileCache item = this.getFileCache();
        if (item == null) {
            return Collections.emptyList();
        }
        return item.getSavedDesc(DBRoot.class, withFile ? FILENAME : null);
    }

    final void deleteGraphFiles() {
        for (DBItemFileCache i : this.getSavedCaches(true)) {
            this.getGraphFile(i).delete();
        }
    }

    final void deleteGraphFile(String rootName) {
        this.getRootFile(rootName).delete();
    }

    private File getGraphFile(DBItemFileCache i) {
        return i.getFile(FILENAME);
    }

    boolean save(DBRoot r) {
        String rootName = r.getName();
        File rootFile = this.getRootFile(rootName);
        if (rootFile == null) {
            return false;
        }
        try {
            FileUtils.mkdir_p(rootFile.getParentFile());
            DBRoot root = this.base.getRoot(rootName);
            PrintWriter pWriter = new PrintWriter(new FileOutputStream(rootFile));
            pWriter.print("<root codecVersion=\"");
            pWriter.print(XML_VERSION);
            pWriter.print("\"");
            SQLSchema.getVersionAttr(r.getSchema(), pWriter);
            pWriter.println(" >\n");
            for (SQLTable t : root.getDescs(SQLTable.class)) {
                Set<Link> flinks = this.getForeignLinks(t);
                if (flinks.isEmpty()) continue;
                pWriter.print("<table name=\"");
                pWriter.print(JDOMUtils.OUTPUTTER.escapeAttributeEntities(t.getName()));
                pWriter.println("\">");
                for (Link l : flinks) {
                    l.toXML(pWriter);
                }
                pWriter.println("</table>");
            }
            pWriter.println("\n</root>");
            pWriter.close();
            return true;
        }
        catch (Exception e) {
            Log.get().warning("unable to save files in " + rootFile + "\n" + ExceptionUtils.getStackTrace(e));
            return false;
        }
    }

    private List<String> mapFromXML() throws JDOMException, IOException {
        ArrayList<String> res = new ArrayList<String>();
        for (DBItemFileCache cache : this.getSavedCaches(true)) {
            String actualVersion;
            Document doc = new SAXBuilder().build(this.getGraphFile(cache));
            String fileVersion = doc.getRootElement().getAttributeValue("codecVersion");
            if (!XML_VERSION.equals(fileVersion)) {
                throw new IOException("wrong version expected 20120228-1810 got: " + fileVersion);
            }
            String rootName = cache.getName();
            if (!this.base.contains(rootName)) continue;
            DBRoot r = (DBRoot)this.base.getCheckedChild(rootName);
            String xmlVersion = SQLSchema.getVersion(doc.getRootElement());
            if (!CompareUtils.equals(xmlVersion, actualVersion = r.getSchema().getVersion())) {
                throw new IOException("wrong version expected " + actualVersion + " got: " + xmlVersion);
            }
            for (Object o : doc.getRootElement().getChildren()) {
                Element tableElem = (Element)o;
                SQLTable t = r.getTable(tableElem.getAttributeValue("name"));
                for (Object lo : tableElem.getChildren()) {
                    Element linkElem = (Element)lo;
                    this.addLink(Link.fromXML(t, linkElem));
                }
            }
            res.add(rootName);
        }
        return res;
    }

    public Set<Link> getAllLinks(SQLTable table) {
        if (table == null) {
            throw new NullPointerException();
        }
        return this.getGraphP().edgesOf(table);
    }

    public Set<Link> getForeignLinks(SQLTable table) {
        Set<Link> res = this.foreignLinks.get(table);
        if (res == null) {
            res = Collections.unmodifiableSet(this.getGraphP().outgoingEdgesOf(table));
            this.foreignLinks.put(table, res);
        }
        return res;
    }

    public Set<SQLField> getForeignKeys(SQLTable table) {
        return DatabaseGraph.getLabels(this.getForeignLinks(table));
    }

    public final Set<List<SQLField>> getForeignKeysFields(SQLTable table) {
        return DatabaseGraph.getCols(this.getForeignLinks(table));
    }

    public Link getForeignLink(SQLField fk) {
        return this.getForeignLink(Collections.singletonList(fk));
    }

    public Link getForeignLink(SQLTable t, List<String> fields) {
        ArrayList<SQLField> fks = new ArrayList<SQLField>(fields.size());
        for (String s : fields) {
            fks.add(t.getField(s));
        }
        return this.getForeignLink(fks);
    }

    public Link getForeignLink(List<SQLField> fk) {
        if (fk.size() == 0) {
            throw new IllegalArgumentException("empty list");
        }
        if (!this.foreignLink.containsKey(fk)) {
            this.foreignLink.put(fk, (Link)org.apache.commons.collections.CollectionUtils.find(this.getForeignLinks(fk.get(0).getTable()), new LabelPredicate(fk)));
        }
        return this.foreignLink.get(fk);
    }

    public SQLTable getForeignTable(SQLField fk) {
        Link l = this.getForeignLink(fk);
        if (l != null) {
            return (SQLTable)l.getTarget();
        }
        return null;
    }

    public Set<Link> getForeignLinks(SQLTable t1, SQLTable t2) {
        if (t1 == null || t2 == null) {
            throw new NullPointerException("t1: " + t1 + ", t2: " + t2);
        }
        return this.getGraphP().getAllEdges(t1, t2);
    }

    public Set<SQLField> getForeignFields(SQLTable t1, SQLTable t2) {
        return DatabaseGraph.getLabels(this.getForeignLinks(t1, t2));
    }

    public Set<Link> getReferentLinks(SQLTable table) {
        return this.getGraphP().incomingEdgesOf(table);
    }

    public Set<SQLField> getReferentKeys(SQLTable table) {
        return DatabaseGraph.getLabels(this.getReferentLinks(table));
    }

    public Set<SQLTable> getReferentTables(SQLTable table) {
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        for (Link l : this.getReferentLinks(table)) {
            res.add((SQLTable)l.getSource());
        }
        return res;
    }

    public Set<SQLTable> findReferentTables(SQLTable table, String refTable, List<String> refKeys) {
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        for (Link l : this.getReferentLinks(table)) {
            if (!((SQLTable)l.getSource()).getName().equals(refTable) || !refKeys.isEmpty() && !l.getCols().equals(refKeys)) continue;
            res.add((SQLTable)l.getSource());
        }
        return res;
    }

    public SQLTable findReferentTable(SQLTable table, String refTable, List<String> refKeys) {
        return CollectionUtils.getSole(this.findReferentTables(table, refTable, refKeys));
    }

    public SQLTable findReferentTable(SQLTable table, String refTable, String ... refKeys) {
        return this.findReferentTable(table, refTable, Arrays.asList(refKeys));
    }

    public Set<Link> getLinks(SQLTable t1, SQLTable t2) {
        HashSet<Link> res = new HashSet<Link>(this.getForeignLinks(t1, t2));
        res.addAll(this.getForeignLinks(t2, t1));
        return res;
    }

    public Set<SQLField> getFields(SQLTable t1, SQLTable t2) {
        return DatabaseGraph.getLabels(this.getLinks(t1, t2));
    }

    public Where getWhereClause(SQLTable t1, SQLTable t2) {
        return this.getWhereClause(t1, t2, null);
    }

    public Where getWhereClause(SQLTable t1, SQLTable t2, Set<SQLField> fields) {
        Where res = null;
        for (Where w : this.getStraightWhereClause(t1, t2, fields)) {
            res = w.or(res);
        }
        return res;
    }

    public Set<Where> getStraightWhereClause(SQLTable t1, SQLTable t2, Set<SQLField> fields) {
        HashSet<Where> res = new HashSet<Where>();
        for (Link l : this.getLinks(t1, t2)) {
            SQLField f = l.getLabel();
            if (fields != null && (fields == null || !fields.contains(f))) continue;
            SQLTable target = (SQLTable)l.getTarget();
            res.add(new Where((FieldRef)f, "=", target.getKey()));
        }
        return res;
    }

    public Where getWhereClause(SQLField f) {
        return new Where((FieldRef)f, "=", this.getForeignTable(f).getKey());
    }

    public Where getJointure(List<String> path) {
        return this.getJointure(Path.create(this.getContext(), path));
    }

    public Where getJointure(Path p) {
        Where res = null;
        int i = 1;
        while (i <= p.length()) {
            SQLTable previous = p.getTable(i - 1);
            SQLTable table = p.getTable(i);
            Where wc = this.getWhereClause(previous, table, p.getStepFields(i - 1));
            res = wc.and(res);
            ++i;
        }
        return res;
    }

    public Set<Where> getStraightJoin(List<String> path) {
        return this.getStraightJoin(Path.create(this.getContext(), path));
    }

    public Set<Where> getStraightJoin(Path p) {
        if (p.length() == 0) {
            throw new IllegalArgumentException("Path empty");
        }
        if (p.length() == 1) {
            SQLTable previous = p.getTable(0);
            SQLTable table = p.getTable(1);
            return this.getStraightWhereClause(previous, table, p.getStepFields(0));
        }
        HashSet<Where> res = new HashSet<Where>();
        Set<Where> wheres = this.getStraightJoin(p.justFirst());
        for (Where where : wheres) {
            for (Where w : this.getStraightJoin(p.minusFirst())) {
                res.add(where.and(w));
            }
        }
        return res;
    }

    public Where getJointure(int ID, Path p) {
        return new Where((FieldRef)p.getFirst().getKey(), "=", ID).and(this.getJointure(p));
    }

    public GraFFF cloneForFilter(List<SQLTable> linksToRemove) {
        return GraFFF.create(this.getGraphP(), linksToRemove);
    }

    public GraFFF cloneForFilterKeep(Set<SQLField> linksToKeep) {
        return GraFFF.createKeep(this.getGraphP(), linksToKeep);
    }

    protected DirectedMultigraph<SQLTable, Link> getGraphP() {
        return (DirectedMultigraph)this.getGraph();
    }

    public static <C extends Collection<String>> C getNames(Collection<Link> links, C fields) {
        for (Link l : links) {
            fields.add((String)l.getLabel().getName());
        }
        return fields;
    }

    public static Set<String> getNames(Collection<Link> links) {
        return DatabaseGraph.getNames(links, new HashSet());
    }

    public static <C extends Collection<SQLField>> C getLabels(Collection<Link> links, C fields) {
        for (Link l : links) {
            fields.add((SQLField)l.getLabel());
        }
        return fields;
    }

    public static Set<SQLField> getLabels(Collection<Link> links) {
        return DatabaseGraph.getLabels(links, new HashSet());
    }

    public static <C extends Collection<List<SQLField>>> C getCols(Collection<Link> links, C fields) {
        for (Link l : links) {
            fields.add(l.getFields());
        }
        return fields;
    }

    public static Set<List<SQLField>> getCols(Collection<Link> links) {
        return DatabaseGraph.getCols(links, new HashSet());
    }
}

