/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;

public class SQLRowMode {
    public static final SQLRowMode DATA = new SQLRowMode(SQLSelect.UNARCHIVED, true, true);
    public static final SQLRowMode DEFINED = new SQLRowMode(SQLSelect.BOTH, true, true);
    public static final SQLRowMode VALID = new SQLRowMode(SQLSelect.UNARCHIVED, true, false);
    public static final SQLRowMode EXIST = new SQLRowMode(SQLSelect.BOTH, true, false);
    public static final SQLRowMode INEXISTANT;
    public static final SQLRowMode NO_CHECK;
    private final SQLSelect.ArchiveMode archiveMode;
    private final boolean existing;
    private final boolean undefined;

    static {
        NO_CHECK = INEXISTANT = new SQLRowMode(SQLSelect.BOTH, false, false);
    }

    public SQLRowMode(SQLSelect.ArchiveMode archiveMode, boolean existing, boolean undefined) {
        this.archiveMode = archiveMode;
        this.existing = existing;
        this.undefined = undefined;
    }

    public SQLSelect.ArchiveMode getArchiveMode() {
        return this.archiveMode;
    }

    public boolean wantExisting() {
        return this.existing;
    }

    public boolean excludeUndefined() {
        return this.undefined;
    }

    public boolean check(SQLRow r) {
        if (this == NO_CHECK) {
            return true;
        }
        if (r == null) {
            return false;
        }
        if (this.excludeUndefined() && r.isUndefined()) {
            return false;
        }
        if (this.getArchiveMode() == SQLSelect.ARCHIVED && !r.isArchived()) {
            return false;
        }
        if (this.getArchiveMode() == SQLSelect.UNARCHIVED && r.isArchived()) {
            return false;
        }
        return this.wantExisting() == r.exists();
    }

    public SQLRow filter(SQLRow r) {
        return this.check(r) ? r : null;
    }

    public void filter(Collection rows) {
        CollectionUtils.filter(rows, new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                return SQLRowMode.this.check((SQLRow)object);
            }
        });
    }
}

