/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.openconcerto.sql.model.SQLRequestLog;

public class SQLRequestLogModel
extends DefaultTableModel {
    SQLRequestLogModel() {
        SQLRequestLog.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SQLRequestLogModel.this.fireTableDataChanged();
            }
        });
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < 4) {
            return Long.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Heure";
            }
            case 1: {
                return "Dur\u00e9e totale";
            }
            case 2: {
                return "Dur\u00e9e SQL";
            }
            case 3: {
                return "Traitement";
            }
            case 4: {
                return "Requ\u00eate";
            }
            case 5: {
                return "Infos";
            }
            case 6: {
                return "Connexion";
            }
            case 7: {
                return "Thread";
            }
        }
        return "??";
    }

    @Override
    public int getRowCount() {
        return SQLRequestLog.getSize();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SQLRequestLog l = this.getRowAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return l.getStartAsMs();
            }
            case 1: {
                return l.getDurationTotalNano();
            }
            case 2: {
                return l.getDurationSQLNano();
            }
            case 3: {
                return l.getDurationTotalNano() - l.getDurationSQLNano();
            }
            case 4: {
                return l.getQuery();
            }
            case 5: {
                return l.getConnection();
            }
            case 6: {
                if (l.getConnectionId() == 0) {
                    return "";
                }
                return String.valueOf(l.getConnectionId());
            }
            case 7: {
                if (l.isInSwing()) {
                    return "Swing";
                }
                return l.getThreadId();
            }
        }
        return "";
    }

    public SQLRequestLog getRowAt(int rowIndex) {
        return SQLRequestLog.get(SQLRequestLog.getSize() - rowIndex - 1);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }
}

