/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.SQLData;

public class IResultSetHandler
implements ResultSetHandler {
    public static final Object REALLY_NULL = new Object();
    private static final Object NOT_YET_COMPUTED = new Object();
    private final ResultSetHandler delegate;
    private final Boolean useCache;
    private Object result;

    static final boolean shouldCache(Object result) {
        boolean shouldCache = result == REALLY_NULL ? true : result != null;
        return shouldCache;
    }

    public IResultSetHandler(ResultSetHandler rsh) {
        this(rsh, null);
    }

    public IResultSetHandler(ResultSetHandler rsh, Boolean useCache) {
        this.delegate = rsh;
        this.useCache = useCache;
        this.result = NOT_YET_COMPUTED;
    }

    public boolean readCache() {
        return this.useCache == null ? true : this.useCache;
    }

    public boolean writeCache() {
        if (this.useCache != null) {
            return this.useCache;
        }
        if (this.result == NOT_YET_COMPUTED) {
            throw new IllegalStateException(this + " hasn't yet been used");
        }
        return IResultSetHandler.shouldCache(this.result);
    }

    public Set<? extends SQLData> getCacheModifiers() {
        return null;
    }

    @Override
    public final Object handle(ResultSet rs) throws SQLException {
        this.result = this.delegate.handle(rs);
        return this.result;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IResultSetHandler) {
            IResultSetHandler o = (IResultSetHandler)obj;
            return this.delegate.equals(o.delegate);
        }
        return false;
    }
}

