/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItemDB;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.IClosure;

public final class DBSystemRoot
extends DBStructureItemDB {
    private DatabaseGraph graph = null;
    private final Set<String> rootsToMap = new HashSet<String>();
    private final PropertyChangeSupport supp;
    private SQLDataSource ds = null;
    private final List<String> schemaPath = new ArrayList<String>();
    private boolean incoherentPath = false;
    private final PropertyChangeListener coherenceListener;

    DBSystemRoot(DBStructureItemJDBC delegate) {
        super(delegate);
        this.supp = new PropertyChangeSupport(this);
        this.coherenceListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (DBSystemRoot.this.isIncoherentPath()) {
                    DBSystemRoot.this.setRootPathFromDS();
                } else {
                    Collection newVal = (Collection)evt.getNewValue();
                    Collection<String> inexistant = CollectionUtils.substract(DBSystemRoot.this.getRootPath(), newVal);
                    if (inexistant.size() > 0) {
                        DBSystemRoot.this.schemaPath.removeAll(inexistant);
                        if (DBSystemRoot.this.schemaPath.size() > 0) {
                            DBSystemRoot.this.setRootPath(DBSystemRoot.this.schemaPath);
                        } else {
                            DBSystemRoot.this.unsetRootPath();
                        }
                    }
                }
            }
        };
        this.getServer().init(this);
    }

    public final DBRoot getRoot(String name) {
        return (DBRoot)this.getCheckedChild(name);
    }

    public Set<String> getRootsToMap() {
        return this.rootsToMap;
    }

    public final SQLTable findTable(String name) {
        return this.findTable(name, false);
    }

    public final SQLTable findTable(String name, boolean mustExist) {
        for (String root : this.schemaPath) {
            if (!this.contains(root) || !this.getRoot(root).contains(name)) continue;
            return this.getRoot(root).getTable(name);
        }
        if (mustExist) {
            throw new DBStructureItemNotFound("table " + name + " not found in " + this.schemaPath);
        }
        return null;
    }

    final Set<String> getNodesToCreate(DBStructureItemJDBC parent) {
        if (this.isSystemRoot(parent)) {
            return this.getRootsToMap().size() == 0 ? null : this.getRootsToMap();
        }
        return null;
    }

    final boolean createNode(DBStructureItemJDBC parent, String childName) {
        if (!this.isSystemRoot(parent)) {
            return true;
        }
        HashSet<String> s = new HashSet<String>();
        s.add(childName);
        this.filterNodes(parent, s);
        return !s.isEmpty();
    }

    private boolean shouldMap(String childName) {
        return this.getRootsToMap().size() == 0 || this.getRootsToMap().contains(childName);
    }

    private boolean isSystemRoot(DBStructureItemJDBC parent) {
        return parent.getDBSystemRoot() == parent.getRawAlterEgo();
    }

    final void filterNodes(DBStructureItemJDBC parent, Set<String> childrenNames) {
        if (this.isSystemRoot(parent)) {
            parent.getServer().getSQLSystem().removeRootsToIgnore(childrenNames);
            Iterator<String> iter = childrenNames.iterator();
            while (iter.hasNext()) {
                String childName = iter.next();
                if (this.shouldMap(childName)) continue;
                iter.remove();
            }
        }
    }

    private final void setGraph(DatabaseGraph graph) {
        DatabaseGraph oldValue = this.graph;
        this.graph = graph;
        this.supp.firePropertyChange("graph", oldValue, this.graph);
    }

    void descendantsChanged() {
        this.descendantsChanged(true);
    }

    void descendantsChanged(boolean tableListChange) {
        this.clearGraph();
        if (tableListChange) {
            this.getDataSource().setTables(this.getDescs(SQLTable.class));
        }
    }

    private void clearGraph() {
        this.setGraph(null);
    }

    public synchronized DatabaseGraph getGraph() {
        if (this.graph == null) {
            try {
                this.setGraph(new DatabaseGraph(this));
            }
            catch (SQLException e) {
                throw new IllegalStateException("could not graph " + this, e);
            }
        }
        return this.graph;
    }

    public final SQLDataSource getDataSource() {
        if (this.ds == null) {
            throw new IllegalStateException("setDS() was not called");
        }
        return this.ds;
    }

    public final boolean hasDataSource() {
        return this.ds != null;
    }

    @Override
    protected void onDrop() {
        this.rmChildrenListener(this.coherenceListener);
        if (this.ds != null) {
            try {
                this.ds.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.clearGraph();
        super.onDrop();
    }

    public void refetch() throws SQLException {
        this.refetch(null);
    }

    public void refetch(Set<String> childrenNames) throws SQLException {
        if (this.getJDBC() instanceof SQLBase) {
            ((SQLBase)this.getJDBC()).fetchTables(childrenNames);
        } else if (this.getJDBC() instanceof SQLServer) {
            ((SQLServer)this.getJDBC()).refetch(childrenNames);
        } else {
            throw new IllegalStateException();
        }
    }

    public final void reload(Set<String> childrenNames) throws SQLException {
        if (this.getJDBC() instanceof SQLBase) {
            ((SQLBase)this.getJDBC()).loadTables(childrenNames);
        } else {
            this.refetch(childrenNames);
        }
    }

    public final void addRoots(List<String> roots) throws SQLException {
        this.getRootsToMap().addAll(roots);
        this.reload(new HashSet<String>(roots));
        ArrayList<String> newPath = new ArrayList<String>(this.schemaPath);
        newPath.addAll(roots);
        this.setRootPath(newPath);
    }

    boolean isSaved(String rootName) {
        if (this.getJDBC() instanceof SQLBase) {
            return ((SQLBase)this.getJDBC()).isSaved(rootName);
        }
        if (this.getJDBC() instanceof SQLServer) {
            return SQLBase.isSaved((SQLServer)this.getJDBC(), rootName, null);
        }
        throw new IllegalStateException();
    }

    public final void addListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    public final void rmListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public String dump() {
        String res = "";
        for (String rootName : new TreeSet<String>(this.getChildrenNames())) {
            DBRoot root = this.getRoot(rootName);
            res = String.valueOf(res) + root + "\n\n";
            res = String.valueOf(res) + root.dump() + "\n\n\n";
        }
        return res;
    }

    final void setDS(String login, String pass, IClosure<SQLDataSource> dsInit) {
        if (this.ds != null) {
            throw new IllegalStateException("already set: " + this.ds);
        }
        String baseName = this.getLevel() == HierarchyLevel.SQLBASE ? this.getName() : "";
        this.ds = new SQLDataSource(this.getServer(), baseName, login, pass);
        if (dsInit != null) {
            dsInit.executeChecked(this.ds);
        }
        this.addChildrenListener(this.coherenceListener);
        this.setRootPathFromDS();
    }

    private void setRootPathFromDS() {
        String dsSchema = this.ds.getSchema();
        Set<String> childrenNames = this.getChildrenNames();
        if (dsSchema != null && childrenNames.contains(dsSchema)) {
            this.setDefaultRoot(dsSchema);
        } else if (childrenNames.size() == 1) {
            this.setDefaultRoot(childrenNames.iterator().next());
        } else if (this.getServer().getSQLSystem().isNoDefaultSchemaSupported()) {
            this.setRootPath(Collections.<String>emptyList());
        } else {
            this.schemaPath.clear();
            this.incoherentPath = true;
            Log.get().warning("db default schema is " + dsSchema + " and the schemas of " + this + " are empty ; the first created schema will become the default one");
        }
    }

    public final boolean isIncoherentPath() {
        return this.incoherentPath;
    }

    public final void setDefaultRoot(String schemaName) {
        this.setRootPath(Collections.singletonList(schemaName));
    }

    public final void appendToRootPath(String schemaName) {
        ArrayList<String> newPath = new ArrayList<String>(this.schemaPath);
        newPath.add(schemaName);
        this.setRootPath(newPath);
    }

    public final void prependToRootPath(String schemaName) {
        ArrayList<String> newPath = new ArrayList<String>(this.schemaPath);
        newPath.add(0, schemaName);
        this.setRootPath(newPath);
    }

    public final void clearRootPath() {
        this.setRootPath(Collections.<String>emptyList());
    }

    public final void unsetRootPath() {
        this.getDataSource().unsetInitialSchema();
        this.setRootPathFromDS();
    }

    public final void setRootPath(List<String> schemaNames) {
        if (!this.getChildrenNames().containsAll(schemaNames)) {
            throw new IllegalArgumentException(schemaNames + " are not all in " + this + ": " + this.getChildrenNames());
        }
        if (schemaNames != this.schemaPath) {
            this.schemaPath.clear();
            this.schemaPath.addAll(schemaNames);
        }
        String dsSchema = schemaNames.size() > 0 ? schemaNames.get(0) : null;
        this.getDataSource().setInitialSchema(dsSchema);
        this.incoherentPath = false;
    }

    public final List<String> getRootPath() {
        return Collections.unmodifiableList(this.schemaPath);
    }

    public final DBRoot getDefaultRoot() {
        if (this.schemaPath.size() > 0) {
            return this.getRoot(this.schemaPath.get(0));
        }
        return null;
    }
}

