/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.EnumSet;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.AlterTable;

public class ToPrivate
extends Changer<SQLTable> {
    public static final String PRIVATE_TABLE = "privateTable";
    public static final String PARENT_FIELD = "parentField";
    public static final String PRIVATE_COUNT = "privateCount";
    private String privateTableName;
    private String parentFieldName;
    private int privateCount;

    public ToPrivate(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected EnumSet<SQLSystem> getCompatibleSystems() {
        return EnumSet.of(SQLSystem.MYSQL);
    }

    @Override
    public void setUpFromSystemProperties() {
        super.setUpFromSystemProperties();
        this.privateTableName = System.getProperty(PRIVATE_TABLE);
        this.parentFieldName = System.getProperty(PARENT_FIELD);
        this.privateCount = Integer.parseInt(System.getProperty(PRIVATE_COUNT, "1"));
    }

    public final String getPrivateField(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("negative: " + index);
        }
        if (index == 0) {
            return "ID_" + this.privateTableName;
        }
        return "ID_" + this.privateTableName + "_" + (index + 1);
    }

    @Override
    protected void changeImpl(SQLTable tableToUpdate) throws SQLException {
        SQLTable privateTable = tableToUpdate.getTable(this.privateTableName);
        SQLField parentField = privateTable.getField(this.parentFieldName);
        SQLSelect checkCount = new SQLSelect(privateTable.getBase());
        checkCount.addSelect(parentField, "count");
        checkCount.addGroupBy(parentField);
        String countExpr = "count(" + SQLBase.quoteIdentifier(parentField.getName()) + ")";
        checkCount.setHaving(Where.createRaw(String.valueOf(countExpr) + " > " + this.privateCount, parentField));
        checkCount.addRawOrder(String.valueOf(countExpr) + " DESC");
        checkCount.setLimit(1);
        Number n = (Number)this.getDS().executeScalar(checkCount.asString());
        if (n != null) {
            checkCount.addSelect(parentField);
            checkCount.setLimit(null);
            throw new IllegalStateException("More than " + this.privateCount + " rows : " + n + "\n" + checkCount.asString());
        }
        AlterTable alter = new AlterTable(tableToUpdate);
        int i = 0;
        while (i < this.privateCount) {
            String privateFieldName = this.getPrivateField(i);
            if (!tableToUpdate.contains(privateFieldName)) {
                this.getStream().println("Creating " + privateFieldName + "...");
                alter.addForeignColumn(privateFieldName, privateTable);
            }
            ++i;
        }
        if (!alter.isEmpty()) {
            this.getDS().execute(alter.asString());
            tableToUpdate.getSchema().updateVersion();
            tableToUpdate.fetchFields();
            this.getStream().println("done.");
        }
        String sep = "','";
        SQLSelect groupIDs = new SQLSelect(privateTable.getBase());
        groupIDs.addSelect(parentField);
        groupIDs.addSelect(parentField, "count", "ID count");
        String quotedID = SQLBase.quoteIdentifier(privateTable.getKey().getName());
        groupIDs.addRawSelect("cast( group_concat(" + quotedID + " separator " + "','" + ") as char)", "IDs");
        groupIDs.addGroupBy(parentField);
        Number undefIDobj = privateTable.getUndefinedIDNumber();
        String undefID = privateTable.getKey().getType().toString(undefIDobj);
        String quotedCount = SQLBase.quoteIdentifier("ID count");
        String quotedIDs = SQLBase.quoteIdentifier("IDs");
        UpdateBuilder update = new UpdateBuilder(tableToUpdate);
        update.addTable("\n( " + groupIDs.asString() + " )", SQLBase.quoteIdentifier("aggregatedIDs"));
        String join = tableToUpdate.getBase().quote("%i = %f", new SQLName("aggregatedIDs", parentField.getName()), tableToUpdate.getField(this.parentFieldName));
        Where dontOverwrite = null;
        StringBuilder splitIDs = new StringBuilder(256);
        int i2 = 1;
        while (i2 <= this.privateCount) {
            String privateFieldName = this.getPrivateField(i2 - 1);
            dontOverwrite = new Where((FieldRef)tableToUpdate.getField(privateFieldName), Where.NULL_IS_DATA_EQ, (Object)undefIDobj).and(dontOverwrite);
            splitIDs.setLength(0);
            splitIDs.append("case when ").append(quotedCount).append(" < ").append(i2).append(" then ").append(undefID);
            splitIDs.append(" else SUBSTRING_INDEX(SUBSTRING_INDEX(").append(quotedIDs).append(", ',', ").append(i2).append("), ',', -1) end ");
            update.set(privateFieldName, splitIDs.toString());
            ++i2;
        }
        update.setWhere(Where.createRaw(join, new FieldRef[0]).and(dontOverwrite));
        this.getStream().println(update.toString());
    }
}

