/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.text;

import java.awt.Color;
import java.util.Arrays;
import org.jdom.Element;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.Style;
import org.openconcerto.openoffice.StyleProperties;
import org.openconcerto.openoffice.StyleStyle;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.XMLVersion;

public class TextStyle
extends StyleStyle {
    public static final StyleStyleDesc<TextStyle> DESC = new StyleStyleDesc<TextStyle>(TextStyle.class, XMLVersion.OD, "text", "T"){
        {
            this.getRefElementsMap().putAll((Object)"text:style-name", Arrays.asList("text:linenumbering-configuration", "text:list-level-style-number", "text:ruby-text", "text:span"));
        }

        @Override
        public TextStyle create(ODPackage pkg, Element e) {
            return new TextStyle(pkg, e);
        }
    };
    private StyleTextProperties textProps = null;

    public TextStyle(ODPackage pkg, Element tableColElem) {
        super(pkg, tableColElem);
    }

    public final StyleTextProperties getTextProperties() {
        if (this.textProps == null) {
            this.textProps = new StyleTextProperties(this);
        }
        return this.textProps;
    }

    public final Color getColor() {
        return this.getTextProperties().getColor();
    }

    public final Color getBackgroundColor() {
        return this.getTextProperties().getBackgroundColor();
    }

    public static class StyleTextProperties
    extends StyleProperties {
        public StyleTextProperties(Style style) {
            super(style, DESC.getFamily());
        }

        public final Color getColor() {
            return OOUtils.decodeRGB(this.getAttributeValue("color", this.getNS("fo")));
        }

        public final void setColor(Color color) {
            this.getElement().setAttribute("color", OOUtils.encodeRGB(color), this.getNS("fo"));
        }

        public final String getFontName() {
            return this.getAttributeValue("font-name", this.getElement().getNamespace("style"));
        }

        public final String getLanguage() {
            return this.getAttributeValue("language", this.getNS("fo"));
        }

        public final String getCountry() {
            return this.getAttributeValue("country", this.getNS("fo"));
        }

        public final String getWeight() {
            return this.getAttributeValue("font-weight", this.getNS("fo"));
        }
    }
}

