/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.text;

import java.util.HashSet;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.text.ParagraphStyle;
import org.openconcerto.openoffice.text.TextDocument;
import org.openconcerto.openoffice.text.TextNode;
import org.openconcerto.openoffice.text.TextStyle;

public class Paragraph
extends TextNode<ParagraphStyle> {
    private static XPath textStylesPath = null;

    static Element createEmpty(XMLVersion ns) {
        return new Element("p", ns.getTEXT());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getTextStyles(Element elem) {
        HashSet<String> res = new HashSet<String>();
        Class<Paragraph> clazz = Paragraph.class;
        synchronized (Paragraph.class) {
            if (textStylesPath == null) {
                try {
                    textStylesPath = XPath.newInstance(".//text:span/@text:style-name");
                }
                catch (JDOMException e) {
                    throw new IllegalStateException(e);
                }
            }
            try {
                for (Object o : textStylesPath.selectNodes(elem)) {
                    res.add(((Attribute)o).getValue());
                }
            }
            catch (JDOMException e) {
                throw new IllegalArgumentException("could'nt evaluate with " + elem, e);
            }
            return res;
        }
    }

    Paragraph(Element elem, TextDocument parent) {
        super(elem, ParagraphStyle.class, parent);
    }

    public Paragraph(Element elem) {
        this(elem, (TextDocument)null);
    }

    public Paragraph(XMLVersion ns) {
        this(Paragraph.createEmpty(ns));
    }

    public Paragraph() {
        this(XMLVersion.getDefault());
    }

    public Paragraph(String text) {
        this();
        this.addContent(text);
    }

    public final ParagraphStyle getConditionalStyle() {
        String condName = this.getElement().getAttributeValue("cond-style-name", this.getElement().getNamespace());
        if (condName == null) {
            return null;
        }
        return (ParagraphStyle)this.getStyle(condName);
    }

    public final void setStyle(String styleName) {
        this.getElement().setAttribute("style-name", styleName, this.getElement().getNamespace());
    }

    public final void addContent(String text) {
        this.getElement().addContent(text);
    }

    public final void addTab() {
        this.getElement().addContent(new Element("tab", this.getElement().getNamespace()));
    }

    public final void addStyledContent(String text, String styleName) {
        if (styleName.equals(this.getStyleName())) {
            this.addContent(text);
        } else {
            Element span = new Element("span", this.getElement().getNamespace());
            span.setAttribute("style-name", styleName, this.getElement().getNamespace());
            span.addContent(text);
            this.getElement().addContent(span);
        }
    }

    private final Set<String> getUsedTextStyles() {
        return Paragraph.getTextStyles(this.getElement());
    }

    @Override
    protected void checkDocument(ODDocument doc) {
        if (this.getStyleName() != null && this.getStyle(doc.getPackage(), doc.getContentDocument()) == null) {
            throw new IllegalArgumentException("unknown style " + this.getStyleName() + " in " + doc);
        }
        for (String styleName : this.getUsedTextStyles()) {
            if (doc.getPackage().getStyle(TextStyle.DESC, styleName) != null) continue;
            throw new IllegalArgumentException(this + " is using a text:span with an undefined style : " + styleName);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getElement().getText();
    }
}

