/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.style.data;

import java.math.BigDecimal;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODValueType;
import org.openconcerto.openoffice.StyleProperties;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.style.data.DataStyle;
import org.openconcerto.openoffice.style.data.DateStyle;
import org.openconcerto.utils.TimeUtils;
import org.openconcerto.utils.convertor.NumberConvertor;

public class TimeStyle
extends DataStyle {
    public static final DataStyle.DataStyleDesc<TimeStyle> DESC = new DataStyle.DataStyleDesc<TimeStyle>(TimeStyle.class, XMLVersion.OD, "time-style", "N"){

        @Override
        public TimeStyle create(ODPackage pkg, Element e) {
            return new TimeStyle(pkg, e);
        }
    };
    private static final int DAY_LENGTH_IN_HOURS = 24;
    private static final int AM_LENGTH = 12;

    private static final String formatInt(int i, Element elem) {
        String res = String.valueOf(i);
        return !DateStyle.isShort(elem) && res.length() < 2 ? String.valueOf('0') + res : res;
    }

    public TimeStyle(ODPackage pkg, Element elem) {
        super(pkg, elem, ODValueType.TIME);
    }

    @Override
    protected Duration convertNonNull(Object o) {
        if (o instanceof Number) {
            return TimeUtils.timePartToDuration(this.getEpoch().getDate(NumberConvertor.toBigDecimal((Number)o)));
        }
        return null;
    }

    @Override
    public String format(Object o, CellStyle defaultStyle, boolean lenient) {
        Duration d = o instanceof Calendar ? TimeUtils.timePartToDuration((Calendar)o) : (Duration)o;
        Namespace numberNS = this.getElement().getNamespace();
        StringBuilder sb = new StringBuilder();
        Locale styleLocale = DateStyle.getLocale(this.getElement());
        boolean truncate = StyleProperties.parseBoolean(this.getElement().getAttributeValue("truncate-on-overflow", numberNS), true);
        List children = this.getElement().getChildren();
        for (Element elem : children) {
            if (!elem.getNamespace().equals(numberNS)) continue;
            if (elem.getName().equals("text")) {
                sb.append(elem.getText());
                continue;
            }
            if (elem.getName().equals("hours")) {
                int hours = d.getHours();
                if (truncate) {
                    hours %= 24;
                }
                if (elem.getChild("am-pm", numberNS) != null) {
                    int n = hours = d.getHours() == 0 ? 12 : (d.getHours() - 1) % 12 + 1;
                    assert (hours >= 1 && hours <= 12);
                }
                sb.append(TimeStyle.formatInt(hours, elem));
                continue;
            }
            if (elem.getName().equals("am-pm")) {
                boolean am = d.getHours() % 24 < 12;
                sb.append(new DateFormatSymbols(styleLocale).getAmPmStrings()[am ? 0 : 1]);
                continue;
            }
            if (elem.getName().equals("minutes")) {
                int minutes = truncate && this.getElement().getChild("hours", numberNS) == null ? d.getMinutes() % 60 : d.getMinutes();
                sb.append(TimeStyle.formatInt(minutes, elem));
                continue;
            }
            if (!elem.getName().equals("seconds")) continue;
            BigDecimal seconds = (BigDecimal)d.getField(DatatypeConstants.SECONDS);
            int secondsIntPart = truncate && this.getElement().getChild("hours", numberNS) == null && this.getElement().getChild("minutes", numberNS) == null ? seconds.intValue() % 60 : seconds.intValue();
            sb.append(TimeStyle.formatInt(secondsIntPart, elem));
            int decPlaces = StyleProperties.parseInt(elem.getAttributeValue("decimal-places", numberNS), 0);
            sb.append(DateStyle.formatSecondFraction(styleLocale, seconds, decPlaces));
        }
        return sb.toString();
    }
}

