/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.style.data;

import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODValueType;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.style.data.DataStyle;
import org.openconcerto.openoffice.style.data.NumberStyle;

public class PercentStyle
extends DataStyle {
    public static final DataStyle.DataStyleDesc<PercentStyle> DESC = new DataStyle.DataStyleDesc<PercentStyle>(PercentStyle.class, XMLVersion.OD, "percentage-style", "N"){

        @Override
        public PercentStyle create(ODPackage pkg, Element e) {
            return new PercentStyle(pkg, e);
        }
    };

    public PercentStyle(ODPackage pkg, Element elem) {
        super(pkg, elem, ODValueType.PERCENTAGE);
    }

    @Override
    protected Object convertNonNull(Object o) {
        return NumberStyle.toNumber(o, this.getEpoch());
    }

    @Override
    public String format(Object o, CellStyle defaultStyle, boolean lenient) {
        Number n = (Number)o;
        Namespace numberNS = this.getElement().getNamespace();
        StringBuilder sb = new StringBuilder();
        List children = this.getElement().getChildren();
        for (Element elem : children) {
            if (!elem.getNamespace().equals(numberNS)) continue;
            if (elem.getName().equals("text")) {
                sb.append(elem.getText());
                continue;
            }
            if (!elem.getName().equals("number")) continue;
            sb.append(this.formatNumberOrScientificNumber(elem, n, 100, defaultStyle));
        }
        return sb.toString();
    }
}

