/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.style.data;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODValueType;
import org.openconcerto.openoffice.StyleProperties;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.style.data.DataStyle;
import org.openconcerto.utils.convertor.NumberConvertor;

public class DateStyle
extends DataStyle {
    private static final Calendar BUDDHIST_CAL = Calendar.getInstance(new Locale("th", "TH"));
    private static final Calendar JAPANESE_CAL = Calendar.getInstance(new Locale("ja", "JP", "JP"));
    private static final Calendar GREGORIAN_CAL = new GregorianCalendar();
    public static final DataStyle.DataStyleDesc<DateStyle> DESC = new DataStyle.DataStyleDesc<DateStyle>(DateStyle.class, XMLVersion.OD, "date-style", "N"){

        @Override
        public DateStyle create(ODPackage pkg, Element e) {
            return new DateStyle(pkg, e);
        }
    };

    static final boolean isShort(Element elem) {
        return !"long".equals(elem.getAttributeValue("style", elem.getNamespace("number")));
    }

    public static final Locale getLocale(Element elem) {
        String country = elem.getAttributeValue("country", elem.getNamespace());
        String lang = elem.getAttributeValue("language", elem.getNamespace());
        Locale res = lang != null ? new Locale(lang, country == null ? "" : country) : Locale.getDefault();
        return res;
    }

    private static final Calendar getCalendar(Element elem, Calendar defaultCal) {
        Calendar res;
        String cal = elem.getAttributeValue("calendar", elem.getNamespace());
        if (cal == null) {
            res = defaultCal;
        } else if ("buddhist".equals(cal)) {
            res = BUDDHIST_CAL;
        } else if ("gengou".equals(cal)) {
            res = JAPANESE_CAL;
        } else if ("gregorian".equals(cal)) {
            res = GREGORIAN_CAL;
        } else {
            throw new IllegalArgumentException("Unsupported calendar : " + cal);
        }
        return res;
    }

    static String formatSecondFraction(Locale styleLocale, BigDecimal seconds, int decPlaces) {
        if (decPlaces > 0) {
            DecimalFormat decFormat = new DecimalFormat();
            decFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(styleLocale));
            decFormat.setMinimumIntegerDigits(0);
            decFormat.setMaximumIntegerDigits(0);
            decFormat.setMinimumFractionDigits(decPlaces);
            decFormat.setMaximumFractionDigits(decPlaces);
            return decFormat.format(seconds);
        }
        return "";
    }

    public DateStyle(ODPackage pkg, Element elem) {
        super(pkg, elem, ODValueType.DATE);
    }

    @Override
    protected Object convertNonNull(Object o) {
        if (o instanceof Number) {
            return this.getEpoch().getDate(NumberConvertor.toBigDecimal((Number)o));
        }
        return null;
    }

    private final void format(StringBuilder res, StringBuilder pattern, Locale styleLocale, Calendar currentCalendar, Date d) {
        if (pattern.length() > 0) {
            SimpleDateFormat fmt = new SimpleDateFormat(pattern.toString(), styleLocale);
            pattern.setLength(0);
            fmt.setCalendar((Calendar)currentCalendar.clone());
            res.append(fmt.format(d));
        }
    }

    @Override
    public String format(Object o, CellStyle defaultStyle, boolean lenient) {
        Date d = o instanceof Calendar ? ((Calendar)o).getTime() : (Date)o;
        Namespace numberNS = this.getElement().getNamespace();
        Locale styleLocale = DateStyle.getLocale(this.getElement());
        Calendar styleCalendar = Calendar.getInstance(styleLocale);
        StringBuilder res = new StringBuilder();
        Calendar currentCalendar = styleCalendar;
        StringBuilder sb = new StringBuilder();
        List children = this.getElement().getChildren();
        for (Element elem : children) {
            if (!elem.getNamespace().equals(numberNS)) continue;
            Calendar calendarLocaleElem = DateStyle.getCalendar(elem, styleCalendar);
            if (!calendarLocaleElem.equals(currentCalendar)) {
                this.format(res, sb, styleLocale, currentCalendar, d);
                currentCalendar = calendarLocaleElem;
            }
            if (elem.getName().equals("text")) {
                DataStyle.addStringLiteral(sb, elem.getText());
                continue;
            }
            if (elem.getName().equals("era")) {
                sb.append(DateStyle.isShort(elem) ? "G" : "GGGG");
                continue;
            }
            if (elem.getName().equals("year")) {
                sb.append(DateStyle.isShort(elem) ? "yy" : "yyyy");
                continue;
            }
            if (elem.getName().equals("quarter")) {
                Calendar cal = (Calendar)currentCalendar.clone();
                cal.setTime(d);
                double quarterLength = (double)cal.getActualMaximum(2) / 4.0;
                int quarter = (int)((double)cal.get(2) / quarterLength + 1.0);
                assert (quarter >= 1 && quarter <= 4);
                this.reportError("Quarters are not localized", lenient);
                DataStyle.addStringLiteral(sb, DateStyle.isShort(elem) ? "Q" + quarter : "Q" + quarter);
                continue;
            }
            if (elem.getName().equals("month")) {
                Attribute possessive = elem.getAttribute("possessive-form", numberNS);
                if (possessive != null) {
                    this.reportError("Ignoring " + possessive, lenient);
                }
                if (!StyleProperties.parseBoolean(elem.getAttributeValue("textual", numberNS), false)) {
                    sb.append(DateStyle.isShort(elem) ? "M" : "MM");
                    continue;
                }
                sb.append(DateStyle.isShort(elem) ? "MMM" : "MMMM");
                continue;
            }
            if (elem.getName().equals("week-of-year")) {
                sb.append("w");
                continue;
            }
            if (elem.getName().equals("day")) {
                sb.append(DateStyle.isShort(elem) ? "d" : "dd");
                continue;
            }
            if (elem.getName().equals("day-of-week")) {
                sb.append(DateStyle.isShort(elem) ? "E" : "EEEE");
                continue;
            }
            if (elem.getName().equals("am-pm")) {
                sb.append("a");
                continue;
            }
            if (elem.getName().equals("hours")) {
                if (this.getElement().getChild("am-pm", numberNS) == null) {
                    sb.append(DateStyle.isShort(elem) ? "H" : "HH");
                    continue;
                }
                sb.append(DateStyle.isShort(elem) ? "h" : "hh");
                continue;
            }
            if (elem.getName().equals("minutes")) {
                sb.append(DateStyle.isShort(elem) ? "m" : "mm");
                continue;
            }
            if (!elem.getName().equals("seconds")) continue;
            sb.append(DateStyle.isShort(elem) ? "s" : "ss");
            int decPlaces = StyleProperties.parseInt(elem.getAttributeValue("decimal-places", numberNS), 0);
            if (decPlaces <= 0) continue;
            Calendar cal = Calendar.getInstance(styleLocale);
            cal.setTime(d);
            BigDecimal secondFractions = new BigDecimal(cal.get(14)).movePointLeft(3);
            assert (secondFractions.compareTo(BigDecimal.ONE) < 0);
            String fractionPart = DateStyle.formatSecondFraction(styleLocale, secondFractions, decPlaces);
            DataStyle.addStringLiteral(sb, fractionPart);
        }
        this.format(res, sb, styleLocale, currentCalendar, d);
        return res.toString();
    }
}

