/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.style.data;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODValueType;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.style.data.DataStyle;
import org.openconcerto.openoffice.style.data.DateStyle;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.i18n.I18nUtils;

public class BooleanStyle
extends DataStyle {
    public static final DataStyle.DataStyleDesc<BooleanStyle> DESC = new DataStyle.DataStyleDesc<BooleanStyle>(BooleanStyle.class, XMLVersion.OD, "boolean-style", "N"){

        @Override
        public BooleanStyle create(ODPackage pkg, Element e) {
            return new BooleanStyle(pkg, e);
        }
    };

    public static final Boolean toBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return !NumberUtils.areNumericallyEqual(0, (Number)o);
        }
        return null;
    }

    public BooleanStyle(ODPackage pkg, Element elem) {
        super(pkg, elem, ODValueType.BOOLEAN);
    }

    @Override
    protected Boolean convertNonNull(Object o) {
        return BooleanStyle.toBoolean(o);
    }

    @Override
    public String format(Object o, CellStyle defaultStyle, boolean lenient) {
        Boolean b = (Boolean)o;
        Namespace numberNS = this.getElement().getNamespace();
        Locale styleLocale = DateStyle.getLocale(this.getElement());
        StringBuilder sb = new StringBuilder();
        List children = this.getElement().getChildren();
        for (Element elem : children) {
            if (!elem.getNamespace().equals(numberNS)) continue;
            if (elem.getName().equals("text")) {
                sb.append(elem.getText());
                continue;
            }
            if (!elem.getName().equals("boolean")) continue;
            ResourceBundle bundle = ResourceBundle.getBundle(I18nUtils.RSRC_BASENAME, styleLocale);
            if (!bundle.getLocale().getLanguage().equals(styleLocale.getLanguage())) {
                this.reportError("Boolean not localized", lenient);
            }
            sb.append(bundle.getString(I18nUtils.getBooleanKey(b)).toUpperCase(styleLocale));
        }
        return sb.toString();
    }
}

