/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.style;

import java.util.HashMap;
import java.util.Map;
import org.openconcerto.utils.CompareUtils;

public enum RelationalOperator {
    LT("<"){

        @Override
        protected boolean evaluate(int i) {
            return i < 0;
        }
    }
    ,
    GT(">"){

        @Override
        protected boolean evaluate(int i) {
            return i > 0;
        }
    }
    ,
    LE("<="){

        @Override
        protected boolean evaluate(int i) {
            return i <= 0;
        }
    }
    ,
    GE(">="){

        @Override
        protected boolean evaluate(int i) {
            return i >= 0;
        }
    }
    ,
    EQ("="){

        @Override
        protected boolean evaluate(int i) {
            return i == 0;
        }
    }
    ,
    NE("!="){

        @Override
        protected boolean evaluate(int i) {
            return !EQ.evaluate(i);
        }
    };

    private final String s;
    public static final String OR_PATTERN;
    private static final Map<String, RelationalOperator> instances;

    static {
        instances = new HashMap<String, RelationalOperator>();
        StringBuilder sb = new StringBuilder(32);
        RelationalOperator[] relationalOperatorArray = RelationalOperator.values();
        int n = relationalOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelationalOperator op = relationalOperatorArray[n2];
            instances.put(op.s, op);
            sb.append(op.asString());
            sb.append('|');
            ++n2;
        }
        sb.setLength(sb.length() - 1);
        OR_PATTERN = sb.toString();
    }

    private RelationalOperator(String s) {
        this.s = s;
    }

    public final String asString() {
        return this.s;
    }

    public final boolean compare(Object o1, Object o2) {
        return this.evaluate(CompareUtils.compare(o1, o2));
    }

    protected abstract boolean evaluate(int var1);

    public static RelationalOperator getInstance(String op) {
        return instances.get(op);
    }

    /* synthetic */ RelationalOperator(String string, int n, String string2, RelationalOperator relationalOperator) {
        this(string2);
    }
}

