/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.math.BigDecimal;
import java.util.Arrays;
import org.jdom.Element;
import org.openconcerto.openoffice.LengthUnit;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.StyleStyle;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.style.SideStyleProperties;

public class TableStyle
extends StyleStyle {
    public static final LengthUnit DEFAULT_UNIT = LengthUnit.MM;
    public static final StyleStyleDesc<TableStyle> DESC = new StyleStyleDesc<TableStyle>(TableStyle.class, XMLVersion.OD, "table", "ta", "table", Arrays.asList("table:background", "table:table")){

        @Override
        public TableStyle create(ODPackage pkg, Element e) {
            return new TableStyle(pkg, e);
        }
    };
    private StyleTableProperties tableProps;

    public TableStyle(ODPackage pkg, Element tableColElem) {
        super(pkg, tableColElem);
    }

    public final StyleTableProperties getTableProperties() {
        if (this.tableProps == null) {
            this.tableProps = new StyleTableProperties(this);
        }
        return this.tableProps;
    }

    public final Float getWidth() {
        BigDecimal width = this.getTableProperties().getWidth(DEFAULT_UNIT);
        return width == null ? null : Float.valueOf(width.floatValue());
    }

    void setWidth(float f) {
        this.getFormattingProperties().setAttribute("width", String.valueOf(f) + DEFAULT_UNIT.getSymbol(), this.getSTYLE());
    }

    public static class StyleTableProperties
    extends SideStyleProperties {
        public StyleTableProperties(StyleStyle style) {
            super(style, style.getFamily());
        }

        public final String getRawMargin(SideStyleProperties.Side s) {
            return this.getSideAttribute(s, "margin", this.getNS("fo"));
        }

        public final BigDecimal getMargin(SideStyleProperties.Side s, LengthUnit in) {
            return LengthUnit.parseLength(this.getRawMargin(s), in);
        }

        public final BigDecimal getWidth(LengthUnit in) {
            return LengthUnit.parseLength(this.getAttributeValue("width", this.getNS("style")), in);
        }
    }
}

