/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import javax.swing.table.AbstractTableModel;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.spreadsheet.Cell;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.spreadsheet.Table;
import org.openconcerto.utils.CompareUtils;

public class SheetTableModel<D extends ODDocument>
extends AbstractTableModel {
    protected final Table<D> table;
    protected final int row;
    protected final int column;
    protected final int lastRow;
    protected final int lastCol;

    SheetTableModel(Table<D> table, int row, int column) {
        this(table, row, column, table.getRowCount(), table.getColumnCount());
    }

    SheetTableModel(Table<D> table, int row, int column, int lastRow, int lastCol) {
        this.table = table;
        this.row = row;
        this.column = column;
        this.lastRow = lastRow;
        this.lastCol = lastCol;
    }

    @Override
    public int getColumnCount() {
        return this.lastCol - this.column;
    }

    @Override
    public int getRowCount() {
        return this.lastRow - this.row;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.check(rowIndex, columnIndex);
        return this.table.getValueAt(this.column + columnIndex, this.row + rowIndex);
    }

    public Cell<D> getImmutableCellAt(int rowIndex, int columnIndex) {
        this.check(rowIndex, columnIndex);
        return this.table.getImmutableCellAt(this.column + columnIndex, this.row + rowIndex);
    }

    protected final void check(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("row :" + rowIndex + " not between 0 and " + (this.getRowCount() - 1));
        }
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException("column: " + columnIndex + " not between 0 and " + (this.getColumnCount() - 1));
        }
    }

    public int hashCode() {
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        int prime = 17;
        int result = 1;
        result = 17 * result + rowCount;
        result = 17 * result + columnCount;
        int maxX = Math.min(4, columnCount);
        int maxY = Math.min(8, rowCount);
        int y = 0;
        while (y < maxY) {
            int x = 0;
            while (x < maxX) {
                Object v = this.getValueAt(x, y);
                result = 17 * result + (v == null ? 0 : v.hashCode());
                ++x;
            }
            ++y;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetTableModel)) {
            return false;
        }
        SheetTableModel other = (SheetTableModel)obj;
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        if (other.getRowCount() != rowCount || other.getColumnCount() != columnCount) {
            return false;
        }
        int y = 0;
        while (y < rowCount) {
            int x = 0;
            while (x < columnCount) {
                if (!CompareUtils.equals(this.getValueAt(x, y), other.getValueAt(x, y))) {
                    return false;
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    public static final class MutableTableModel<D extends ODDocument>
    extends SheetTableModel<D> {
        MutableTableModel(Table<D> table, int row, int column) {
            super(table, row, column);
        }

        MutableTableModel(Table<D> table, int row, int column, int lastRow, int lastCol) {
            super(table, row, column, lastRow, lastCol);
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            this.check(rowIndex, columnIndex);
            this.table.setValueAt(obj, this.column + columnIndex, this.row + rowIndex);
        }

        public MutableCell<D> getCellAt(int rowIndex, int columnIndex) {
            this.check(rowIndex, columnIndex);
            return this.table.getCellAt(this.column + columnIndex, this.row + rowIndex);
        }
    }
}

