/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.util.List;
import org.jdom.Element;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.ODNode;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.spreadsheet.Axis;
import org.openconcerto.openoffice.spreadsheet.Cell;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.spreadsheet.Row;
import org.openconcerto.openoffice.spreadsheet.Table;

abstract class RepeatedBreaker<P, C extends ODNode> {
    private static final RepeatedBreaker CELL_BREAKER = new RepeatedBreaker<Row<?>, Cell<?>>("number-columns-repeated"){

        @Override
        Cell<?> create(Element elem, Row<?> parent, int index, boolean single) {
            return this.createD(elem, parent, index, single);
        }

        <D extends ODDocument> Cell<D> createD(Element elem, Row<D> parent, int index, boolean single) {
            return single ? new MutableCell<D>(parent, elem, (StyleDesc<CellStyle>)parent.getSheet().getCellStyleDesc()) : new Cell<D>(parent, elem, (StyleDesc<CellStyle>)parent.getSheet().getCellStyleDesc());
        }
    };
    private static final RepeatedBreaker ROW_BREAKER = new RepeatedBreaker<Table<?>, Row<?>>(Axis.ROW.getRepeatedAttrName()){

        @Override
        Row<?> create(Element elem, Table<?> parent, int index, boolean single) {
            return this.createD(elem, parent, index, single);
        }

        <D extends ODDocument> Row<D> createD(Element elem, Table<D> parent, int index, boolean single) {
            return new Row<D>(parent, elem, index, parent.getRowStyleDesc(), parent.getCellStyleDesc());
        }
    };
    private final String attrName;

    static final <D extends ODDocument> RepeatedBreaker<Row<D>, Cell<D>> getCellBreaker() {
        return CELL_BREAKER;
    }

    static final <D extends ODDocument> RepeatedBreaker<Table<D>, Row<D>> getRowBreaker() {
        return ROW_BREAKER;
    }

    public RepeatedBreaker(String attrName) {
        this.attrName = attrName;
    }

    abstract C create(Element var1, P var2, int var3, boolean var4);

    public final void breakRepeated(P parent, List<C> children, int col) {
        ODNode c = (ODNode)children.get(col);
        Element element = c.getElement();
        String repeatedS = element.getAttributeValue(this.attrName, element.getNamespace());
        if (repeatedS != null) {
            int repeated = Integer.parseInt(repeatedS);
            int firstIndex = children.indexOf(c);
            int lastIndex = firstIndex + repeated - 1;
            int preRepeated = col - firstIndex;
            int postRepeated = lastIndex - col;
            this.breakRepeated(parent, children, element, firstIndex, preRepeated, true);
            element.removeAttribute(this.attrName, element.getNamespace());
            this.breakRepeated(parent, children, element, col + 1, postRepeated, false);
        }
        children.set(col, this.create(element, parent, col, true));
    }

    private final void breakRepeated(P parent, List<C> children, Element element, int firstIndex, int repeat2, boolean before) {
        if (repeat2 > 0) {
            Element newElem = (Element)element.clone();
            element.getParentElement().addContent(element.getParent().indexOf(element) + (before ? 0 : 1), newElem);
            newElem.setAttribute(this.attrName, String.valueOf(repeat2), element.getNamespace());
            C preCell = this.create(newElem, parent, firstIndex, false);
            int i = 0;
            while (i < repeat2) {
                children.set(firstIndex + i, preCell);
                ++i;
            }
        }
    }
}

