/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import org.jdom.Attribute;
import org.jdom.Element;
import org.openconcerto.openoffice.StyleProperties;

public final class Axis
extends Enum<Axis> {
    public static final /* enum */ Axis ROW = new Axis("row");
    public static final /* enum */ Axis COLUMN = new Axis("column");
    private final String shortName;
    private final String elemName;
    private final String headerName;
    private final String groupName;
    private final String pluralName;
    private final String repeatedAttrName;
    private static final /* synthetic */ Axis[] ENUM$VALUES;

    static {
        ENUM$VALUES = new Axis[]{ROW, COLUMN};
    }

    private Axis(String shortName) {
        this.shortName = shortName;
        this.elemName = "table-" + shortName;
        this.headerName = "table-header-" + shortName + "s";
        this.groupName = String.valueOf(this.elemName) + "-group";
        this.pluralName = String.valueOf(this.elemName) + "s";
        this.repeatedAttrName = "number-" + shortName + "s-repeated";
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final String getElemName() {
        return this.elemName;
    }

    public final String getHeaderName() {
        return this.headerName;
    }

    public final String getGroupName() {
        return this.groupName;
    }

    public final String getPluralName() {
        return this.pluralName;
    }

    public final String getRepeatedAttrName() {
        return this.repeatedAttrName;
    }

    final Attribute getRepeatedAttr(Element elem) {
        assert (elem.getName().equals(this.getElemName()));
        return elem.getAttribute(this.getRepeatedAttrName(), elem.getNamespace());
    }

    final int getRepeated(Element elem) {
        assert (elem.getName().equals(this.getElemName()));
        return StyleProperties.parseInt(elem.getAttributeValue(this.getRepeatedAttrName(), elem.getNamespace()), 1);
    }

    final void setRepeated(Element elem, int i) {
        assert (elem.getName().equals(this.getElemName()));
        if (i < 1) {
            throw new IllegalArgumentException("repeated <1 : " + i);
        }
        if (i == 1) {
            elem.removeAttribute(this.getRepeatedAttrName(), elem.getNamespace());
        } else {
            elem.setAttribute(this.getRepeatedAttrName(), String.valueOf(i), elem.getNamespace());
        }
    }

    public static Axis[] values() {
        Axis[] axisArray = ENUM$VALUES;
        int n = axisArray.length;
        Axis[] axisArray2 = new Axis[n];
        System.arraycopy(ENUM$VALUES, 0, axisArray2, 0, n);
        return axisArray2;
    }

    public static Axis valueOf(String string) {
        return Enum.valueOf(Axis.class, string);
    }
}

