/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.generation.view;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdom.JDOMException;
import org.jopendocument.link.Component;
import org.jopendocument.link.OOConnexion;
import org.openconcerto.openoffice.Log;
import org.openconcerto.openoffice.ODSingleXMLDocument;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.generation.GenerationTask;
import org.openconcerto.openoffice.generation.ReportGeneration;
import org.openconcerto.openoffice.generation.TaskStatus;
import org.openconcerto.openoffice.generation.desc.ReportType;
import org.openconcerto.openoffice.generation.desc.ReportTypes;
import org.openconcerto.openoffice.generation.view.GenerationTaskView;
import org.openconcerto.utils.EmailClient;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.model.ListComboBoxModel;

public abstract class BaseGenerationRapport<R extends ReportGeneration<?>>
extends JPanel {
    private JComboBox typeRapportComboSelection;
    private JButton genererButton;
    private JComboBox fileActionCombo;
    private JList tasksView;
    private JLabel status;
    private final ThreadGroup thg = new ThreadGroup(this + " thread group");

    public BaseGenerationRapport() throws JDOMException, IOException {
        this.uiInit();
        this.setStatus("Inactif");
    }

    protected Map<String, JComponent> getEntries() {
        return new LinkedHashMap<String, JComponent>();
    }

    protected File getReportDir() {
        return null;
    }

    private void uiInit() throws JDOMException, IOException {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.ipadx = 40;
        c.insets = new Insets(2, 5, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        LinkedHashMap<String, JComponent> allEntries = new LinkedHashMap<String, JComponent>();
        this.typeRapportComboSelection = new JComboBox(new ListComboBoxModel((Collection<?>)this.getTypes().getTypes()));
        allEntries.put("Type de rapport", this.typeRapportComboSelection);
        allEntries.putAll(this.getEntries());
        for (Map.Entry e : allEntries.entrySet()) {
            c.gridx = 0;
            ++c.gridy;
            this.add((java.awt.Component)new JLabel((String)e.getKey()), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add((java.awt.Component)e.getValue(), c);
            c.weightx = 0.0;
        }
        final File reportDir = this.getReportDir();
        if (reportDir != null) {
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 1.0;
            this.add((java.awt.Component)new JButton(new AbstractAction("Ouvrir le dossier des rapports"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Desktop.getDesktop().browse(reportDir.toURI());
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(BaseGenerationRapport.this, "Impossible d'ouvrir le dossier", "Erreur", 0);
                    }
                }
            }), c);
            c.weightx = 0.0;
        }
        c.gridx = 0;
        ++c.gridy;
        this.genererButton = new JButton("G\u00e9n\u00e9rer le rapport et");
        this.add((java.awt.Component)this.genererButton, c);
        this.genererButton.setEnabled(false);
        this.genererButton.addActionListener(new GenerateAction());
        ++c.gridx;
        this.fileActionCombo = new JComboBox<FileAction>(this.getAllowedActions());
        this.fileActionCombo.setSelectedItem((Object)FileAction.OPEN);
        this.add((java.awt.Component)this.fileActionCombo, c);
        this.fileActionCombo.setEnabled(false);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        this.status = new JLabel();
        this.add((java.awt.Component)this.status, c);
        ++c.gridy;
        this.tasksView = new JList(new TasksModel());
        this.tasksView.setCellRenderer(new GenerationTaskView());
        c.fill = 1;
        c.weighty = 1.0;
        JScrollPane scroll = new JScrollPane(this.tasksView);
        scroll.setPreferredSize(new Dimension(200, 400));
        this.add((java.awt.Component)scroll, c);
    }

    public final void interrupt() {
        this.thg.interrupt();
    }

    protected final void enableGeneration(boolean b) {
        this.fileActionCombo.setEnabled(b);
        this.genererButton.setEnabled(b);
    }

    protected final void generate(FileAction sel) {
        ReportType type = (ReportType)this.typeRapportComboSelection.getSelectedItem();
        R rg = this.createGeneration(type);
        ((ReportGeneration)rg).addTaskListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TaskStatus st = (TaskStatus)evt.getOldValue();
                if (st.getState().equals((Object)TaskStatus.State.NOT_STARTED)) {
                    BaseGenerationRapport.this.addTask((GenerationTask)evt.getSource());
                }
            }
        });
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Map<String, ODSingleXMLDocument> report = null;
        try {
            report = this.generate((ReportGeneration<?>)rg);
            if (report != null) {
                for (Map.Entry<String, ODSingleXMLDocument> e : report.entrySet()) {
                    try {
                        File reportFile = e.getValue().saveAs(this.getFile(rg, e.getKey()));
                        if (sel == FileAction.OPEN) {
                            OOUtils.open(reportFile);
                            continue;
                        }
                        if (sel != FileAction.MAIL) continue;
                        File fileOutPDF = FileUtils.addSuffix(reportFile, ".pdf");
                        try {
                            OOConnexion conn = OOConnexion.create();
                            if (conn == null) {
                                throw new IllegalStateException("OpenOffice n'a pu \u00eatre trouv\u00e9");
                            }
                            Component doc = conn.loadDocument(reportFile, true);
                            Future<File> pdf = doc.saveToPDF(fileOutPDF, "writer_pdf_Export");
                            doc.close();
                            conn.closeConnexion();
                            EmailClient.getPreferred().compose(this.getEmailRecipient(rg), "Rapport", null, pdf.get());
                        }
                        catch (Exception exn) {
                            exn.printStackTrace();
                            ExceptionHandler.handle("Impossible de charger le document OpenOffice dans le logiciel de courriel", exn);
                        }
                    }
                    catch (FileNotFoundException exn) {
                        ExceptionHandler.handle(this, "Le fichier est d\u00e9j\u00e0 ouvert, veuillez le refermer avant de g\u00e9n\u00e9rer.", exn);
                    }
                    catch (IOException exn) {
                        ExceptionHandler.handle(this, "Impossible de sauver le rapport", exn);
                    }
                }
            }
        }
        catch (Throwable e) {
            ExceptionHandler.handle(this, "Impossible de g\u00e9n\u00e9rer le rapport", e);
        }
    }

    private Map<String, ODSingleXMLDocument> generate(ReportGeneration<?> rg) throws Throwable {
        String s;
        this.clearTasks();
        this.setStatus("G\u00e9n\u00e9ration en cours...");
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        long start = System.currentTimeMillis();
        Map<String, ODSingleXMLDocument> report = null;
        Throwable t = null;
        try {
            report = rg.generateMulti();
            s = report == null ? "G\u00e9n\u00e9ration interrompue." : "Rapport g\u00e9n\u00e9r\u00e9 en " + (System.currentTimeMillis() - start) / 1000L + " secondes.";
        }
        catch (Throwable e) {
            s = "Erreur de g\u00e9n\u00e9ration.";
            t = e;
        }
        this.setStatus(s);
        if (t == null) {
            return report;
        }
        throw t;
    }

    private final void addTask(final GenerationTask task) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((TasksModel)BaseGenerationRapport.this.tasksView.getModel()).add(task);
            }
        });
    }

    private final void clearTasks() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((TasksModel)BaseGenerationRapport.this.tasksView.getModel()).clear();
            }
        });
    }

    private final void setStatus(final String status) {
        Log.get().info(this + " status: " + status);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseGenerationRapport.this.status.setText(status);
            }
        });
    }

    @Override
    public String toString() {
        return "Generation panel";
    }

    protected abstract ReportTypes getTypes() throws JDOMException, IOException;

    protected abstract R createGeneration(ReportType var1);

    protected abstract File getFile(R var1, String var2);

    protected String getEmailRecipient(R rg) {
        return null;
    }

    protected FileAction[] getAllowedActions() {
        return FileAction.values();
    }

    public static enum FileAction {
        DO_NOTHING("ne rien faire"),
        OPEN("ouvrir le fichier"),
        MAIL("envoyer par courriel");

        private final String label;

        private FileAction(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    class GenerateAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            BaseGenerationRapport.this.enableGeneration(false);
            final FileAction sel = (FileAction)((Object)BaseGenerationRapport.this.fileActionCombo.getSelectedItem());
            new Thread(BaseGenerationRapport.this.thg, new Runnable(){

                @Override
                public void run() {
                    BaseGenerationRapport.this.generate(sel);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BaseGenerationRapport.this.enableGeneration(true);
                        }
                    });
                }
            }).start();
        }
    }

    private static final class TasksModel
    extends AbstractListModel
    implements PropertyChangeListener {
        private List<GenerationTask> tasks = new ArrayList<GenerationTask>(15);

        private TasksModel() {
        }

        @Override
        public int getSize() {
            return this.tasks.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.tasks.get(index);
        }

        void add(GenerationTask task) {
            this.tasks.add(task);
            task.addPropertyChangeListener(this);
            this.fireIntervalAdded(this, this.tasks.size(), this.tasks.size());
        }

        void clear() {
            for (GenerationTask t : this.tasks) {
                t.removePropertyChangeListener(this);
            }
            this.fireIntervalRemoved(this, 0, this.tasks.size());
            this.tasks.clear();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int index = this.tasks.indexOf(evt.getSource());
            this.fireContentsChanged(this, index, index);
        }
    }
}

