/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.generation.desc;

import java.util.List;
import org.jdom.Element;
import org.openconcerto.openoffice.generation.desc.ParamsHelper;
import org.openconcerto.openoffice.generation.desc.ReportType;
import org.openconcerto.utils.cc.IFactory;

public abstract class XMLItem {
    protected final Element elem;
    private final String name;
    private final ReportType type;
    private final IFactory<?> dataFactory = new IFactory<Object>(){

        @Override
        public Object createChecked() {
            return XMLItem.this.getType().getRg().getCommonData();
        }
    };

    public XMLItem(Element elem) {
        this(elem, null);
    }

    public XMLItem(Element elem, ReportType rt) {
        this.elem = elem;
        this.name = elem.getAttributeValue("name");
        if (this.name == null) {
            throw new IllegalStateException("no attribute name for item: " + elem);
        }
        this.type = rt;
    }

    public final String getName() {
        return this.name;
    }

    public final ReportType getType() {
        return this instanceof ReportType ? (ReportType)this : this.type;
    }

    private final IFactory<?> getData() {
        return this.getType() == null ? null : this.dataFactory;
    }

    protected final Object evaluateOgnl(String s) {
        return ParamsHelper.evaluteOgnl(s, this.getData());
    }

    public String getParam(String paramName) {
        return ParamsHelper.getParam(this.elem, paramName, this.getData());
    }

    public String getParam(String paramName, String def) {
        String p = this.getParam(paramName);
        return p == null ? def : p;
    }

    public Boolean getBooleanParam(String paramName) {
        String p = this.getParam(paramName);
        return p == null ? null : Boolean.valueOf(Boolean.parseBoolean(p));
    }

    public boolean getBooleanParam(String paramName, boolean def) {
        Boolean p = this.getBooleanParam(paramName);
        return p == null ? def : p;
    }

    public List<String> getListParam(String paramName) {
        return ParamsHelper.getListParam(this.elem, paramName, this.getData());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getName();
    }
}

