/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.generation.desc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.filter.Filter;
import org.openconcerto.openoffice.generation.ReportGeneration;
import org.openconcerto.openoffice.generation.desc.ReportPart;
import org.openconcerto.openoffice.generation.desc.ReportTypes;
import org.openconcerto.openoffice.generation.desc.XMLItem;
import org.openconcerto.openoffice.generation.desc.part.ForkReportPart;
import org.openconcerto.openoffice.generation.desc.part.InsertReportPart;

public final class ReportType
extends XMLItem {
    private final ReportTypes parent;
    private final File template;
    private final List<ReportPart> children;
    private final Map<String, ForkReportPart> forks;
    private final ReportGeneration<?> rg;

    public static final Element createSingle(String typeName, String template, String common, String partType) {
        Element type = new Element("reportType").setAttribute("name", typeName);
        type.setAttribute("template", template);
        if (common != null) {
            type.setAttribute("common", common);
        }
        Element part = new Element("part").setAttribute("name", template);
        part.setAttribute("file", template);
        part.setAttribute("type", partType);
        type.addContent(part);
        return type;
    }

    public ReportType(ReportTypes parent, Element elem) {
        super(elem);
        this.parent = parent;
        this.template = this.getParent().resolve(elem.getAttributeValue("template"));
        this.children = new ArrayList<ReportPart>();
        this.forks = new HashMap<String, ForkReportPart>();
        this.addAll(this.createParts(this.elem));
        this.rg = null;
    }

    public ReportType(ReportType o, ReportGeneration<?> rg) {
        super(o.elem, null);
        this.parent = o.parent;
        this.template = o.template;
        this.children = Collections.unmodifiableList(this.createParts(this.elem));
        this.forks = null;
        this.rg = rg;
    }

    public final ReportGeneration<?> getRg() {
        return this.rg;
    }

    synchronized List<ReportPart> createParts(Element elem) {
        ArrayList<ReportPart> res = new ArrayList<ReportPart>(elem.getContentSize());
        List children = elem.getContent(new Filter(){

            @Override
            public boolean matches(Object obj) {
                if (!(obj instanceof Element)) {
                    return false;
                }
                return ReportPart.isPart((Element)obj);
            }
        });
        for (Element child : children) {
            res.addAll(ReportPart.create(this, child));
        }
        return res;
    }

    public synchronized List<ReportPart> getParts() {
        return this.children;
    }

    public String getCommon() {
        return this.elem.getAttributeValue("common");
    }

    public final File getTemplate() {
        return this.template;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public final ReportTypes getParent() {
        return this.parent;
    }

    private final void add(ReportPart part) {
        if (part instanceof ForkReportPart) {
            this.addFork((ForkReportPart)part);
        } else if (part instanceof InsertReportPart) {
            if (!this.forks.containsKey(part.getName())) {
                throw new IllegalStateException("no corresponding fork part with name : " + part.getName());
            }
            this.forks.remove(part.getName());
        }
        this.children.add(part);
    }

    private void addAll(List<ReportPart> list) {
        for (ReportPart part : list) {
            this.add(part);
        }
    }

    private final void addFork(ForkReportPart fork) {
        if (this.forks.containsKey(fork.getName())) {
            throw new IllegalStateException("fork already exists with name " + fork.getName());
        }
        this.forks.put(fork.getName(), fork);
    }
}

