/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.generation.desc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.openconcerto.openoffice.generation.desc.ReportType;
import org.openconcerto.openoffice.generation.desc.XMLItem;
import org.openconcerto.openoffice.generation.desc.part.ForkReportPart;
import org.openconcerto.openoffice.generation.desc.part.GeneratorReportPart;
import org.openconcerto.openoffice.generation.desc.part.InsertReportPart;
import org.openconcerto.openoffice.generation.desc.part.SubReportPart;

public abstract class ReportPart
extends XMLItem {
    private static final Set<String> tagsName = new HashSet<String>();

    static {
        tagsName.add("part");
        tagsName.add("fork");
        tagsName.add("insert");
        tagsName.add("sub");
    }

    public static final boolean isPart(Element elem) {
        return tagsName.contains(elem.getName());
    }

    public static final List<ReportPart> create(ReportType parent, Element child) {
        ArrayList<ReportPart> res = new ArrayList<ReportPart>();
        String tagName = child.getName();
        String childName = child.getAttributeValue("name");
        if (tagName.equals("part")) {
            res.add(new GeneratorReportPart(parent, childName, child));
        } else if (tagName.equals("fork")) {
            res.add(new ForkReportPart(parent, child, parent.createParts(child)));
        } else if (tagName.equals("insert")) {
            res.add(new InsertReportPart(parent, child));
        } else if (tagName.equals("sub")) {
            res.add(new SubReportPart(parent, child, parent.createParts(child)));
        } else {
            throw new IllegalArgumentException(child + " is not a part");
        }
        return res;
    }

    public ReportPart(ReportType type, Element elem) {
        super(elem, type);
    }

    public final String getCondition() {
        return this.elem.getAttributeValue("condition");
    }
}

