/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.generation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.Filter;
import org.openconcerto.openoffice.ODSingleXMLDocument;
import org.openconcerto.openoffice.generation.DocumentGenerator;
import org.openconcerto.openoffice.generation.GenerationCommon;
import org.openconcerto.openoffice.generation.GenerationTask;
import org.openconcerto.openoffice.generation.desc.ReportPart;
import org.openconcerto.openoffice.generation.desc.ReportType;
import org.openconcerto.openoffice.generation.desc.part.ConditionalPart;
import org.openconcerto.openoffice.generation.desc.part.ForkReportPart;
import org.openconcerto.openoffice.generation.desc.part.GeneratorReportPart;
import org.openconcerto.openoffice.generation.desc.part.InsertReportPart;
import org.openconcerto.openoffice.generation.desc.part.SubReportPart;
import org.openconcerto.utils.Tuple2;

public class ReportGeneration<C extends GenerationCommon> {
    private final ReportType type;
    private C common;
    private final InheritableThreadLocal<ReportPart> currentParts;
    private final InheritableThreadLocal<DocumentGenerator> currentGenerator;
    private Throwable interruptCause;
    private final ThreadGroup thg;
    private final List<PropertyChangeListener> taskListeners;
    private final PropertyChangeListener taskListener;
    private Map<String, Object> commonData;

    static {
        OgnlRuntime.setPropertyAccessor(Element.class, new PropertyAccessor(){

            @Override
            public Object getProperty(Map context, Object target, Object name) {
                Element elem = (Element)target;
                String n = (String)name;
                return elem.getChild(n);
            }

            @Override
            public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
                throw new OgnlException("", new UnsupportedOperationException("setProperty not supported on XML elements"));
            }
        });
    }

    public ReportGeneration(ReportType type) {
        this.type = new ReportType(type, this);
        this.common = null;
        this.commonData = null;
        this.currentParts = new InheritableThreadLocal();
        this.currentGenerator = new InheritableThreadLocal();
        this.interruptCause = null;
        this.thg = new ThreadGroup("Generateurs"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ReportGeneration.this.interrupt(e);
            }
        };
        this.taskListeners = new ArrayList<PropertyChangeListener>();
        this.taskListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                for (PropertyChangeListener l : ReportGeneration.this.taskListeners) {
                    l.propertyChange(evt);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ODSingleXMLDocument createTaskAndGenerate(GeneratorReportPart part) throws IOException, InterruptedException {
        GenerationTask task = new GenerationTask(part.getName(), ((GenerationCommon)this.getCommon()).createGenerator(part));
        task.addPropertyChangeListener(this.taskListener);
        try {
            ReportGeneration reportGeneration = this;
            synchronized (reportGeneration) {
                this.currentGenerator.set(task.getGenerator());
            }
            ODSingleXMLDocument res = task.generate();
            ReportGeneration reportGeneration2 = this;
            synchronized (reportGeneration2) {
                this.currentGenerator.set(null);
            }
            return res;
        }
        catch (IOException exn) {
            throw new IOException("Impossible de g\u00e9n\u00e9rer '" + part + "'", exn);
        }
    }

    public void addTaskListener(PropertyChangeListener l) {
        this.taskListeners.add(l);
    }

    protected void beginGeneration() {
    }

    protected boolean pageBreak() {
        return true;
    }

    protected C createCommon(String name) {
        return (C)new GenerationCommon<ReportGeneration>(this);
    }

    public final ODSingleXMLDocument generate() throws Throwable {
        Map<String, ODSingleXMLDocument> res = this.generateMulti();
        if (res.size() != 1) {
            throw new IllegalStateException("more than one document: " + res);
        }
        return res.get(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, ODSingleXMLDocument> generateMulti() throws Throwable {
        Map<String, ODSingleXMLDocument> res;
        ReportGeneration reportGeneration = this;
        synchronized (reportGeneration) {
            this.interruptCause = null;
        }
        Map<String, ODSingleXMLDocument> f = null;
        FutureTask<Map<String, ODSingleXMLDocument>> future = new FutureTask<Map<String, ODSingleXMLDocument>>(new Callable<Map<String, ODSingleXMLDocument>>(){

            @Override
            public Map<String, ODSingleXMLDocument> call() throws Exception {
                return ReportGeneration.this.createDocument();
            }
        });
        Thread thr = new Thread(this.thg, future);
        thr.start();
        try {
            thr.join();
            f = future.get();
        }
        catch (InterruptedException e) {
            f = null;
        }
        catch (Exception e) {
            this.interrupt(e);
        }
        ReportGeneration reportGeneration2 = this;
        synchronized (reportGeneration2) {
            if (this.interruptCause != null) {
                throw this.interruptCause;
            }
            res = Thread.currentThread().isInterrupted() || f == null ? null : f;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void interrupt(Throwable cause) {
        ReportGeneration reportGeneration = this;
        synchronized (reportGeneration) {
            if (this.interruptCause == null) {
                this.interruptCause = cause;
                this.thg.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ODSingleXMLDocument> createDocument() throws IOException, OgnlException, InterruptedException {
        this.commonData = null;
        this.beginGeneration();
        HashMap<String, ODSingleXMLDocument> res = new HashMap<String, ODSingleXMLDocument>();
        res.put(null, this.createEmptyDocument());
        HashMap<String, GenThread> forked = new HashMap<String, GenThread>();
        Stack<Tuple2<Iterator<ReportPart>, ODSingleXMLDocument>> s = new Stack<Tuple2<Iterator<ReportPart>, ODSingleXMLDocument>>();
        s.push(Tuple2.create(this.type.getParts().iterator(), (ODSingleXMLDocument)res.get(null)));
        while (this.hasNext(s) && !Thread.currentThread().isInterrupted()) {
            Iterator<ReportPart> i = s.peek().get0();
            ODSingleXMLDocument currentDoc = s.peek().get1();
            ReportPart part = i.next();
            ReportGeneration reportGeneration = this;
            synchronized (reportGeneration) {
                this.currentParts.set(part);
            }
            if (this.mustGenerate(part)) {
                GenThread thread;
                if (part instanceof ForkReportPart) {
                    thread = new GenThread(part.getName(), ((ForkReportPart)part).getChildren());
                    forked.put(part.getName(), thread);
                    thread.start();
                } else if (part instanceof SubReportPart) {
                    ODSingleXMLDocument newDoc;
                    SubReportPart subReportPart = (SubReportPart)part;
                    String docID = subReportPart.getDocumentID();
                    if (docID == null) {
                        newDoc = currentDoc;
                    } else if (res.containsKey(docID)) {
                        newDoc = (ODSingleXMLDocument)res.get(docID);
                    } else {
                        newDoc = this.createEmptyDocument();
                        res.put(docID, newDoc);
                    }
                    s.push(Tuple2.create(subReportPart.getChildren().iterator(), newDoc));
                } else if (part instanceof InsertReportPart) {
                    thread = (GenThread)forked.get(part.getName());
                    if (thread == null) {
                        throw new IllegalStateException(String.valueOf(part.getName()) + " has not been forked previously.");
                    }
                    List<ODSingleXMLDocument> forkedList = thread.getRes();
                    if (forkedList == null) {
                        Thread.currentThread().interrupt();
                    } else {
                        for (ODSingleXMLDocument doc : forkedList) {
                            this.add(currentDoc, doc);
                        }
                    }
                } else {
                    this.add(currentDoc, this.createTaskAndGenerate((GeneratorReportPart)part));
                }
            }
            reportGeneration = this;
            synchronized (reportGeneration) {
                this.currentParts.set(null);
            }
        }
        return res;
    }

    private boolean hasNext(Stack<Tuple2<Iterator<ReportPart>, ODSingleXMLDocument>> s) {
        if (s.peek().get0().hasNext()) {
            return true;
        }
        s.pop();
        if (s.isEmpty()) {
            return false;
        }
        return this.hasNext(s);
    }

    private ODSingleXMLDocument createEmptyDocument() throws IOException, InterruptedException {
        ODSingleXMLDocument f;
        DocumentGenerator templateGenerator = ((GenerationCommon)this.getCommon()).getStyleTemplateGenerator(this.type.getTemplate());
        if (templateGenerator == null) {
            try {
                f = ODSingleXMLDocument.createFromPackage(this.type.getTemplate());
            }
            catch (JDOMException e) {
                throw new IOException("invalid template " + this.type.getTemplate(), e);
            }
        } else {
            f = templateGenerator.generate();
        }
        f.getBody().removeContent(new Filter(){

            @Override
            public boolean matches(Object obj) {
                if (obj instanceof Element) {
                    Element elem = (Element)obj;
                    boolean isUserField = elem.getNamespace().equals(f.getVersion().getTEXT()) && elem.getName().equals("user-field-decls");
                    return !isUserField;
                }
                return true;
            }
        });
        ((GenerationCommon)this.getCommon()).preProcessDocument(f);
        return f;
    }

    private final void add(ODSingleXMLDocument f, ODSingleXMLDocument toAdd) {
        f.add(toAdd, f.getNumero() > 0 && this.pageBreak());
    }

    private final boolean mustGenerate(ReportPart part) throws OgnlException {
        if (part instanceof ConditionalPart) {
            ConditionalPart p = (ConditionalPart)((Object)part);
            return p.getCondition() == null || (Boolean)Ognl.getValue(p.getCondition(), this.getCommonData()) != false;
        }
        return true;
    }

    public final Map<String, Object> getCommonData() {
        if (this.commonData == null) {
            this.commonData = new HashMap<String, Object>();
            this.initCommonData(this.commonData);
        }
        return Collections.unmodifiableMap(this.commonData);
    }

    protected void initCommonData(Map<String, Object> res) {
        res.put("rg", this);
        res.put("variante", this.getReportType().getParam("variante"));
        res.put("dateFmt", DateFormat.getDateInstance(1));
        try {
            res.put("join", Ognl.getValue(":[@org.openconcerto.utils.CollectionUtils@join( #this, #sep == null ? ', ' : #sep )]", null));
            res.put("silentFirst", Ognl.getValue(":[#this.size == 0 ? null : #this[0]]", null));
        }
        catch (OgnlException exn) {
            exn.printStackTrace();
        }
    }

    public String toString() {
        return "generation of '" + this.getReportType() + "'";
    }

    public final C getCommon() {
        if (this.common == null) {
            this.common = this.createCommon(this.type.getCommon());
        }
        return this.common;
    }

    public final ReportType getReportType() {
        return this.type;
    }

    public final synchronized ReportPart getCurrentPart() {
        return (ReportPart)this.currentParts.get();
    }

    public final synchronized DocumentGenerator getCurrentGenerator() {
        return (DocumentGenerator)this.currentGenerator.get();
    }

    private class GenThread
    extends Thread {
        private final List m;
        private final List<ODSingleXMLDocument> res;

        public GenThread(String name, List generators) {
            super(name);
            this.m = generators;
            this.res = new ArrayList<ODSingleXMLDocument>(generators.size());
        }

        @Override
        public void run() {
            Iterator i = this.m.iterator();
            try {
                while (i.hasNext() && !Thread.currentThread().isInterrupted()) {
                    GeneratorReportPart part = (GeneratorReportPart)i.next();
                    this.res.add(ReportGeneration.this.createTaskAndGenerate(part));
                }
            }
            catch (Exception e) {
                ReportGeneration.this.interrupt(e);
            }
        }

        public final List<ODSingleXMLDocument> getRes() {
            try {
                if (!this.isInterrupted()) {
                    this.join();
                    return this.res;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
    }
}

