/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.awt.Color;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.Style;
import org.openconcerto.openoffice.StyleStyle;

public abstract class StyleProperties {
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    public static final String TRANSPARENT_NAME = "transparent";
    private final Style parentStyle;
    private final String propPrefix;

    public static final boolean parseBoolean(String s, boolean def) {
        return s == null ? def : Boolean.parseBoolean(s);
    }

    public static final int parseInt(String s, int def) {
        return s == null ? def : Integer.parseInt(s);
    }

    public static final Integer parseInteger(String s) {
        return s == null ? null : Integer.valueOf(s);
    }

    public StyleProperties(Style style, String propPrefix) {
        this.parentStyle = style;
        this.propPrefix = propPrefix;
    }

    public final Style getParentStyle() {
        return this.parentStyle;
    }

    public final Element getElement() {
        return this.getElement(this.getParentStyle(), true);
    }

    protected final Element getElement(Style s, boolean create) {
        return s.getFormattingProperties(this.propPrefix, create);
    }

    private final String getAttributeValue(Style s, String attrName, Namespace attrNS) {
        if (s == null) {
            return null;
        }
        Element elem = this.getElement(s, false);
        if (elem == null) {
            return null;
        }
        return elem.getAttributeValue(attrName, attrNS);
    }

    protected final String getAttributeValue(String attrName, Namespace attrNS) {
        String localRes = this.getAttributeValue(this.getParentStyle(), attrName, attrNS);
        if (localRes != null) {
            return localRes;
        }
        if (this.getParentStyle() instanceof StyleStyle) {
            StyleStyle defaultStyle = ((StyleStyle)this.getParentStyle()).getDefaultStyle();
            return this.getAttributeValue(defaultStyle, attrName, attrNS);
        }
        return null;
    }

    protected final Namespace getNS(String prefix) {
        return this.getParentStyle().getNS().getNS(prefix);
    }

    public final String getRawBackgroundColor() {
        return this.getAttributeValue("background-color", this.getNS("fo"));
    }

    public final Color getBackgroundColor() {
        String res = this.getRawBackgroundColor();
        if (res == null) {
            return null;
        }
        if (TRANSPARENT_NAME.equals(res)) {
            return TRANSPARENT;
        }
        return OOUtils.decodeRGB(res);
    }

    public final void setBackgroundColor(Color color) {
        this.setBackgroundColor(color.getAlpha() == TRANSPARENT.getAlpha() ? TRANSPARENT_NAME : OOUtils.encodeRGB(color));
    }

    public final void setBackgroundColor(String color) {
        this.getElement().setAttribute("background-color", color, this.getNS("fo"));
    }
}

