/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.GraphicStyle;
import org.openconcerto.openoffice.ODNode;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODXMLDocument;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.StyleStyle;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.spreadsheet.ColumnStyle;
import org.openconcerto.openoffice.spreadsheet.RowStyle;
import org.openconcerto.openoffice.spreadsheet.TableStyle;
import org.openconcerto.openoffice.style.PageLayoutStyle;
import org.openconcerto.openoffice.style.data.DataStyle;
import org.openconcerto.openoffice.text.ParagraphStyle;
import org.openconcerto.openoffice.text.TextStyle;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.xml.JDOMUtils;

public class Style
extends ODNode {
    private static final Map<XMLVersion, Map<String, StyleDesc<?>>> family2Desc;
    private static final Map<XMLVersion, Map<String, StyleDesc<?>>> elemName2Desc;
    private static final Map<XMLVersion, Map<Class<? extends Style>, StyleDesc<?>>> class2Desc;
    private static boolean descsLoaded;
    private static final Map<XMLVersion, CollectionMap<Tuple2<String, String>, StyleDesc<?>>> attribute2Desc;
    private final StyleDesc<?> desc;
    private final ODPackage pkg;
    private final String name;
    private final XMLFormatVersion ns;

    static {
        descsLoaded = false;
        int versionsCount = XMLVersion.values().length;
        family2Desc = new HashMap(versionsCount);
        elemName2Desc = new HashMap(versionsCount);
        class2Desc = new HashMap(versionsCount);
        attribute2Desc = new HashMap(versionsCount);
        XMLVersion[] xMLVersionArray = XMLVersion.values();
        int n = xMLVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            XMLVersion v = xMLVersionArray[n2];
            family2Desc.put(v, new HashMap());
            elemName2Desc.put(v, new HashMap());
            class2Desc.put(v, new HashMap());
            attribute2Desc.put(v, new CollectionMap(128));
            ++n2;
        }
    }

    private static void loadDescs() {
        if (!descsLoaded) {
            Style.registerAllVersions(CellStyle.DESC);
            Style.registerAllVersions(RowStyle.DESC);
            Style.registerAllVersions(ColumnStyle.DESC);
            Style.registerAllVersions(TableStyle.DESC);
            Style.registerAllVersions(TextStyle.DESC);
            Style.registerAllVersions(ParagraphStyle.DESC);
            DataStyle.DataStyleDesc<?>[] dataStyleDescArray = DataStyle.DATA_STYLES_DESCS;
            int n = DataStyle.DATA_STYLES_DESCS.length;
            int n2 = 0;
            while (n2 < n) {
                DataStyle.DataStyleDesc<?> d = dataStyleDescArray[n2];
                Style.registerAllVersions(d);
                ++n2;
            }
            Style.register(GraphicStyle.DESC);
            Style.register(GraphicStyle.DESC_OO);
            Style.register(PageLayoutStyle.DESC);
            Style.register(PageLayoutStyle.DESC_OO);
            descsLoaded = true;
        }
    }

    private static void registerAllVersions(StyleDesc<? extends Style> desc) {
        XMLVersion[] xMLVersionArray = XMLVersion.values();
        int n = xMLVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            XMLVersion v = xMLVersionArray[n2];
            if (v == desc.getVersion()) {
                Style.register(desc);
            } else {
                Style.register(StyleDesc.copy(desc, v));
            }
            ++n2;
        }
    }

    public static void register(StyleDesc<?> desc) {
        if (desc instanceof StyleStyleDesc) {
            StyleStyleDesc styleStyleDesc = (StyleStyleDesc)desc;
            if (family2Desc.get((Object)desc.getVersion()).put(styleStyleDesc.getFamily(), styleStyleDesc) != null) {
                throw new IllegalStateException(String.valueOf(styleStyleDesc.getFamily()) + " duplicate family");
            }
        } else if (elemName2Desc.get((Object)desc.getVersion()).put(desc.getElementName(), desc) != null) {
            throw new IllegalStateException(String.valueOf(desc.getElementName()) + " duplicate element name");
        }
        assert (desc != null) : "Will need containsKey() in getStyleDesc()";
        if (class2Desc.get((Object)desc.getVersion()).put(desc.getStyleClass(), desc) != null) {
            throw new IllegalStateException(desc.getStyleClass() + " duplicate");
        }
    }

    private static Collection<StyleDesc<?>> getDesc(XMLVersion version) {
        Style.loadDescs();
        return class2Desc.get((Object)version).values();
    }

    private static CollectionMap<Tuple2<String, String>, StyleDesc<?>> getAttr2Desc(XMLVersion version) {
        CollectionMap<Tuple2<String, String>, StyleDesc<?>> map = attribute2Desc.get((Object)version);
        if (map.isEmpty()) {
            for (StyleDesc<?> desc : Style.getDesc(version)) {
                Style.fillMap(map, desc, desc.getRefElementsMap());
                Style.fillMap(map, desc, desc.getMultiRefElementsMap());
            }
            assert (!map.isEmpty());
        }
        return map;
    }

    private static void fillMap(CollectionMap<Tuple2<String, String>, StyleDesc<?>> map, StyleDesc<?> desc, CollectionMap<String, String> elemsByAttrs) {
        for (Map.Entry<String, Collection<String>> e : elemsByAttrs.entrySet()) {
            for (String elementName : e.getValue()) {
                Tuple2<String, String> key = Tuple2.create(elementName, e.getKey());
                map.put((Object)key, (Object)desc);
            }
        }
    }

    public static Style warp(ODPackage pkg, Element styleElem) {
        Style.loadDescs();
        String name = styleElem.getName();
        if (name.equals("style")) {
            String family = StyleStyleDesc.getFamily(styleElem);
            Map<String, StyleDesc<?>> map = family2Desc.get((Object)pkg.getVersion());
            if (map.containsKey(family)) {
                StyleDesc<?> styleClass = map.get(family);
                return styleClass.create(pkg, styleElem);
            }
            return new StyleStyle(pkg, styleElem);
        }
        Map<String, StyleDesc<?>> map = elemName2Desc.get((Object)pkg.getVersion());
        if (map.containsKey(name)) {
            StyleDesc<?> styleClass = map.get(name);
            return styleClass.create(pkg, styleElem);
        }
        return new Style(pkg, styleElem);
    }

    public static <S extends Style> S getStyle(ODPackage pkg, Class<S> clazz, String name) {
        StyleDesc<S> styleDesc = Style.getStyleDesc(clazz, pkg.getVersion());
        return styleDesc.findStyleWithName(pkg, pkg.getContent().getDocument(), name);
    }

    public static Element getReferencedStyleElement(ODPackage pkg, Attribute styleAttr) {
        Style res = Style.getReferencedStyle(pkg, styleAttr);
        if (res != null) {
            return res.getElement();
        }
        return null;
    }

    public static Style getReferencedStyle(ODPackage pkg, Attribute styleAttr) {
        if (styleAttr == null) {
            return null;
        }
        assert (styleAttr.getDocument() == pkg.getDocument(ODPackage.RootElement.CONTENT.getZipEntry()) || styleAttr.getDocument() == pkg.getDocument(ODPackage.RootElement.STYLES.getZipEntry())) : "attribute not defined in either the content or the styles of " + pkg;
        Collection<StyleDesc<?>> descs = Style.getAttr2Desc(pkg.getVersion()).getNonNull(Tuple2.create(styleAttr.getParent().getQualifiedName(), styleAttr.getQualifiedName()));
        for (StyleDesc<?> desc : descs) {
            Element res = pkg.getStyle(styleAttr.getDocument(), desc, styleAttr.getValue());
            if (res == null) continue;
            return desc.create(pkg, res);
        }
        return null;
    }

    public static <S extends Style> StyleDesc<S> getStyleDesc(Class<S> clazz, XMLVersion version) {
        return Style.getStyleDesc(clazz, version, true);
    }

    public static <S extends StyleStyle> StyleStyleDesc<S> getStyleStyleDesc(Class<S> clazz, XMLVersion version) {
        return (StyleStyleDesc)Style.getStyleDesc(clazz, version);
    }

    private static <S extends Style> StyleDesc<S> getStyleDesc(Class<S> clazz, XMLVersion version, boolean mustExist) {
        Style.loadDescs();
        Map<Class<Style>, StyleDesc<?>> map = class2Desc.get((Object)version);
        StyleDesc<?> res = map.get(clazz);
        if (res == null && mustExist) {
            throw new IllegalArgumentException("unregistered " + clazz + " for version " + (Object)((Object)version));
        }
        return res;
    }

    protected static <S extends Style> StyleDesc<S> getNonNullStyleDesc(final Class<S> clazz, XMLVersion version, final Element styleElem, String styleName) {
        StyleDesc<S> registered = Style.getStyleDesc(clazz, version, false);
        if (registered != null) {
            return registered;
        }
        if (clazz == StyleStyle.class) {
            StyleStyleDesc<StyleStyle> res = new StyleStyleDesc<StyleStyle>(StyleStyle.class, version, StyleStyleDesc.getFamily(styleElem), styleName){

                @Override
                public StyleStyle create(ODPackage pkg, Element e) {
                    return new StyleStyle(pkg, styleElem);
                }
            };
            return res;
        }
        if (clazz == Style.class) {
            return new StyleDesc<S>(clazz, version, styleElem.getName(), styleName){

                @Override
                public S create(ODPackage pkg, Element e) {
                    return (Style)clazz.cast(new Style(pkg, styleElem));
                }
            };
        }
        throw new IllegalStateException("Unregistered class which is neither Style not StyleStyle :" + clazz);
    }

    public Style(ODPackage pkg, Element styleElem) {
        super(styleElem);
        this.pkg = pkg;
        this.name = this.getElement().getAttributeValue("name", this.getSTYLE());
        this.ns = this.pkg.getFormatVersion();
        this.desc = Style.getNonNullStyleDesc(this.getClass(), this.ns.getXMLVersion(), styleElem, this.getName());
        this.checkElemName();
        assert (this.pkg.getXMLFile(this.getElement().getDocument()) != null);
        assert (this.pkg.getFormatVersion().equals(XMLFormatVersion.get(this.getElement().getDocument())));
    }

    protected void checkElemName() {
        if (!this.desc.getElementName().equals(this.getElement().getName())) {
            throw new IllegalArgumentException("expected " + this.desc.getElementName() + " but got " + this.getElement().getName() + " for " + this.getElement());
        }
    }

    protected final ODPackage getPackage() {
        return this.pkg;
    }

    protected final Namespace getSTYLE() {
        return this.getElement().getNamespace("style");
    }

    public final XMLVersion getNS() {
        return this.ns.getXMLVersion();
    }

    public final String getName() {
        return this.name;
    }

    protected StyleDesc<?> getDesc() {
        return this.desc;
    }

    public Element getFormattingProperties() {
        return this.getFormattingProperties(this.getName());
    }

    public final Element getFormattingProperties(String family) {
        return this.getFormattingProperties(family, true);
    }

    public final Element getFormattingProperties(String family, boolean create) {
        Element elem = this.ns.getXML().createFormattingProperties(family);
        Element res = this.getElement().getChild(elem.getName(), elem.getNamespace());
        if (res == null && create) {
            res = elem;
            this.getElement().addContent(res);
        }
        return res;
    }

    private final List<Element> getReferences(Document doc, boolean wantSingle, boolean wantMulti) {
        return this.desc.getReferences(doc, this.getName(), wantSingle, wantMulti);
    }

    public final List<Element> getReferences() {
        return this.getReferences(true, true);
    }

    private final List<Element> getReferences(boolean wantSingle, boolean wantMulti) {
        Document myDoc = this.getElement().getDocument();
        Document content = this.pkg.getContent().getDocument();
        List<Element> res = this.getReferences(myDoc, wantSingle, wantMulti);
        if (myDoc != content && !this.isAutomatic()) {
            res.addAll(this.getReferences(content, wantSingle, wantMulti));
        }
        return res;
    }

    private final boolean isAutomatic() {
        return this.getElement().getParentElement().getQualifiedName().equals("office:automatic-styles");
    }

    public final boolean isReferencedAtMostOnce() {
        return this.getReferences(false, true).size() == 0 && this.getReferences(true, false).size() <= 1;
    }

    public final Style dup() {
        ODXMLDocument xmlFile = this.pkg.getXMLFile(this.getElement().getDocument());
        String unusedName = xmlFile.findUnusedName(this.desc, this.desc.getBaseName());
        Element clone = (Element)this.getElement().clone();
        clone.setName(this.desc.getElementName());
        clone.setAttribute("name", unusedName, this.getSTYLE());
        JDOMUtils.insertAfter(this.getElement(), Collections.singleton(clone));
        return this.desc.create(this.pkg, clone);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Style)) {
            return false;
        }
        Style o = (Style)obj;
        return this.getName().equals(o.getName()) && this.getElement().getName().equals(o.getElement().getName()) && this.getElement().getNamespace().equals(o.getElement().getNamespace());
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getElement().getName().hashCode() + this.getElement().getNamespace().hashCode();
    }
}

