/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.xpath.XPath;
import org.openconcerto.openoffice.LengthUnit;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.xml.JDOMUtils;
import org.openconcerto.xml.Validator;
import org.xml.sax.SAXException;

public abstract class OOXML
implements Comparable<OOXML> {
    public static final String LAST_FOR_UNKNOWN_PROP = String.valueOf(OOXML.class.getPackage().getName()) + ".lastOOXMLForUnknownVersion";
    private static final XML_OO instanceOO = new XML_OO();
    private static final SortedMap<String, XML_OD> instancesODByDate = new TreeMap<String, XML_OD>();
    private static final Map<String, XML_OD> instancesODByVersion = new HashMap<String, XML_OD>();
    private static final List<OOXML> values;
    private static OOXML defaultInstance;
    private final XMLFormatVersion version;
    private final String dateString;

    static {
        OOXML.register(new XML_OD_1_0());
        OOXML.register(new XML_OD_1_1());
        OOXML.register(new XML_OD_1_2());
        values = new ArrayList<OOXML>(instancesODByDate.size() + 1);
        values.add(instanceOO);
        values.addAll(instancesODByDate.values());
        OOXML.setDefault(OOXML.getLast());
    }

    private static void register(XML_OD xml) {
        assert (xml.getVersion() == XMLVersion.OD);
        instancesODByDate.put(xml.getDateString(), xml);
        instancesODByVersion.put(xml.getFormatVersion().getOfficeVersion(), xml);
    }

    public static OOXML get(XMLFormatVersion version) {
        return OOXML.get(version, Boolean.getBoolean(LAST_FOR_UNKNOWN_PROP));
    }

    public static OOXML get(XMLFormatVersion version, boolean lastForUnknown) {
        if (version.getXMLVersion() == XMLVersion.OOo) {
            return instanceOO;
        }
        XML_OD res = instancesODByVersion.get(version.getOfficeVersion());
        if (res == null && lastForUnknown) {
            return OOXML.getLast(version.getXMLVersion());
        }
        return res;
    }

    public static OOXML get(Element root) {
        return XMLFormatVersion.get(root).getXML();
    }

    public static final List<OOXML> values() {
        return values;
    }

    public static final OOXML getLast() {
        return CollectionUtils.getLast(values);
    }

    public static final OOXML getLast(XMLVersion version) {
        if (version == XMLVersion.OOo) {
            return instanceOO;
        }
        return (OOXML)instancesODByDate.get(instancesODByDate.lastKey());
    }

    public static void setDefault(OOXML ns) {
        defaultInstance = ns;
    }

    public static OOXML getDefault() {
        return defaultInstance;
    }

    private static final String rt2oo(String content, String tagName, String styleName) {
        return content.replaceAll("\\[" + tagName + "\\]", "<text:span text:style-name=\"" + styleName + "\">").replaceAll("\\[/" + tagName + "\\]", "</text:span>");
    }

    private static final BigDecimal parseCoordinate(Element elem, String attrName, Namespace ns, LengthUnit unit) {
        return OOXML.parseLength(elem, attrName, ns, unit);
    }

    private static final BigDecimal parseLength(Element elem, String attrName, Namespace ns, LengthUnit unit) {
        String attr = elem.getAttributeValue(attrName, ns);
        if (attr == null) {
            return null;
        }
        return LengthUnit.parseLength(attr, unit);
    }

    private OOXML(XMLFormatVersion version, String dateString) {
        this.version = version;
        this.dateString = dateString;
    }

    public final String getDateString() {
        return this.dateString;
    }

    @Override
    public int compareTo(OOXML o) {
        return this.dateString.compareTo(o.dateString);
    }

    public final XMLVersion getVersion() {
        return this.getFormatVersion().getXMLVersion();
    }

    public final XMLFormatVersion getFormatVersion() {
        return this.version;
    }

    public abstract boolean canValidate();

    public abstract Validator getValidator(Document var1);

    public abstract String[] getFontDecls();

    public final Element getLineBreak() {
        return new Element("line-break", this.getVersion().getTEXT());
    }

    public abstract Element getTab();

    public abstract String getFrameQName();

    public abstract Element createFormattingProperties(String var1);

    protected final List encodeRT_L(String content, Map<String, String> styles) {
        String res = JDOMUtils.OUTPUTTER.escapeElementEntities(content);
        for (Map.Entry<String, String> e : styles.entrySet()) {
            res = OOXML.rt2oo(res, e.getKey(), e.getValue());
        }
        try {
            return JDOMUtils.parseString(res, this.getVersion().getALL());
        }
        catch (JDOMException e) {
            throw new IllegalStateException("could not parse " + res, e);
        }
    }

    public final Element encodeRT(String content, Map<String, String> styles) {
        return new Element("span", this.getVersion().getTEXT()).addContent(this.encodeRT_L(content, styles));
    }

    private Element createSpaces(String spacesS) {
        return new Element("s", this.getVersion().getTEXT()).setAttribute("c", String.valueOf(spacesS.length()), this.getVersion().getTEXT());
    }

    public final Element encodeWS(String s) {
        return new Element("span", this.getVersion().getTEXT()).setContent(this.encodeWSasList(s));
    }

    public final List<Content> encodeWSasList(String s) {
        ArrayList<Content> res = new ArrayList<Content>();
        Matcher m = Pattern.compile("\n|\t| {2,}").matcher(s);
        int last = 0;
        while (m.find()) {
            res.add(new Text(s.substring(last, m.start())));
            switch (m.group().charAt(0)) {
                case '\n': {
                    res.add(this.getLineBreak());
                    break;
                }
                case '\t': {
                    res.add(this.getTab());
                    break;
                }
                case ' ': {
                    res.add(this.createSpaces(m.group()));
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown item: " + m.group());
                }
            }
            last = m.end();
        }
        res.add(new Text(s.substring(last)));
        return res;
    }

    public final void encodeWS(Text t) {
        Parent parent = t.getParent();
        int ind = parent.indexOf(t);
        t.detach();
        parent.getContent().addAll(ind, this.encodeWSasList(t.getText()));
    }

    public final Element encodeWS(Element elem) {
        XPath path;
        try {
            path = OOUtils.getXPath(".//text()", this.getVersion());
        }
        catch (JDOMException e) {
            throw new IllegalStateException("cannot create XPath", e);
        }
        try {
            for (Text t : new ArrayList(path.selectNodes(elem))) {
                this.encodeWS(t);
            }
        }
        catch (JDOMException e) {
            throw new IllegalArgumentException("cannot find text nodes of " + elem, e);
        }
        return elem;
    }

    public final BigDecimal[] getCoordinates(Element elem, LengthUnit unit) {
        return this.getCoordinates(elem, unit, true, true);
    }

    public final BigDecimal[] getCoordinates(Element elem, LengthUnit unit, boolean horizontal, boolean vertical) {
        return OOXML.getCoordinates(elem, this.getVersion().getNS("svg"), unit, horizontal, vertical);
    }

    private static final BigDecimal[] getCoordinates(Element elem, Namespace svgNS, LengthUnit unit, boolean horizontal, boolean vertical) {
        if (elem.getName().equals("g") && elem.getNamespacePrefix().equals("draw")) {
            if (!horizontal && !vertical) {
                return new BigDecimal[4];
            }
            BigDecimal minX = null;
            BigDecimal minY = null;
            BigDecimal maxX = null;
            BigDecimal maxY = null;
            for (Object c : elem.getChildren()) {
                Element child = (Element)c;
                BigDecimal[] childCoord = OOXML.getCoordinates(child, svgNS, unit, horizontal, vertical);
                if (childCoord == null) continue;
                BigDecimal x = childCoord[0];
                BigDecimal x2 = childCoord[2];
                if (x != null) {
                    assert (x2 != null);
                    if (minX == null || x.compareTo(minX) < 0) {
                        minX = x;
                    }
                    if (maxX == null || x2.compareTo(maxX) > 0) {
                        maxX = x2;
                    }
                }
                BigDecimal y = childCoord[1];
                BigDecimal y2 = childCoord[3];
                if (y == null) continue;
                assert (y2 != null);
                if (minY == null || y.compareTo(minY) < 0) {
                    minY = y;
                }
                if (maxY != null && y2.compareTo(maxY) <= 0) continue;
                maxY = y2;
            }
            if (minX == null && minY == null) {
                throw new IllegalArgumentException("Empty group : " + JDOMUtils.output(elem));
            }
            return new BigDecimal[]{minX, minY, maxX, maxY};
        }
        return OOXML.getLocalCoordinates(elem, svgNS, unit, horizontal, vertical);
    }

    private static final BigDecimal[] getLocalCoordinates(Element elem, Namespace svgNS, LengthUnit unit, boolean horizontal, boolean vertical) {
        BigDecimal endY;
        BigDecimal startY;
        BigDecimal endX;
        BigDecimal startX;
        BigDecimal x = OOXML.parseCoordinate(elem, "x", svgNS, unit);
        BigDecimal x1 = OOXML.parseCoordinate(elem, "x1", svgNS, unit);
        if (x == null && x1 == null) {
            return null;
        }
        BigDecimal y = OOXML.parseCoordinate(elem, "y", svgNS, unit);
        BigDecimal y1 = OOXML.parseCoordinate(elem, "y1", svgNS, unit);
        if (y == null && y1 == null) {
            throw new IllegalArgumentException("Have x but missing y in " + JDOMUtils.output(elem));
        }
        if (horizontal) {
            if (x == null) {
                startX = x1;
                endX = OOXML.parseCoordinate(elem, "x2", svgNS, unit);
            } else {
                startX = x;
                BigDecimal width = OOXML.parseLength(elem, "width", svgNS, unit);
                BigDecimal bigDecimal = endX = width == null ? null : startX.add(width);
            }
            if (endX == null) {
                return null;
            }
        } else {
            startX = null;
            endX = null;
        }
        if (vertical) {
            if (y == null) {
                startY = y1;
                endY = OOXML.parseCoordinate(elem, "y2", svgNS, unit);
            } else {
                startY = y;
                BigDecimal height = OOXML.parseLength(elem, "height", svgNS, unit);
                BigDecimal bigDecimal = endY = height == null ? null : startY.add(height);
            }
            if (endY == null) {
                return null;
            }
        } else {
            startY = null;
            endY = null;
        }
        return new BigDecimal[]{startX, startY, endX, endY};
    }

    /* synthetic */ OOXML(XMLFormatVersion xMLFormatVersion, String string, OOXML oOXML) {
        this(xMLFormatVersion, string);
    }

    private static class XML_OD
    extends OOXML {
        private final String schemaFile;
        private Schema schema = null;

        public XML_OD(String dateString, String versionString, String schemaFile) {
            super(XMLFormatVersion.get(XMLVersion.OD, versionString), dateString, null);
            this.schemaFile = schemaFile;
        }

        @Override
        public boolean canValidate() {
            return this.schemaFile != null;
        }

        private Schema getSchema() throws SAXException {
            if (this.schema == null && this.schemaFile != null) {
                this.schema = SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0").newSchema(this.getClass().getResource("oofficeDTDs/" + this.schemaFile));
            }
            return this.schema;
        }

        @Override
        public Validator getValidator(Document doc) {
            Schema schema;
            try {
                schema = this.getSchema();
            }
            catch (SAXException e) {
                throw new IllegalStateException("relaxNG schemas pb", e);
            }
            return schema == null ? null : new Validator.JAXPValidator(doc, schema);
        }

        @Override
        public final String[] getFontDecls() {
            return new String[]{"font-face-decls", "style:font-face"};
        }

        @Override
        public final Element getTab() {
            return new Element("tab", this.getVersion().getTEXT());
        }

        @Override
        public String getFrameQName() {
            return "draw:frame";
        }

        @Override
        public Element createFormattingProperties(String family) {
            return new Element(String.valueOf(family) + "-properties", this.getVersion().getSTYLE());
        }
    }

    private static final class XML_OD_1_0
    extends XML_OD {
        public XML_OD_1_0() {
            super("20061130", "1.0", null);
        }
    }

    private static final class XML_OD_1_1
    extends XML_OD {
        public XML_OD_1_1() {
            super("20070201", "1.1", "OpenDocument-strict-schema-v1.1.rng");
        }
    }

    private static final class XML_OD_1_2
    extends XML_OD {
        public XML_OD_1_2() {
            super("20110317", "1.2", "OpenDocument-v1.2-schema.rng");
        }
    }

    private static final class XML_OO
    extends OOXML {
        public XML_OO() {
            super(XMLFormatVersion.getOOo(), "20020501", null);
        }

        @Override
        public boolean canValidate() {
            return true;
        }

        @Override
        public Validator getValidator(Document doc) {
            Namespace[] namespaceArray = this.getVersion().getALL();
            int n = namespaceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Namespace n3 = namespaceArray[n2];
                doc.getRootElement().addNamespaceDeclaration(n3);
                ++n2;
            }
            return new Validator.DTDValidator(doc, OOUtils.getBuilderLoadDTD());
        }

        @Override
        public String[] getFontDecls() {
            return new String[]{"font-decls", "style:font-decl"};
        }

        @Override
        public final Element getTab() {
            return new Element("tab-stop", this.getVersion().getTEXT());
        }

        @Override
        public String getFrameQName() {
            return "draw:text-box";
        }

        @Override
        public Element createFormattingProperties(String family) {
            return new Element("properties", this.getVersion().getSTYLE());
        }
    }
}

