/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;
import org.openconcerto.openoffice.ChildCreator;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODSingleXMLDocument;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.OOXML;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.xml.JDOMUtils;
import org.openconcerto.xml.Validator;
import org.openconcerto.xml.XPathUtils;

public class ODXMLDocument {
    private static final Map<XMLVersion, List<Element>> ELEMS_ORDER = new HashMap<XMLVersion, List<Element>>(2);
    private static final Map<String, String> namePrefixes;
    private final Document content;
    private final XMLFormatVersion version;
    private final ChildCreator childCreator;
    protected static final ElementTransformer NOP_ElementTransformer;

    static {
        ELEMS_ORDER.put(XMLVersion.getOOo(), ODXMLDocument.createChildren(XMLVersion.getOOo()));
        ELEMS_ORDER.put(XMLVersion.getOD(), ODXMLDocument.createChildren(XMLVersion.getOD()));
        namePrefixes = new HashMap<String, String>();
        namePrefixes.put("table:table", "table");
        namePrefixes.put("text:a", "office");
        namePrefixes.put("draw:text-box", "draw");
        namePrefixes.put("draw:image", "draw");
        namePrefixes.put("draw:frame", "draw");
        NOP_ElementTransformer = new ElementTransformer(){

            @Override
            public Element transform(Element elem) {
                return elem;
            }
        };
    }

    private static final List<Element> createChildren(XMLVersion ins) {
        Namespace ns = ins.getOFFICE();
        ArrayList<Element> res = new ArrayList<Element>(8);
        res.add(new Element("meta", ns));
        res.add(new Element("settings", ns));
        res.add(new Element(ins == XMLVersion.OOo ? "script" : "scripts", ns));
        res.add(new Element(OOXML.getLast(ins).getFontDecls()[0], ns));
        res.add(new Element("styles", ns));
        res.add(new Element("automatic-styles", ns));
        res.add(new Element("master-styles", ns));
        res.add(new Element("body", ns));
        return res;
    }

    public static Set<String> getNamedElements() {
        return Collections.unmodifiableSet(namePrefixes.keySet());
    }

    public static final ODXMLDocument create(Document doc) {
        if (ODPackage.RootElement.fromDocument(doc) == ODPackage.RootElement.SINGLE_CONTENT) {
            return new ODSingleXMLDocument(doc);
        }
        return new ODXMLDocument(doc);
    }

    protected ODXMLDocument(Document content, XMLFormatVersion version) {
        if (content == null) {
            throw new NullPointerException("null document");
        }
        this.content = content;
        this.version = version;
        this.childCreator = new ChildCreator(this.content.getRootElement(), ELEMS_ORDER.get((Object)this.getVersion()));
    }

    public ODXMLDocument(Document content) {
        this(content, XMLFormatVersion.get(content.getRootElement()));
    }

    public ODXMLDocument(ODXMLDocument doc) {
        this((Document)doc.content.clone(), doc.version);
    }

    public Document getDocument() {
        return this.content;
    }

    public Validator getValidator() {
        return this.getXML().getValidator(this.getDocument());
    }

    public final OOXML getXML() {
        return this.getFormatVersion().getXML();
    }

    public final XMLFormatVersion getFormatVersion() {
        return this.version;
    }

    public final XMLVersion getVersion() {
        return this.getFormatVersion().getXMLVersion();
    }

    public final Element getChild(String childName) {
        return this.getChild(childName, false);
    }

    public Element getChild(String childName, boolean create) {
        return this.childCreator.getChild(this.getVersion().getOFFICE(), childName, create);
    }

    public void setChild(Element elem) {
        if (!elem.getNamespace().equals(this.getVersion().getOFFICE())) {
            throw new IllegalArgumentException("all children of a document belong to the office namespace.");
        }
        this.childCreator.setChild(elem);
    }

    protected final Element getDescendant(String path) throws JDOMException {
        return this.getDescendant(path, false);
    }

    protected final Element getDescendant(String path, boolean create) throws JDOMException {
        Element res = (Element)this.getXPath(path).selectSingleNode(this.getDocument().getRootElement());
        if (res == null && create) {
            Element parent = this.getDescendant(XPathUtils.parentOf(path), create);
            String namespace = XPathUtils.namespace(path);
            Namespace ns = namespace == null ? null : this.getVersion().getNS(namespace);
            res = new Element(XPathUtils.localName(path), ns);
            parent.addContent(res);
        }
        return res;
    }

    public final XPath getXPath(String string) throws JDOMException {
        return OOUtils.getXPath(string, this.getVersion());
    }

    public final Element getDescendantByName(String qName, String name) {
        return this.getDescendantByName(this.getDocument().getRootElement(), qName, name);
    }

    public final Element getDescendantByName(Element root, String qName, String name) {
        if (root.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("root is not part of this.");
        }
        if (!namePrefixes.containsKey(qName)) {
            throw new IllegalArgumentException(String.valueOf(qName) + " not in " + ODXMLDocument.getNamedElements());
        }
        String xp = ".//" + qName + "[@" + namePrefixes.get(qName) + ":name='" + name + "']";
        try {
            return (Element)this.getXPath(xp).selectSingleNode(root);
        }
        catch (JDOMException e) {
            throw new IllegalStateException("could not find " + xp, e);
        }
    }

    public final Element getStyle(StyleDesc<?> styleDesc, String name) {
        Namespace office;
        String family = styleDesc instanceof StyleStyleDesc ? ((StyleStyleDesc)styleDesc).getFamily() : null;
        Element root = this.getDocument().getRootElement();
        Element res = this.findStyleChild(root.getChild("styles", office = this.getVersion().getOFFICE()), styleDesc.getElementNS(), styleDesc.getElementName(), family, name);
        if (res != null) {
            return res;
        }
        res = this.findStyleChild(root.getChild("automatic-styles", office), styleDesc.getElementNS(), styleDesc.getElementName(), family, name);
        if (res != null) {
            return res;
        }
        Element masterStyles = root.getChild("master-styles", office);
        if (masterStyles != null && (res = this.findStyleChild(root.getChild("master-page", this.getVersion().getSTYLE()), styleDesc.getElementNS(), styleDesc.getElementName(), family, name)) != null) {
            return res;
        }
        return null;
    }

    public final Element getDefaultStyle(StyleStyleDesc<?> styleDesc) {
        Element root = this.getDocument().getRootElement();
        Namespace office = this.getVersion().getOFFICE();
        return this.findStyleChild(root.getChild("styles", office), styleDesc.getElementNS(), "default-style", styleDesc.getFamily(), null);
    }

    private final Element findStyleChild(Element styles, Namespace elemNS, String elemName, String family, String name) {
        if (styles == null) {
            return null;
        }
        Namespace styleNS = this.getVersion().getSTYLE();
        for (Object o : styles.getChildren(elemName, elemNS)) {
            Element styleElem = (Element)o;
            if (name != null && !name.equals(styleElem.getAttributeValue("name", styleNS)) || family != null && !family.equals(StyleStyleDesc.getFamily(styleElem))) continue;
            return styleElem;
        }
        return null;
    }

    public final String findUnusedName(StyleDesc<?> desc, String baseName) {
        int i = 0;
        while (i < 1000) {
            String name = String.valueOf(baseName) + i;
            Element elem = this.getStyle(desc, name);
            if (elem == null) {
                return name;
            }
            ++i;
        }
        return null;
    }

    public final void addAutoStyle(Element styleElem) {
        this.getChild("automatic-styles", true).addContent(styleElem);
    }

    public String asString() {
        return JDOMUtils.output(this.content);
    }

    protected void mergeAll(ODXMLDocument other, String path) throws JDOMException {
        this.mergeAll(other, path, null);
    }

    protected void mergeAll(ODXMLDocument other, String path, ElementTransformer addTransf) throws JDOMException {
        this.add(path, -1, other, path, addTransf);
    }

    protected void add(final String lpath, int lindex, ODXMLDocument other, String rpath, ElementTransformer addTransf) throws JDOMException {
        this.add(new IFactory<Element>(){

            @Override
            public Element createChecked() {
                try {
                    return ODXMLDocument.this.getDescendant(lpath, true);
                }
                catch (JDOMException e) {
                    throw new IllegalStateException("error", e);
                }
            }
        }, lindex, other, rpath, addTransf);
    }

    protected void add(final Element elem, int lindex, ODXMLDocument other, String rpath, ElementTransformer addTransf) throws JDOMException {
        if (elem == null) {
            this.mergeAll(other, rpath, addTransf);
        } else {
            if (!this.getDocument().getRootElement().isAncestor(elem)) {
                throw new IllegalArgumentException(elem + " not part of " + this);
            }
            this.add(new IFactory<Element>(){

                @Override
                public Element createChecked() {
                    return elem;
                }
            }, lindex, other, rpath, addTransf);
        }
    }

    protected final void add(IFactory<Element> elemF, int lindex, ODXMLDocument other, String rpath, ElementTransformer addTransf) throws JDOMException {
        Element toAdd = other.getDescendant(rpath);
        if (toAdd != null) {
            ArrayList<Element> listToAdd;
            ArrayList<Element> cloned = toAdd.cloneContent();
            if (addTransf == null) {
                listToAdd = cloned;
            } else {
                listToAdd = new ArrayList<Element>(cloned.size());
                for (Content content : cloned) {
                    Element transformedElem;
                    if (!(content instanceof Element) || (transformedElem = addTransf.transform((Element)content)) == null) continue;
                    listToAdd.add(transformedElem);
                }
            }
            Element thisElem = elemF.createChecked();
            if (lindex < 0) {
                thisElem.addContent(listToAdd);
            } else {
                thisElem.addContent(lindex, listToAdd);
            }
        }
    }

    protected final void addIfNotPresent(ODXMLDocument doc, String path) throws JDOMException {
        this.addIfNotPresent(doc, path, -1);
    }

    protected final void addIfNotPresent(ODXMLDocument doc, String path, int index) throws JDOMException {
        Element otherElem;
        Element myElem = this.getDescendant(path);
        if (myElem == null && (otherElem = doc.getDescendant(path)) != null) {
            Element myParent = this.getDescendant(XPathUtils.parentOf(path));
            if (index == -1) {
                myParent.addContent((Element)otherElem.clone());
            } else {
                myParent.addContent(index, (Element)otherElem.clone());
            }
        }
    }

    protected static interface ElementTransformer {
        public Element transform(Element var1) throws JDOMException;
    }
}

