/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.jdom.Attribute;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openconcerto.openoffice.ContentType;
import org.openconcerto.openoffice.ContentTypeVersioned;
import org.openconcerto.openoffice.Manifest;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.ODMeta;
import org.openconcerto.openoffice.ODPackageEntry;
import org.openconcerto.openoffice.ODSingleXMLDocument;
import org.openconcerto.openoffice.ODXMLDocument;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.OOXML;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.openoffice.text.TextDocument;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CopyUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.StringInputStream;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.Zip;
import org.openconcerto.utils.ZippedFilesProcessor;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.io.DataInputStream;
import org.openconcerto.xml.JDOMUtils;

public class ODPackage {
    private static final XMLOutputter OUTPUTTER = new XMLOutputter(Format.getRawFormat());
    static final String MIMETYPE_ENTRY = "mimetype";
    static final Charset MIMETYPE_ENC = Charset.forName("UTF-8");
    private static final Set<String> subdocNames = new HashSet<String>();
    private static final int mimetypeZipEndOffset = 250;
    private final Map<String, ODPackageEntry> files = new HashMap<String, ODPackageEntry>();
    private ContentTypeVersioned type = null;
    private XMLFormatVersion version = null;
    private File file = null;
    private ODDocument doc = null;

    static {
        for (RootElement r : RootElement.getPackageElements()) {
            if (r.getZipEntry() == null) continue;
            subdocNames.add(r.getZipEntry());
        }
    }

    public static final boolean isStandardFile(String name) {
        return name.equals(MIMETYPE_ENTRY) || subdocNames.contains(name) || name.startsWith("Thumbnails") || name.startsWith("META-INF") || name.startsWith("Configurations");
    }

    public static ODPackage createFromDocuments(Document content, Document style) {
        return ODPackage.createFromDocuments(null, content, style, null, null);
    }

    public static ODPackage createFromDocuments(ContentTypeVersioned type, Document content, Document style, Document meta, Document settings) {
        ODPackage pkg = new ODPackage();
        if (type != null) {
            pkg.setContentType(type);
        }
        pkg.putFile(RootElement.CONTENT.getZipEntry(), content);
        pkg.putFile(RootElement.STYLES.getZipEntry(), style);
        pkg.putFile(RootElement.META.getZipEntry(), meta);
        pkg.putFile(RootElement.SETTINGS.getZipEntry(), settings);
        return pkg;
    }

    public static ODPackage createFromStream(InputStream ins, String name) throws IOException {
        try {
            ODPackage oDPackage = ODPackage.create(null, ins, name);
            return oDPackage;
        }
        finally {
            ins.close();
        }
    }

    public static ODPackage createFromFile(File f) throws IOException {
        FileInputStream ins = new FileInputStream(f);
        try {
            ODPackage oDPackage = ODPackage.create(f, ins, f.getName());
            return oDPackage;
        }
        finally {
            ins.close();
        }
    }

    private static ODPackage create(File f, InputStream ins, String name) throws IOException {
        ODPackage res;
        Tuple2 fromExt = name != null ? ContentTypeVersioned.fromExtension(FileUtils.getExtension(name)) : Tuple2.nullInstance();
        ContentTypeVersioned contentType = (ContentTypeVersioned)((Object)fromExt.get0());
        Boolean flat = (Boolean)fromExt.get1();
        if (flat == null) {
            ins = new BufferedInputStream(ins);
            String xmlStart = "<?xml";
            if (!ins.markSupported()) {
                throw new IllegalStateException("Mark unsupported on " + ins);
            }
            ins.mark(Math.max("<?xml".length(), 250));
            byte[] buffer = new byte["<?xml".length()];
            ins.read(buffer);
            if ("<?xml".equals(new String(buffer, StringUtils.ASCII))) {
                contentType = null;
                flat = true;
            } else {
                ins.reset();
                contentType = ODPackage.getType(ins);
                if (contentType != null) {
                    flat = false;
                }
            }
            ins.reset();
        }
        if (flat == null) {
            res = null;
        } else if (flat.booleanValue()) {
            try {
                res = (f != null ? ODSingleXMLDocument.createFromFile(f) : ODSingleXMLDocument.createFromStream(ins)).getPackage();
            }
            catch (JDOMException e) {
                throw new IOException(e);
            }
        } else {
            ODPackage oDPackage = res = f != null ? new ODPackage(f) : new ODPackage(ins);
        }
        assert (contentType == null || contentType == res.getContentType());
        return res;
    }

    private static ContentTypeVersioned getType(InputStream in) throws IOException {
        int uncompressedSize;
        DataInputStream ins = new DataInputStream(in, true);
        if (ins.read() != 80 || ins.read() != 75) {
            return null;
        }
        if (ins.skip(16L) != 16L) {
            return null;
        }
        int compressedSize = ins.readInt();
        if (compressedSize != (uncompressedSize = ins.readInt())) {
            return null;
        }
        short fnameLength = ins.readShort();
        if (fnameLength != MIMETYPE_ENTRY.length()) {
            return null;
        }
        short extraLength = ins.readShort();
        byte[] array = new byte[Math.max(fnameLength, compressedSize)];
        ins.read(array, 0, fnameLength);
        if (!new String(array, 0, (int)fnameLength, StringUtils.ASCII).equals(MIMETYPE_ENTRY)) {
            return null;
        }
        if (ins.skip(extraLength) != (long)extraLength) {
            return null;
        }
        ins.read(array, 0, compressedSize);
        String data = new String(array, 0, compressedSize, MIMETYPE_ENC);
        return ContentTypeVersioned.fromMime(data);
    }

    private static XMLVersion getVersion(XMLFormatVersion fv, ContentTypeVersioned ct) {
        XMLVersion v = ct == null && fv == null ? null : (ct != null ? ct.getVersion() : fv.getXMLVersion());
        assert (fv == null || ct == null || fv.getXMLVersion() == ct.getVersion());
        return v;
    }

    private static <T> void checkVersion(Class<T> clazz, String s, T actual, T required) {
        boolean ok;
        if (actual != null && required != null && !(ok = actual instanceof ContentTypeVersioned ? ((ContentTypeVersioned)((Object)actual)).getNonTemplate().equals((Object)((ContentTypeVersioned)((Object)required)).getNonTemplate()) : actual.equals(required))) {
            throw new IllegalArgumentException("Cannot change " + s + " from " + required + " to " + actual);
        }
    }

    public ODPackage() {
    }

    public ODPackage(InputStream ins) throws IOException {
        this();
        final ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        new ZippedFilesProcessor(){

            @Override
            protected void processEntry(ZipEntry entry, InputStream in) throws IOException {
                Object res;
                String name = entry.getName();
                if (subdocNames.contains(name)) {
                    try {
                        res = OOUtils.getBuilder().build(in);
                    }
                    catch (JDOMException e) {
                        throw new IllegalStateException("parse error", e);
                    }
                } else {
                    out.reset();
                    StreamUtils.copy(in, out);
                    res = out.toByteArray();
                }
                ODPackage.this.putFile(name, res, null, entry.getMethod() == 8);
            }
        }.process(ins);
        ODPackageEntry me = this.files.remove("META-INF/manifest.xml");
        if (me != null) {
            byte[] m = (byte[])me.getData();
            try {
                Map<String, String> manifestEntries = Manifest.parse(new ByteArrayInputStream(m));
                for (Map.Entry<String, String> e : manifestEntries.entrySet()) {
                    String path = e.getKey();
                    ODPackageEntry entry = this.files.get(path);
                    if (entry == null) {
                        this.files.put(path, new ODPackageEntry(path, e.getValue(), null));
                        continue;
                    }
                    entry.setType(e.getValue());
                }
            }
            catch (JDOMException e) {
                throw new IllegalArgumentException("bad manifest " + new String(m), e);
            }
        }
    }

    public ODPackage(File f) throws IOException {
        this(new BufferedInputStream(new FileInputStream(f), 524288));
        this.file = f;
    }

    public ODPackage(ODPackage o) {
        this();
        for (String name : o.getEntries()) {
            ODPackageEntry entry = o.getEntry(name);
            Object data = entry.getData();
            Object myData = data instanceof byte[] ? data : (data instanceof ODSingleXMLDocument ? new ODSingleXMLDocument((ODSingleXMLDocument)data, this) : CopyUtils.copy(data));
            this.putFile(name, myData, entry.getType(), entry.isCompressed());
        }
        this.type = o.type;
        this.version = o.version;
        this.file = o.file;
        this.doc = null;
    }

    public final File getFile() {
        return this.file;
    }

    public final void setFile(File f) {
        this.file = this.addExt(f);
    }

    private final File addExt(File f) {
        String ext = String.valueOf('.') + this.getContentType().getExtension();
        if (!f.getName().endsWith(ext)) {
            f = new File(f.getParentFile(), String.valueOf(f.getName()) + ext);
        }
        return f;
    }

    public final XMLVersion getVersion() {
        return ODPackage.getVersion(this.version, this.type);
    }

    public final XMLFormatVersion getFormatVersion() {
        return this.version;
    }

    public final ContentTypeVersioned getContentType() {
        return this.type;
    }

    public final void setContentType(ContentTypeVersioned newType) {
        this.putFile(MIMETYPE_ENTRY, newType.getMimeType().getBytes(MIMETYPE_ENC));
    }

    private void updateTypeAndVersion(String entry, ODXMLDocument xml) {
        this.setTypeAndVersion(entry.equals(RootElement.CONTENT.getZipEntry()) ? ContentTypeVersioned.fromContent(xml) : null, xml.getFormatVersion(), entry);
    }

    private void updateTypeAndVersion(byte[] mimetype) {
        this.setTypeAndVersion(ContentTypeVersioned.fromMime(mimetype), null, MIMETYPE_ENTRY);
    }

    private final void setTypeAndVersion(ContentTypeVersioned ct, XMLFormatVersion fv, String entry) {
        Tuple3<XMLVersion, ContentTypeVersioned, XMLFormatVersion> requiredByPkg = this.getRequired(entry);
        if (requiredByPkg != null) {
            ODPackage.checkVersion(XMLVersion.class, "version", ODPackage.getVersion(fv, ct), (XMLVersion)((Object)requiredByPkg.get0()));
            ODPackage.checkVersion(ContentTypeVersioned.class, "type", ct, (ContentTypeVersioned)((Object)requiredByPkg.get1()));
            ODPackage.checkVersion(XMLFormatVersion.class, "format version", fv, requiredByPkg.get2());
        }
        if (fv != null && !fv.equals(this.version)) {
            this.version = fv;
        }
        if (ct != null && !ct.equals((Object)this.type) && (this.type == null || entry.equals(MIMETYPE_ENTRY))) {
            this.type = ct;
        }
    }

    private final Tuple3<XMLVersion, ContentTypeVersioned, XMLFormatVersion> getRequired(String entryToIgnore) {
        if (this.files.size() == 0 || this.files.size() == 1 && this.files.containsKey(entryToIgnore)) {
            return null;
        }
        byte[] mimetype = this.files.containsKey(MIMETYPE_ENTRY) && !MIMETYPE_ENTRY.equals(entryToIgnore) ? this.getBinaryFile(MIMETYPE_ENTRY) : (byte[])null;
        XMLFormatVersion fv = null;
        HashMap<String, ODXMLDocument> versionFiles = new HashMap<String, ODXMLDocument>();
        for (String e : subdocNames) {
            if (!this.files.containsKey(e) || e.equals(entryToIgnore)) continue;
            ODXMLDocument xmlFile = this.getXMLFile(e);
            versionFiles.put(e, xmlFile);
            if (fv == null) {
                fv = xmlFile.getFormatVersion();
                continue;
            }
            assert (fv.equals(xmlFile.getFormatVersion())) : "Incoherence";
        }
        ODXMLDocument content = (ODXMLDocument)versionFiles.get(RootElement.CONTENT.getZipEntry());
        ContentTypeVersioned ct = mimetype != null ? ContentTypeVersioned.fromMime(mimetype) : (content != null ? ContentTypeVersioned.fromContent(content) : null);
        return Tuple3.create(ODPackage.getVersion(fv, ct), ct, fv);
    }

    public final String getMimeType() {
        return this.getContentType().getMimeType();
    }

    public final boolean isTemplate() {
        return this.getContentType().isTemplate();
    }

    public final void setTemplate(boolean b) {
        ContentTypeVersioned newType;
        if (this.type == null) {
            throw new IllegalStateException("No type");
        }
        ContentTypeVersioned contentTypeVersioned = newType = b ? this.type.getTemplate() : this.type.getNonTemplate();
        if (newType == null) {
            throw new IllegalStateException("Missing " + (b ? "" : "non-") + "template for " + (Object)((Object)this.type));
        }
        this.setContentType(newType);
    }

    public final Map<String, String> validateSubDocuments() {
        return this.validateSubDocuments(true);
    }

    public final Map<String, String> validateSubDocuments(boolean allowChangeToValidate) {
        OOXML ooxml = this.getFormatVersion().getXML();
        if (!ooxml.canValidate()) {
            return null;
        }
        HashMap<String, String> res = new HashMap<String, String>();
        for (String s : subdocNames) {
            String valid;
            DocType docType;
            Document doc = this.getDocument(s);
            if (doc == null) continue;
            if (allowChangeToValidate && (docType = RootElement.fromDocument(doc).createDocType(ooxml.getVersion())) != null && doc.getDocType() == null) {
                doc.setDocType(docType);
            }
            if ((valid = ooxml.getValidator(doc).isValid()) == null) continue;
            res.put(s, valid);
        }
        return res;
    }

    public final ODDocument getODDocument() {
        if (this.doc == null) {
            ContentType ct = this.getContentType().getType();
            if (ct.equals((Object)ContentType.SPREADSHEET)) {
                this.doc = SpreadSheet.get(this);
            } else if (ct.equals((Object)ContentType.TEXT)) {
                this.doc = TextDocument.get(this);
            }
        }
        return this.doc;
    }

    public final boolean hasODDocument() {
        return this.doc != null;
    }

    public final SpreadSheet getSpreadSheet() {
        return (SpreadSheet)this.getODDocument();
    }

    public final TextDocument getTextDocument() {
        return (TextDocument)this.getODDocument();
    }

    public final Set<String> getEntries() {
        return this.files.keySet();
    }

    public final ODPackageEntry getEntry(String entry) {
        return this.files.get(entry);
    }

    protected final Object getData(String entry) {
        ODPackageEntry e = this.getEntry(entry);
        return e == null ? null : e.getData();
    }

    public final byte[] getBinaryFile(String entry) {
        return (byte[])this.getData(entry);
    }

    public final ODXMLDocument getXMLFile(String xmlEntry) {
        return (ODXMLDocument)this.getData(xmlEntry);
    }

    public final ODXMLDocument getXMLFile(Document doc) {
        for (String s : subdocNames) {
            ODXMLDocument xmlFile = this.getXMLFile(s);
            if (xmlFile == null || xmlFile.getDocument() != doc) continue;
            return xmlFile;
        }
        return null;
    }

    public final ODXMLDocument getStyles() {
        ODXMLDocument res = this.isSingle() ? this.getContent() : this.getXMLFile(RootElement.STYLES.getZipEntry());
        return res;
    }

    public final ODXMLDocument getContent() {
        return this.getXMLFile(RootElement.CONTENT.getZipEntry());
    }

    public final ODMeta getMeta() {
        ODMeta meta = this.getEntries().contains(RootElement.META.getZipEntry()) ? ODMeta.create(this.getXMLFile(RootElement.META.getZipEntry())) : ODMeta.create(this.getContent());
        return meta;
    }

    public Document getDocument(String xmlEntry) {
        ODXMLDocument xml = this.getXMLFile(xmlEntry);
        return xml == null ? null : xml.getDocument();
    }

    public final Element getStyle(StyleDesc<?> desc, String name) {
        return this.getStyle(this.getContent().getDocument(), desc, name);
    }

    public final Element getStyle(Document referent, StyleDesc<?> desc, String name) {
        String[] stylesContainer;
        if (name == null) {
            return null;
        }
        String refSubDoc = null;
        String[] stringArray = stylesContainer = new String[]{RootElement.CONTENT.getZipEntry(), RootElement.STYLES.getZipEntry()};
        int n = stylesContainer.length;
        int n2 = 0;
        while (n2 < n) {
            String subDoc = stringArray[n2];
            if (this.getDocument(subDoc) == referent) {
                refSubDoc = subDoc;
            }
            ++n2;
        }
        if (refSubDoc == null) {
            throw new IllegalArgumentException("neither in content nor styles : " + referent);
        }
        Element res = this.getXMLFile(refSubDoc).getStyle(desc, name);
        if (res == null && refSubDoc.equals(stylesContainer[0]) && this.getXMLFile(stylesContainer[1]) != null) {
            res = this.getXMLFile(stylesContainer[1]).getStyle(desc, name);
        }
        return res;
    }

    public final Element getDefaultStyle(StyleStyleDesc<?> desc) {
        return this.getStyles().getDefaultStyle(desc);
    }

    public final String checkStyles() {
        Element styles;
        ODXMLDocument stylesDoc = this.getStyles();
        ODXMLDocument contentDoc = this.getContent();
        if (stylesDoc != null) {
            styles = stylesDoc.getChild("styles");
            String res = ODPackage.checkStyles(stylesDoc, styles);
            if (res != null) {
                return res;
            }
        } else {
            styles = contentDoc.getChild("styles");
        }
        return ODPackage.checkStyles(contentDoc, styles);
    }

    private static final String checkStyles(ODXMLDocument doc, Element styles) {
        try {
            CollectionMap<String, String> stylesNames = ODPackage.getStylesNames(doc, styles, doc.getChild("automatic-styles"));
            HashSet<String> names = new HashSet<String>(stylesNames.values());
            for (Attribute attr : doc.getXPath(".//@text:style-name | .//@table:style-name | .//@draw:style-name | .//@style:data-style-name | .//@style:list-style-name").selectNodes(doc.getDocument())) {
                if (names.contains(attr.getValue())) continue;
                return "unknown style referenced by " + attr.getName() + " in " + JDOMUtils.output(attr.getParent());
            }
        }
        catch (IllegalStateException e) {
            return ExceptionUtils.getStackTrace(e);
        }
        catch (JDOMException e) {
            return ExceptionUtils.getStackTrace(e);
        }
        return null;
    }

    private static final CollectionMap<String, String> getStylesNames(ODXMLDocument doc, Element styles, Element autoStyles) throws IllegalStateException {
        CollectionMap<String, String> res = new CollectionMap<String, String>(HashSet.class);
        ArrayList<Element> nodes = new ArrayList<Element>();
        if (styles != null) {
            nodes.add(styles);
        }
        if (autoStyles != null) {
            nodes.add(autoStyles);
        }
        try {
            for (Attribute attr : doc.getXPath("./style:style/@style:name").selectNodes(nodes)) {
                String styleName = attr.getValue();
                String family = attr.getParent().getAttributeValue("family", attr.getNamespace());
                if (res.getNonNull(family).contains(styleName)) {
                    throw new IllegalStateException("duplicate style in " + family + " :  " + styleName);
                }
                res.put((Object)family, (Object)styleName);
            }
            List<String> dataStyles = Arrays.asList("number-style", "currency-style", "percentage-style", "date-style", "time-style", "boolean-style", "text-style");
            String xpDataStyles = CollectionUtils.join(dataStyles, " | ", new ITransformer<String, String>(){

                @Override
                public String transformChecked(String input) {
                    return "./number:" + input;
                }
            });
            for (Element elem : doc.getXPath("./text:list-style | " + xpDataStyles).selectNodes(nodes)) {
                res.put((Object)elem.getQualifiedName(), (Object)elem.getAttributeValue("name", doc.getVersion().getSTYLE()));
            }
        }
        catch (JDOMException e) {
            throw new IllegalStateException(e);
        }
        return res;
    }

    public void putFile(String entry, Object data) {
        this.putFile(entry, data, null);
    }

    public void putFile(String entry, Object data, String mediaType) {
        this.putFile(entry, data, mediaType, true);
    }

    public void putFile(String entry, Object data, String mediaType, boolean compress) {
        Object myData;
        if (entry == null) {
            throw new NullPointerException("null name");
        }
        if (data == null) {
            this.rmFile(entry);
            return;
        }
        if (subdocNames.contains(entry)) {
            ODXMLDocument oodoc = data instanceof Document ? ODXMLDocument.create((Document)data) : (ODXMLDocument)data;
            this.checkEntryForDocument(entry);
            this.updateTypeAndVersion(entry, oodoc);
            myData = oodoc;
        } else {
            if (!(data instanceof byte[])) {
                throw new IllegalArgumentException("should be byte[] for " + entry + ": " + data);
            }
            if (entry.equals(MIMETYPE_ENTRY)) {
                this.updateTypeAndVersion((byte[])data);
            }
            myData = data;
        }
        String inferredType = mediaType != null ? mediaType : FileUtils.findMimeType(entry);
        this.files.put(entry, new ODPackageEntry(entry, inferredType, myData, compress));
    }

    private void checkEntryForDocument(String entry) {
        if (this.hasODDocument() && (entry.equals(RootElement.CONTENT.getZipEntry()) || entry.equals(RootElement.STYLES.getZipEntry()))) {
            throw new IllegalArgumentException("Cannot change content or styles with existing ODDocument");
        }
    }

    public void rmFile(String entry) {
        this.checkEntryForDocument(entry);
        this.files.remove(entry);
        if (entry.equals(MIMETYPE_ENTRY) || subdocNames.contains(entry)) {
            Tuple3<XMLVersion, ContentTypeVersioned, XMLFormatVersion> required = this.getRequired(entry);
            this.type = required == null ? null : (ContentTypeVersioned)((Object)required.get1());
            this.version = required == null ? null : required.get2();
        }
    }

    public void clear() {
        this.files.clear();
        this.type = null;
        this.version = null;
    }

    public ODSingleXMLDocument toSingle() {
        if (!this.isSingle()) {
            return ODSingleXMLDocument.create(this);
        }
        return (ODSingleXMLDocument)this.getContent();
    }

    public final boolean isSingle() {
        return this.getContent() instanceof ODSingleXMLDocument;
    }

    public final boolean split() {
        boolean res;
        if (this.isSingle()) {
            Map<RootElement, Document> split = ((ODSingleXMLDocument)this.getContent()).split();
            assert ((split.containsKey((Object)RootElement.CONTENT) || split.containsKey((Object)RootElement.STYLES)) && RootElement.getPackageElements().containsAll(split.keySet())) : "wrong elements " + split;
            XMLFormatVersion version = this.getFormatVersion();
            for (Map.Entry<RootElement, Document> e : split.entrySet()) {
                this.putFile(e.getKey().getZipEntry(), new ODXMLDocument(e.getValue(), version));
            }
            res = true;
        } else {
            res = false;
        }
        assert (!this.isSingle());
        return res;
    }

    public final void save(OutputStream out) throws IOException {
        if (this.isSingle()) {
            assert (this.getClass() == ODPackage.class);
            ODPackage copy2 = new ODPackage(this);
            copy2.split();
            copy2.save(out);
            return;
        }
        Zip z = new Zip(out);
        z.zipNonCompressed(MIMETYPE_ENTRY, this.getMimeType().getBytes(MIMETYPE_ENC));
        Manifest manifest = new Manifest(this.getVersion(), this.getMimeType());
        for (String name : this.files.keySet()) {
            String mediaType;
            if (name.equals(MIMETYPE_ENTRY) || name.equals("META-INF/manifest.xml")) continue;
            ODPackageEntry entry = this.files.get(name);
            Object val = entry.getData();
            if (val != null) {
                if (val instanceof ODXMLDocument) {
                    OutputStream o = z.createEntry(name);
                    OUTPUTTER.output(((ODXMLDocument)val).getDocument(), o);
                    o.close();
                } else {
                    z.zip(name, (byte[])val, entry.isCompressed());
                }
            }
            manifest.addEntry(name, (mediaType = entry.getType()) == null ? "" : mediaType);
        }
        z.zip("META-INF/manifest.xml", new StringInputStream(manifest.asString()));
        z.close();
    }

    public File save() throws IOException {
        return this.saveAs(this.getFile());
    }

    public File saveAs(File fNoExt) throws IOException {
        File f = this.addExt(fNoExt);
        if (f.getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(f);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(out, 524288);
        try {
            this.save(bufferedOutputStream);
        }
        finally {
            bufferedOutputStream.close();
        }
        return f;
    }

    public static enum RootElement {
        SINGLE_CONTENT("office", "document", null),
        CONTENT("office", "document-content", "content.xml"),
        STYLES("office", "document-styles", "styles.xml"),
        META("office", "document-meta", "meta.xml"),
        SETTINGS("office", "document-settings", "settings.xml");

        private final String nsPrefix;
        private final String name;
        private final String zipEntry;

        public static final EnumSet<RootElement> getPackageElements() {
            return EnumSet.of(CONTENT, STYLES, META, SETTINGS);
        }

        public static final RootElement fromDocument(Document doc) {
            return RootElement.fromElementName(doc.getRootElement().getName());
        }

        public static final RootElement fromElementName(String name) {
            RootElement[] rootElementArray = RootElement.values();
            int n = rootElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                RootElement e = rootElementArray[n2];
                if (e.getElementName().equals(name)) {
                    return e;
                }
                ++n2;
            }
            return null;
        }

        static final Document createSingle(Document from) {
            return SINGLE_CONTENT.createDocument(XMLFormatVersion.get(from));
        }

        private RootElement(String prefix, String rootName, String zipEntry) {
            this.nsPrefix = prefix;
            this.name = rootName;
            this.zipEntry = zipEntry;
        }

        public final String getElementNSPrefix() {
            return this.nsPrefix;
        }

        public final String getElementName() {
            return this.name;
        }

        public final Document createDocument(XMLFormatVersion fv) {
            XMLVersion version = fv.getXMLVersion();
            Element root = new Element(this.getElementName(), version.getNS(this.getElementNSPrefix()));
            if (fv.getOfficeVersion() != null) {
                root.setAttribute("version", fv.getOfficeVersion(), version.getOFFICE());
            }
            Namespace[] namespaceArray = version.getALL();
            int n = namespaceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Namespace ns = namespaceArray[n2];
                root.addNamespaceDeclaration(ns);
                ++n2;
            }
            return new Document(root, this.createDocType(version));
        }

        public final DocType createDocType(XMLVersion version) {
            if (version == XMLVersion.OOo) {
                return new DocType(String.valueOf(this.getElementNSPrefix()) + ":" + this.getElementName(), "-//OpenOffice.org//DTD OfficeDocument 1.0//EN", "office.dtd");
            }
            return null;
        }

        public final String getZipEntry() {
            return this.zipEntry;
        }
    }
}

