/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import org.openconcerto.utils.TimeUtils;

public final class ODEpoch {
    private static final BigDecimal MS_PER_DAY = BigDecimal.valueOf(86400000L);
    private static final DateFormat DATE_FORMAT;
    private static final ODEpoch DEFAULT_EPOCH;
    private static final Map<String, ODEpoch> cache;
    private final String dateString;
    private final Calendar epochUTC;

    static {
        cache = new LinkedHashMap<String, ODEpoch>(4, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ODEpoch> eldest) {
                return this.size() > 16;
            }
        };
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        DATE_FORMAT.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        try {
            DEFAULT_EPOCH = new ODEpoch("1899-12-30");
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final ODEpoch getDefaultEpoch() {
        return DEFAULT_EPOCH;
    }

    public static final ODEpoch getInstance(String date) throws ParseException {
        if (date == null || date.equals(DEFAULT_EPOCH.getDateString())) {
            return DEFAULT_EPOCH;
        }
        ODEpoch res = cache.get(date);
        if (res == null) {
            res = new ODEpoch(date);
            cache.put(date, res);
        }
        return res;
    }

    private static final Calendar parse(String date) throws ParseException {
        Calendar cal = (Calendar)DATE_FORMAT.getCalendar().clone();
        cal.setTime(DATE_FORMAT.parse(date));
        return cal;
    }

    private ODEpoch(String date) throws ParseException {
        this.dateString = date;
        this.epochUTC = ODEpoch.parse(date);
        assert (this.epochUTC.getTimeZone().equals(DATE_FORMAT.getTimeZone()));
    }

    public final String getDateString() {
        return this.dateString;
    }

    public final Calendar getCalendar() {
        return (Calendar)this.epochUTC.clone();
    }

    private final Calendar getDate(Duration duration) {
        Calendar res = this.getCalendar();
        duration.addTo(res);
        return res;
    }

    public final Duration normalizeToDays(Duration dur) {
        Duration res;
        Duration duration = res = dur.getYears() == 0 && dur.getMonths() == 0 ? dur : ODEpoch.getDuration(this.getDays(dur));
        assert (res.getYears() == 0 && res.getMonths() == 0);
        return res;
    }

    public final Duration normalizeToHours(Duration dur) {
        Duration durationInDays = this.normalizeToDays(dur);
        BigInteger days = (BigInteger)durationInDays.getField(DatatypeConstants.DAYS);
        BigInteger hours = ((BigInteger)durationInDays.getField(DatatypeConstants.HOURS)).add(days.multiply(BigInteger.valueOf(24L)));
        return TimeUtils.getTypeFactory().newDuration(days.signum() >= 0, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, hours, (BigInteger)durationInDays.getField(DatatypeConstants.MINUTES), (BigDecimal)durationInDays.getField(DatatypeConstants.SECONDS));
    }

    public final BigDecimal getDays(Duration duration) {
        return this.getDays(this.getDate(duration));
    }

    public final BigDecimal getDays(Calendar cal) {
        long diff = TimeUtils.normalizeLocalTime(cal) - this.epochUTC.getTimeInMillis();
        return BigDecimal.valueOf(diff).divide(MS_PER_DAY, MathContext.DECIMAL128);
    }

    public final Calendar getDate(BigDecimal days) {
        return this.getDate(days, Calendar.getInstance());
    }

    public final Calendar getDate(BigDecimal days, Calendar res) {
        Calendar utcCal = this.getDate(ODEpoch.getDuration(days));
        return TimeUtils.copyLocalTime(utcCal, res);
    }

    private static final Duration getDuration(BigDecimal days) {
        BigDecimal posDays = days.abs();
        BigInteger wholeDays = posDays.toBigInteger().abs();
        BigDecimal hours = posDays.subtract(new BigDecimal(wholeDays)).multiply(BigDecimal.valueOf(24L));
        BigInteger wholeHours = hours.toBigInteger();
        BigDecimal minutes = hours.subtract(new BigDecimal(wholeHours)).multiply(BigDecimal.valueOf(60L));
        BigInteger wholeMinutes = minutes.toBigInteger();
        BigDecimal seconds = minutes.subtract(new BigDecimal(wholeMinutes)).multiply(BigDecimal.valueOf(60L)).round(MathContext.DECIMAL64);
        return TimeUtils.getTypeFactory().newDuration(days.signum() >= 0, BigInteger.ZERO, BigInteger.ZERO, wholeDays, wholeHours, wholeMinutes, seconds);
    }
}

